/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.imagecapture.AutoValue_Bitmap2JpegBytes_In;
import androidx.camera.core.processing.Operation;
import androidx.camera.core.processing.Packet;
import com.google.auto.value.AutoValue;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Objects;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Bitmap2JpegBytes
implements Operation<In, Packet<byte[]>> {
    @Override
    @NonNull
    public Packet<byte[]> apply(@NonNull In in) throws ImageCaptureException {
        Packet<Bitmap> packet = in.getPacket();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        packet.getData().compress(Bitmap.CompressFormat.JPEG, in.getJpegQuality(), (OutputStream)outputStream);
        return Packet.of(outputStream.toByteArray(), Objects.requireNonNull(packet.getExif()), Bitmap2JpegBytes.getOutputFormat(packet.getData()), packet.getSize(), packet.getCropRect(), packet.getRotationDegrees(), packet.getSensorToBufferTransform(), packet.getCameraCaptureResult());
    }

    private static int getOutputFormat(@NonNull Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 34 && Api34Impl.hasGainmap(bitmap)) {
            return 4101;
        }
        return 256;
    }

    @AutoValue
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static abstract class In {
        abstract Packet<Bitmap> getPacket();

        abstract int getJpegQuality();

        @NonNull
        public static In of(@NonNull Packet<Bitmap> imagePacket, int jpegQuality) {
            return new AutoValue_Bitmap2JpegBytes_In(imagePacket, jpegQuality);
        }
    }

    @RequiresApi(value=34)
    private static class Api34Impl {
        static boolean hasGainmap(@NonNull Bitmap bitmap) {
            return bitmap.hasGainmap();
        }

        private Api34Impl() {
        }
    }
}

