/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.DngCreator;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.imagecapture.AutoValue_DngImage2Disk_In;
import androidx.camera.core.imagecapture.FileUtil;
import androidx.camera.core.processing.Operation;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DngImage2Disk
implements Operation<In, ImageCapture.OutputFileResults> {
    @NonNull
    private DngCreator mDngCreator;

    public DngImage2Disk(@NonNull CameraCharacteristics cameraCharacteristics, @NonNull CaptureResult captureResult) {
        this(new DngCreator(cameraCharacteristics, captureResult));
    }

    @VisibleForTesting
    DngImage2Disk(@NonNull DngCreator dngCreator) {
        this.mDngCreator = dngCreator;
    }

    @Override
    @NonNull
    public ImageCapture.OutputFileResults apply(@NonNull In in) throws ImageCaptureException {
        ImageCapture.OutputFileOptions options = in.getOutputFileOptions();
        File tempFile = FileUtil.createTempFile(options);
        this.writeImageToFile(tempFile, in.getImageProxy(), in.getRotationDegrees());
        Uri uri = FileUtil.moveFileToTarget(tempFile, options);
        return new ImageCapture.OutputFileResults(uri, 32);
    }

    @OptIn(markerClass={ExperimentalGetImage.class})
    private void writeImageToFile(@NonNull File tempFile, @NonNull ImageProxy imageProxy, int rotationDegrees) throws ImageCaptureException {
        try (FileOutputStream output = new FileOutputStream(tempFile);){
            this.mDngCreator.setOrientation(DngImage2Disk.computeExifOrientation(rotationDegrees));
            this.mDngCreator.writeImage((OutputStream)output, imageProxy.getImage());
        }
        catch (IllegalArgumentException e) {
            throw new ImageCaptureException(1, "Image with an unsupported format was used", e);
        }
        catch (IllegalStateException e) {
            throw new ImageCaptureException(1, "Not enough metadata information has been set to write a well-formatted DNG file", e);
        }
        catch (IOException e) {
            throw new ImageCaptureException(1, "Failed to write to temp file", e);
        }
        finally {
            imageProxy.close();
        }
    }

    static int computeExifOrientation(int rotationDegrees) {
        switch (rotationDegrees) {
            case 0: {
                return 1;
            }
            case 90: {
                return 6;
            }
            case 180: {
                return 3;
            }
            case 270: {
                return 8;
            }
        }
        return 0;
    }

    @AutoValue
    static abstract class In {
        In() {
        }

        @NonNull
        abstract ImageProxy getImageProxy();

        abstract int getRotationDegrees();

        @NonNull
        abstract ImageCapture.OutputFileOptions getOutputFileOptions();

        @NonNull
        static In of(@NonNull ImageProxy imageProxy, int rotationDegrees, @NonNull ImageCapture.OutputFileOptions outputFileOptions) {
            return new AutoValue_DngImage2Disk_In(imageProxy, rotationDegrees, outputFileOptions);
        }
    }
}

