/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.imagecapture.TakePictureCallback;
import androidx.camera.core.imagecapture.TakePictureRequest;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureStage;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class ProcessingRequest {
    private final int mRequestId;
    @NonNull
    TakePictureRequest mTakePictureRequest;
    @Nullable
    private final ImageCapture.OutputFileOptions mOutputFileOptions;
    @Nullable
    private final ImageCapture.OutputFileOptions mSecondaryOutputFileOptions;
    @NonNull
    private final Rect mCropRect;
    private final int mRotationDegrees;
    private final int mJpegQuality;
    @NonNull
    private final Matrix mSensorToBufferTransform;
    @NonNull
    private final TakePictureCallback mCallback;
    @NonNull
    private final String mTagBundleKey;
    @NonNull
    private final List<Integer> mStageIds;
    @NonNull
    final ListenableFuture<Void> mCaptureFuture;
    static final int PROGRESS_NOT_RECEIVED = -1;
    private int mLastCaptureProcessProgressed = -1;

    ProcessingRequest(@NonNull CaptureBundle captureBundle, @NonNull TakePictureRequest takePictureRequest, @NonNull TakePictureCallback callback, @NonNull ListenableFuture<Void> captureFuture) {
        this(captureBundle, takePictureRequest, callback, captureFuture, 0);
    }

    ProcessingRequest(@NonNull CaptureBundle captureBundle, @NonNull TakePictureRequest takePictureRequest, @NonNull TakePictureCallback callback, @NonNull ListenableFuture<Void> captureFuture, int requestId) {
        this.mRequestId = requestId;
        this.mTakePictureRequest = takePictureRequest;
        this.mOutputFileOptions = takePictureRequest.getOutputFileOptions();
        this.mSecondaryOutputFileOptions = takePictureRequest.getSecondaryOutputFileOptions();
        this.mJpegQuality = takePictureRequest.getJpegQuality();
        this.mRotationDegrees = takePictureRequest.getRotationDegrees();
        this.mCropRect = takePictureRequest.getCropRect();
        this.mSensorToBufferTransform = takePictureRequest.getSensorToBufferTransform();
        this.mCallback = callback;
        this.mTagBundleKey = String.valueOf(captureBundle.hashCode());
        this.mStageIds = new ArrayList<Integer>();
        for (CaptureStage captureStage : Objects.requireNonNull(captureBundle.getCaptureStages())) {
            this.mStageIds.add(captureStage.getId());
        }
        this.mCaptureFuture = captureFuture;
    }

    @NonNull
    String getTagBundleKey() {
        return this.mTagBundleKey;
    }

    @NonNull
    List<Integer> getStageIds() {
        return this.mStageIds;
    }

    public int getRequestId() {
        return this.mRequestId;
    }

    @NonNull
    TakePictureRequest getTakePictureRequest() {
        return this.mTakePictureRequest;
    }

    @Nullable
    ImageCapture.OutputFileOptions getOutputFileOptions() {
        return this.mOutputFileOptions;
    }

    @Nullable
    ImageCapture.OutputFileOptions getSecondaryOutputFileOptions() {
        return this.mSecondaryOutputFileOptions;
    }

    @NonNull
    Rect getCropRect() {
        return this.mCropRect;
    }

    int getRotationDegrees() {
        return this.mRotationDegrees;
    }

    int getJpegQuality() {
        return this.mJpegQuality;
    }

    @NonNull
    Matrix getSensorToBufferTransform() {
        return this.mSensorToBufferTransform;
    }

    boolean isInMemoryCapture() {
        return this.getOutputFileOptions() == null && this.getSecondaryOutputFileOptions() == null;
    }

    @MainThread
    void onCaptureStarted() {
        this.mCallback.onCaptureStarted();
    }

    @MainThread
    void onCaptureProcessProgressed(int progress) {
        if (this.mLastCaptureProcessProgressed != progress) {
            this.mLastCaptureProcessProgressed = progress;
            this.mCallback.onCaptureProcessProgressed(progress);
        }
    }

    @MainThread
    void onImageCaptured() {
        if (this.mLastCaptureProcessProgressed != -1) {
            this.onCaptureProcessProgressed(100);
        }
        this.mCallback.onImageCaptured();
    }

    @MainThread
    void onFinalResult(@NonNull ImageCapture.OutputFileResults outputFileResults) {
        this.mCallback.onFinalResult(outputFileResults);
    }

    void onPostviewBitmapAvailable(@NonNull Bitmap bitmap) {
        this.mCallback.onPostviewBitmapAvailable(bitmap);
    }

    @MainThread
    void onFinalResult(@NonNull ImageProxy imageProxy) {
        this.mCallback.onFinalResult(imageProxy);
    }

    @MainThread
    void onProcessFailure(@NonNull ImageCaptureException imageCaptureException) {
        this.mCallback.onProcessFailure(imageCaptureException);
    }

    @MainThread
    void onCaptureFailure(@NonNull ImageCaptureException imageCaptureException) {
        this.mCallback.onCaptureFailure(imageCaptureException);
    }

    boolean isAborted() {
        return this.mCallback.isAborted();
    }

    @NonNull
    ListenableFuture<Void> getCaptureFuture() {
        return this.mCaptureFuture;
    }
}

