/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Bitmap;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.imagecapture.TakePictureCallback;
import androidx.camera.core.imagecapture.TakePictureRequest;
import androidx.camera.core.impl.utils.Threads;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;

public class RequestWithCallback
implements TakePictureCallback {
    private final TakePictureRequest mTakePictureRequest;
    private final TakePictureRequest.RetryControl mRetryControl;
    private final ListenableFuture<Void> mCaptureFuture;
    private final ListenableFuture<Void> mCompleteFuture;
    private CallbackToFutureAdapter.Completer<Void> mCaptureCompleter;
    private CallbackToFutureAdapter.Completer<Void> mCompleteCompleter;
    private boolean mIsAborted = false;
    private boolean mIsStarted = false;
    @Nullable
    private ListenableFuture<Void> mCaptureRequestFuture;

    RequestWithCallback(@NonNull TakePictureRequest takePictureRequest, @NonNull TakePictureRequest.RetryControl retryControl) {
        this.mTakePictureRequest = takePictureRequest;
        this.mRetryControl = retryControl;
        this.mCaptureFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mCaptureCompleter = completer;
            return "CaptureCompleteFuture";
        });
        this.mCompleteFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mCompleteCompleter = completer;
            return "RequestCompleteFuture";
        });
    }

    @MainThread
    public void setCaptureRequestFuture(@NonNull ListenableFuture<Void> captureRequestFuture) {
        Threads.checkMainThread();
        Preconditions.checkState((this.mCaptureRequestFuture == null ? 1 : 0) != 0, (String)"CaptureRequestFuture can only be set once.");
        this.mCaptureRequestFuture = captureRequestFuture;
    }

    @Override
    @MainThread
    public void onCaptureStarted() {
        ImageCapture.OnImageSavedCallback onDiskCallback;
        Threads.checkMainThread();
        if (this.mIsAborted || this.mIsStarted) {
            return;
        }
        this.mIsStarted = true;
        ImageCapture.OnImageCapturedCallback inMemoryCallback = this.mTakePictureRequest.getInMemoryCallback();
        if (inMemoryCallback != null) {
            inMemoryCallback.onCaptureStarted();
        }
        if ((onDiskCallback = this.mTakePictureRequest.getOnDiskCallback()) != null) {
            onDiskCallback.onCaptureStarted();
        }
    }

    @Override
    @MainThread
    public void onImageCaptured() {
        Threads.checkMainThread();
        if (this.mIsAborted) {
            return;
        }
        if (!this.mIsStarted) {
            this.onCaptureStarted();
        }
        this.mCaptureCompleter.set(null);
    }

    @Override
    @MainThread
    public void onFinalResult(@NonNull ImageCapture.OutputFileResults outputFileResults) {
        Threads.checkMainThread();
        if (this.mIsAborted) {
            return;
        }
        this.checkOnImageCaptured();
        this.markComplete();
        this.mTakePictureRequest.onResult(outputFileResults);
    }

    @Override
    @MainThread
    public void onFinalResult(@NonNull ImageProxy imageProxy) {
        Threads.checkMainThread();
        if (this.mIsAborted) {
            imageProxy.close();
            return;
        }
        this.checkOnImageCaptured();
        this.markComplete();
        this.mTakePictureRequest.onResult(imageProxy);
    }

    @Override
    public void onCaptureProcessProgressed(int progress) {
        Threads.checkMainThread();
        if (this.mIsAborted) {
            return;
        }
        this.mTakePictureRequest.onCaptureProcessProgressed(progress);
    }

    @Override
    public void onPostviewBitmapAvailable(@NonNull Bitmap bitmap) {
        Threads.checkMainThread();
        if (this.mIsAborted) {
            return;
        }
        this.mTakePictureRequest.onPostviewBitmapAvailable(bitmap);
    }

    @Override
    @MainThread
    public void onProcessFailure(@NonNull ImageCaptureException imageCaptureException) {
        Threads.checkMainThread();
        if (this.mIsAborted) {
            return;
        }
        this.checkOnImageCaptured();
        this.markComplete();
        this.onFailure(imageCaptureException);
    }

    @Override
    public boolean isAborted() {
        return this.mIsAborted;
    }

    @Override
    @MainThread
    public void onCaptureFailure(@NonNull ImageCaptureException imageCaptureException) {
        Threads.checkMainThread();
        if (this.mIsAborted) {
            return;
        }
        boolean isRetryAllowed = this.mTakePictureRequest.decrementRetryCounter();
        if (!isRetryAllowed) {
            this.onFailure(imageCaptureException);
        }
        this.markComplete();
        this.mCaptureCompleter.setException((Throwable)imageCaptureException);
        if (isRetryAllowed) {
            this.mRetryControl.retryRequest(this.mTakePictureRequest);
        }
    }

    @MainThread
    void abortAndSendErrorToApp(@NonNull ImageCaptureException imageCaptureException) {
        Threads.checkMainThread();
        if (this.mCompleteFuture.isDone()) {
            return;
        }
        this.abort(imageCaptureException);
        this.onFailure(imageCaptureException);
    }

    @MainThread
    void abortSilentlyAndRetry() {
        Threads.checkMainThread();
        if (this.mCompleteFuture.isDone()) {
            return;
        }
        this.abort(new ImageCaptureException(3, "The request is aborted silently and retried.", null));
        this.mRetryControl.retryRequest(this.mTakePictureRequest);
    }

    @MainThread
    private void abort(@NonNull ImageCaptureException imageCaptureException) {
        Threads.checkMainThread();
        this.mIsAborted = true;
        Objects.requireNonNull(this.mCaptureRequestFuture).cancel(true);
        this.mCaptureCompleter.setException((Throwable)imageCaptureException);
        this.mCompleteCompleter.set(null);
    }

    @MainThread
    @NonNull
    ListenableFuture<Void> getCaptureFuture() {
        Threads.checkMainThread();
        return this.mCaptureFuture;
    }

    @MainThread
    @NonNull
    ListenableFuture<Void> getCompleteFuture() {
        Threads.checkMainThread();
        return this.mCompleteFuture;
    }

    @VisibleForTesting
    @NonNull
    public TakePictureRequest getTakePictureRequest() {
        return this.mTakePictureRequest;
    }

    private void checkOnImageCaptured() {
        Preconditions.checkState((boolean)this.mCaptureFuture.isDone(), (String)"onImageCaptured() must be called before onFinalResult()");
    }

    private void markComplete() {
        if (this.mTakePictureRequest.isSimultaneousCapture() && !this.mTakePictureRequest.isFormatProcessedInSimultaneousCapture()) {
            return;
        }
        if (!this.mTakePictureRequest.isSimultaneousCapture()) {
            Preconditions.checkState((!this.mCompleteFuture.isDone() ? 1 : 0) != 0, (String)"The callback can only complete once.");
        }
        this.mCompleteCompleter.set(null);
    }

    @MainThread
    private void onFailure(@NonNull ImageCaptureException imageCaptureException) {
        Threads.checkMainThread();
        this.mTakePictureRequest.onError(imageCaptureException);
    }
}

