/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.camera.core.Camera;
import androidx.camera.core.Logger;
import androidx.camera.core.concurrent.CameraCoordinator;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.core.util.Preconditions;
import androidx.tracing.Trace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public final class CameraStateRegistry
implements CameraCoordinator.ConcurrentCameraModeListener {
    private static final String TAG = "CameraStateRegistry";
    private static final int MAX_ALLOWED_CONCURRENT_CAMERAS_IN_SINGLE_MODE = 1;
    private static final int MAX_ALLOWED_CONCURRENT_CAMERAS_IN_CONCURRENT_MODE = 2;
    private final StringBuilder mDebugString = new StringBuilder();
    private final Object mLock = new Object();
    private int mMaxAllowedOpenedCameras;
    @GuardedBy(value="mLock")
    private final CameraCoordinator mCameraCoordinator;
    @GuardedBy(value="mLock")
    private final Map<Camera, CameraRegistration> mCameraStates = new HashMap<Camera, CameraRegistration>();
    @GuardedBy(value="mLock")
    private int mAvailableCameras;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraStateRegistry(@NonNull CameraCoordinator cameraCoordinator, int maxAllowedOpenedCameras) {
        this.mMaxAllowedOpenedCameras = maxAllowedOpenedCameras;
        Object object = this.mLock;
        synchronized (object) {
            this.mCameraCoordinator = cameraCoordinator;
            this.mAvailableCameras = this.mMaxAllowedOpenedCameras;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCamera(@NonNull Camera camera, @NonNull Executor notifyExecutor, @NonNull OnConfigureAvailableListener onConfigureAvailableListener, @NonNull OnOpenAvailableListener onOpenAvailableListener) {
        Object object = this.mLock;
        synchronized (object) {
            Preconditions.checkState((!this.mCameraStates.containsKey(camera) ? 1 : 0) != 0, (String)("Camera is already registered: " + camera));
            this.mCameraStates.put(camera, new CameraRegistration(null, notifyExecutor, onConfigureAvailableListener, onOpenAvailableListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryOpenCamera(@NonNull Camera camera) {
        Object object = this.mLock;
        synchronized (object) {
            CameraRegistration registration = (CameraRegistration)Preconditions.checkNotNull((Object)this.mCameraStates.get(camera), (Object)"Camera must first be registered with registerCamera()");
            boolean success = false;
            if (Logger.isDebugEnabled(TAG)) {
                this.mDebugString.setLength(0);
                this.mDebugString.append(String.format(Locale.US, "tryOpenCamera(%s) [Available Cameras: %d, Already Open: %b (Previous state: %s)]", new Object[]{camera, this.mAvailableCameras, CameraStateRegistry.isOpen(registration.getState()), registration.getState()}));
            }
            if (this.mAvailableCameras > 0 || CameraStateRegistry.isOpen(registration.getState())) {
                registration.setState(CameraInternal.State.OPENING);
                CameraStateRegistry.traceState(camera, CameraInternal.State.OPENING);
                success = true;
            }
            if (Logger.isDebugEnabled(TAG)) {
                this.mDebugString.append(String.format(Locale.US, " --> %s", success ? "SUCCESS" : "FAIL"));
                Logger.d(TAG, this.mDebugString.toString());
            }
            if (success) {
                this.recalculateAvailableCameras();
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryOpenCaptureSession(@NonNull String cameraId, @Nullable String pairedCameraId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCameraCoordinator.getCameraOperatingMode() != 2) {
                return true;
            }
            CameraRegistration registration = this.getCameraRegistration(cameraId);
            CameraInternal.State selfState = registration != null ? registration.getState() : null;
            CameraRegistration pairedRegistration = pairedCameraId != null ? this.getCameraRegistration(pairedCameraId) : null;
            CameraInternal.State pairedState = pairedRegistration != null ? pairedRegistration.getState() : null;
            boolean isSelfAvailable = CameraInternal.State.OPEN.equals((Object)selfState) || CameraInternal.State.CONFIGURED.equals((Object)selfState);
            boolean isPairAvailable = CameraInternal.State.OPEN.equals((Object)pairedState) || CameraInternal.State.CONFIGURED.equals((Object)pairedState);
            return isSelfAvailable && isPairAvailable;
        }
    }

    public void markCameraState(@NonNull Camera camera, @NonNull CameraInternal.State state) {
        this.markCameraState(camera, state, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCameraState(@NonNull Camera camera, @NonNull CameraInternal.State state, boolean notifyImmediately) {
        HashMap<Camera, CameraRegistration> camerasToNotifyOpen = null;
        CameraRegistration cameraToNotifyConfigure = null;
        Iterator iterator = this.mLock;
        synchronized (iterator) {
            String cameraId;
            String pairedCameraId;
            int previousAvailableCameras = this.mAvailableCameras;
            CameraInternal.State previousState = state == CameraInternal.State.RELEASED ? this.unregisterCamera(camera) : this.updateAndVerifyState(camera, state);
            if (previousState == state) {
                return;
            }
            if (this.mCameraCoordinator.getCameraOperatingMode() == 2 && state == CameraInternal.State.CONFIGURED && (pairedCameraId = this.mCameraCoordinator.getPairedConcurrentCameraId(cameraId = ((CameraInfoInternal)camera.getCameraInfo()).getCameraId())) != null) {
                cameraToNotifyConfigure = this.getCameraRegistration(pairedCameraId);
            }
            if (previousAvailableCameras < 1 && this.mAvailableCameras > 0) {
                camerasToNotifyOpen = new HashMap<Camera, CameraRegistration>();
                for (Map.Entry<Camera, CameraRegistration> entry : this.mCameraStates.entrySet()) {
                    if (entry.getValue().getState() != CameraInternal.State.PENDING_OPEN) continue;
                    camerasToNotifyOpen.put(entry.getKey(), entry.getValue());
                }
            } else if (state == CameraInternal.State.PENDING_OPEN && this.mAvailableCameras > 0) {
                camerasToNotifyOpen = new HashMap();
                camerasToNotifyOpen.put(camera, this.mCameraStates.get(camera));
            }
            if (camerasToNotifyOpen != null && !notifyImmediately) {
                camerasToNotifyOpen.remove(camera);
            }
        }
        if (camerasToNotifyOpen != null) {
            for (CameraRegistration registration : camerasToNotifyOpen.values()) {
                registration.notifyOnOpenAvailableListener();
            }
        }
        if (cameraToNotifyConfigure != null) {
            cameraToNotifyConfigure.notifyOnConfigureAvailableListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCameraOperatingModeUpdated(int prevMode, int currMode) {
        Object object = this.mLock;
        synchronized (object) {
            boolean isConcurrentCameraModeOff;
            this.mMaxAllowedOpenedCameras = currMode == 2 ? 2 : 1;
            boolean isConcurrentCameraModeOn = prevMode != 2 && currMode == 2;
            boolean bl = isConcurrentCameraModeOff = prevMode == 2 && currMode != 2;
            if (isConcurrentCameraModeOn || isConcurrentCameraModeOff) {
                this.recalculateAvailableCameras();
            }
        }
    }

    @GuardedBy(value="mLock")
    @Nullable
    private CameraInternal.State unregisterCamera(@NonNull Camera camera) {
        CameraRegistration registration = this.mCameraStates.remove(camera);
        if (registration != null) {
            this.recalculateAvailableCameras();
            return registration.getState();
        }
        return null;
    }

    @GuardedBy(value="mLock")
    @Nullable
    private CameraInternal.State updateAndVerifyState(@NonNull Camera camera, @NonNull CameraInternal.State state) {
        CameraInternal.State previousState = ((CameraRegistration)Preconditions.checkNotNull((Object)this.mCameraStates.get(camera), (Object)"Cannot update state of camera which has not yet been registered. Register with CameraStateRegistry.registerCamera()")).setState(state);
        if (state == CameraInternal.State.OPENING) {
            Preconditions.checkState((CameraStateRegistry.isOpen(state) || previousState == CameraInternal.State.OPENING ? 1 : 0) != 0, (String)"Cannot mark camera as opening until camera was successful at calling CameraStateRegistry.tryOpenCamera()");
        }
        if (previousState != state) {
            CameraStateRegistry.traceState(camera, state);
            this.recalculateAvailableCameras();
        }
        return previousState;
    }

    private static boolean isOpen(@Nullable CameraInternal.State state) {
        return state != null && state.holdsCameraSlot();
    }

    @WorkerThread
    @GuardedBy(value="mLock")
    private void recalculateAvailableCameras() {
        if (Logger.isDebugEnabled(TAG)) {
            this.mDebugString.setLength(0);
            this.mDebugString.append("Recalculating open cameras:\n");
            this.mDebugString.append(String.format(Locale.US, "%-45s%-22s\n", "Camera", "State"));
            this.mDebugString.append("-------------------------------------------------------------------\n");
        }
        int openCount = 0;
        for (Map.Entry<Camera, CameraRegistration> entry : this.mCameraStates.entrySet()) {
            if (Logger.isDebugEnabled(TAG)) {
                String stateString = entry.getValue().getState() != null ? entry.getValue().getState().toString() : "UNKNOWN";
                this.mDebugString.append(String.format(Locale.US, "%-45s%-22s\n", entry.getKey().toString(), stateString));
            }
            if (!CameraStateRegistry.isOpen(entry.getValue().getState())) continue;
            ++openCount;
        }
        if (Logger.isDebugEnabled(TAG)) {
            this.mDebugString.append("-------------------------------------------------------------------\n");
            this.mDebugString.append(String.format(Locale.US, "Open count: %d (Max allowed: %d)", openCount, this.mMaxAllowedOpenedCameras));
            Logger.d(TAG, this.mDebugString.toString());
        }
        this.mAvailableCameras = Math.max(this.mMaxAllowedOpenedCameras - openCount, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCameraClosing() {
        Object object = this.mLock;
        synchronized (object) {
            for (Map.Entry<Camera, CameraRegistration> entry : this.mCameraStates.entrySet()) {
                if (entry.getValue().getState() != CameraInternal.State.CLOSING) continue;
                return true;
            }
            return false;
        }
    }

    @Nullable
    @GuardedBy(value="mLock")
    private CameraRegistration getCameraRegistration(@NonNull String targetCameraId) {
        for (Camera camera : this.mCameraStates.keySet()) {
            String cameraId = ((CameraInfoInternal)camera.getCameraInfo()).getCameraId();
            if (!targetCameraId.equals(cameraId)) continue;
            return this.mCameraStates.get(camera);
        }
        return null;
    }

    private static void traceState(Camera camera, CameraInternal.State state) {
        if (Trace.isEnabled()) {
            String counterName = "CX:State[" + camera + "]";
            Trace.setCounter((String)counterName, (int)state.ordinal());
        }
    }

    private static class CameraRegistration {
        private CameraInternal.State mState;
        private final Executor mNotifyExecutor;
        private final OnConfigureAvailableListener mOnConfigureAvailableListener;
        private final OnOpenAvailableListener mOnOpenAvailableListener;

        CameraRegistration(@Nullable CameraInternal.State initialState, @NonNull Executor notifyExecutor, @NonNull OnConfigureAvailableListener onConfigureAvailableListener, @NonNull OnOpenAvailableListener onOpenAvailableListener) {
            this.mState = initialState;
            this.mNotifyExecutor = notifyExecutor;
            this.mOnConfigureAvailableListener = onConfigureAvailableListener;
            this.mOnOpenAvailableListener = onOpenAvailableListener;
        }

        CameraInternal.State setState(@Nullable CameraInternal.State state) {
            CameraInternal.State previousState = this.mState;
            this.mState = state;
            return previousState;
        }

        CameraInternal.State getState() {
            return this.mState;
        }

        void notifyOnConfigureAvailableListener() {
            try {
                this.mNotifyExecutor.execute(this.mOnConfigureAvailableListener::onConfigureAvailable);
            }
            catch (RejectedExecutionException e) {
                Logger.e(CameraStateRegistry.TAG, "Unable to notify camera to configure.", e);
            }
        }

        void notifyOnOpenAvailableListener() {
            try {
                this.mNotifyExecutor.execute(this.mOnOpenAvailableListener::onOpenAvailable);
            }
            catch (RejectedExecutionException e) {
                Logger.e(CameraStateRegistry.TAG, "Unable to notify camera to open.", e);
            }
        }
    }

    public static interface OnConfigureAvailableListener {
        public void onConfigureAvailable();
    }

    public static interface OnOpenAvailableListener {
        public void onOpenAvailable();
    }
}

