/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

public final class ConstantObservable<T>
implements Observable<T> {
    private static final ConstantObservable<Object> NULL_OBSERVABLE = new ConstantObservable<Object>(null);
    private static final String TAG = "ConstantObservable";
    private final ListenableFuture<T> mValueFuture;

    @NonNull
    public static <U> Observable<U> withValue(@Nullable U value) {
        if (value == null) {
            ConstantObservable<Object> typedNull = NULL_OBSERVABLE;
            return typedNull;
        }
        return new ConstantObservable<U>(value);
    }

    private ConstantObservable(@Nullable T value) {
        this.mValueFuture = Futures.immediateFuture(value);
    }

    @Override
    @NonNull
    public ListenableFuture<T> fetchData() {
        return this.mValueFuture;
    }

    @Override
    public void addObserver(@NonNull Executor executor, @NonNull Observable.Observer<? super T> observer) {
        this.mValueFuture.addListener(() -> {
            try {
                observer.onNewData(this.mValueFuture.get());
            }
            catch (InterruptedException | ExecutionException e) {
                observer.onError(e);
            }
        }, executor);
    }

    @Override
    public void removeObserver(@NonNull Observable.Observer<? super T> observer) {
    }
}

