/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Pair;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.OutputSurfaceConfiguration;
import androidx.camera.core.impl.RequestProcessor;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.TagBundle;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface SessionProcessor {
    @NonNull
    public SessionConfig initSession(@NonNull CameraInfo var1, @NonNull OutputSurfaceConfiguration var2);

    public void deInitSession();

    public void setParameters(@NonNull Config var1);

    public void onCaptureSessionStart(@NonNull RequestProcessor var1);

    public void onCaptureSessionEnd();

    public int startRepeating(@NonNull TagBundle var1, @NonNull CaptureCallback var2);

    public void stopRepeating();

    public int startCapture(boolean var1, @NonNull TagBundle var2, @NonNull CaptureCallback var3);

    public void abortCapture(int var1);

    default public int startTrigger(@NonNull Config config, @NonNull TagBundle tagBundle, @NonNull CaptureCallback callback) {
        return -1;
    }

    @NonNull
    default public Map<Integer, List<Size>> getSupportedPostviewSize(@NonNull Size captureSize) {
        return Collections.emptyMap();
    }

    @NonNull
    default public Set<Integer> getSupportedCameraOperations() {
        return Collections.emptySet();
    }

    @Nullable
    default public Pair<Long, Long> getRealtimeCaptureLatency() {
        return null;
    }

    public static interface CaptureCallback {
        default public void onCaptureStarted(int captureSequenceId, long timestamp) {
        }

        default public void onCaptureProcessStarted(int captureSequenceId) {
        }

        default public void onCaptureFailed(int captureSequenceId) {
        }

        default public void onCaptureSequenceCompleted(int captureSequenceId) {
        }

        default public void onCaptureSequenceAborted(int captureSequenceId) {
        }

        default public void onCaptureCompleted(long timestamp, int captureSequenceId, @NonNull CameraCaptureResult captureResult) {
        }

        default public void onCaptureProcessProgressed(int progress) {
        }
    }
}

