/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.AutoValue_SurfaceSizeDefinition;
import com.google.auto.value.AutoValue;
import java.util.Map;

@AutoValue
public abstract class SurfaceSizeDefinition {
    SurfaceSizeDefinition() {
    }

    @NonNull
    public static SurfaceSizeDefinition create(@NonNull Size analysisSize, @NonNull Map<Integer, Size> s720pSizeMap, @NonNull Size previewSize, @NonNull Map<Integer, Size> s1440pSizeMap, @NonNull Size recordSize, @NonNull Map<Integer, Size> maximumSizeMap, @NonNull Map<Integer, Size> ultraMaximumSizeMap) {
        return new AutoValue_SurfaceSizeDefinition(analysisSize, s720pSizeMap, previewSize, s1440pSizeMap, recordSize, maximumSizeMap, ultraMaximumSizeMap);
    }

    @NonNull
    public abstract Size getAnalysisSize();

    @NonNull
    public abstract Map<Integer, Size> getS720pSizeMap();

    @NonNull
    public abstract Size getPreviewSize();

    @NonNull
    public abstract Map<Integer, Size> getS1440pSizeMap();

    @NonNull
    public abstract Size getRecordSize();

    @NonNull
    public abstract Map<Integer, Size> getMaximumSizeMap();

    @NonNull
    public abstract Map<Integer, Size> getUltraMaximumSizeMap();

    @NonNull
    public Size getS720pSize(int format) {
        return this.getS720pSizeMap().get(format);
    }

    @NonNull
    public Size getS1440pSize(int format) {
        return this.getS1440pSizeMap().get(format);
    }

    @NonNull
    public Size getMaximumSize(int format) {
        return this.getMaximumSizeMap().get(format);
    }

    @Nullable
    public Size getUltraMaximumSize(int format) {
        return this.getUltraMaximumSizeMap().get(format);
    }
}

