/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Range;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.UseCase;
import androidx.camera.core.imagecapture.ImageCaptureControl;
import androidx.camera.core.imagecapture.TakePictureManager;
import androidx.camera.core.imagecapture.TakePictureManagerImpl;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.internal.TargetConfig;
import java.util.Objects;

public interface UseCaseConfig<T extends UseCase>
extends TargetConfig<T>,
ImageInputConfig {
    public static final Config.Option<SessionConfig> OPTION_DEFAULT_SESSION_CONFIG = Config.Option.create("camerax.core.useCase.defaultSessionConfig", SessionConfig.class);
    public static final Config.Option<CaptureConfig> OPTION_DEFAULT_CAPTURE_CONFIG = Config.Option.create("camerax.core.useCase.defaultCaptureConfig", CaptureConfig.class);
    public static final Config.Option<SessionConfig.OptionUnpacker> OPTION_SESSION_CONFIG_UNPACKER = Config.Option.create("camerax.core.useCase.sessionConfigUnpacker", SessionConfig.OptionUnpacker.class);
    public static final Config.Option<CaptureConfig.OptionUnpacker> OPTION_CAPTURE_CONFIG_UNPACKER = Config.Option.create("camerax.core.useCase.captureConfigUnpacker", CaptureConfig.OptionUnpacker.class);
    public static final Config.Option<Integer> OPTION_SURFACE_OCCUPANCY_PRIORITY = Config.Option.create("camerax.core.useCase.surfaceOccupancyPriority", Integer.TYPE);
    public static final Config.Option<Range<Integer>> OPTION_TARGET_FRAME_RATE = Config.Option.create("camerax.core.useCase.targetFrameRate", Range.class);
    public static final Config.Option<Boolean> OPTION_ZSL_DISABLED = Config.Option.create("camerax.core.useCase.zslDisabled", Boolean.TYPE);
    public static final Config.Option<Boolean> OPTION_HIGH_RESOLUTION_DISABLED = Config.Option.create("camerax.core.useCase.highResolutionDisabled", Boolean.TYPE);
    public static final Config.Option<UseCaseConfigFactory.CaptureType> OPTION_CAPTURE_TYPE = Config.Option.create("camerax.core.useCase.captureType", UseCaseConfigFactory.CaptureType.class);
    public static final Config.Option<Integer> OPTION_PREVIEW_STABILIZATION_MODE = Config.Option.create("camerax.core.useCase.previewStabilizationMode", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_VIDEO_STABILIZATION_MODE = Config.Option.create("camerax.core.useCase.videoStabilizationMode", Integer.TYPE);
    public static final Config.Option<TakePictureManager.Provider> OPTION_TAKE_PICTURE_MANAGER_PROVIDER = Config.Option.create("camerax.core.useCase.takePictureManagerProvider", TakePictureManager.Provider.class);

    @Nullable
    default public SessionConfig getDefaultSessionConfig(@Nullable SessionConfig valueIfMissing) {
        return this.retrieveOption(OPTION_DEFAULT_SESSION_CONFIG, valueIfMissing);
    }

    @NonNull
    default public SessionConfig getDefaultSessionConfig() {
        return this.retrieveOption(OPTION_DEFAULT_SESSION_CONFIG);
    }

    @Nullable
    default public CaptureConfig getDefaultCaptureConfig(@Nullable CaptureConfig valueIfMissing) {
        return this.retrieveOption(OPTION_DEFAULT_CAPTURE_CONFIG, valueIfMissing);
    }

    @NonNull
    default public CaptureConfig getDefaultCaptureConfig() {
        return this.retrieveOption(OPTION_DEFAULT_CAPTURE_CONFIG);
    }

    @Nullable
    default public SessionConfig.OptionUnpacker getSessionOptionUnpacker(@Nullable SessionConfig.OptionUnpacker valueIfMissing) {
        return this.retrieveOption(OPTION_SESSION_CONFIG_UNPACKER, valueIfMissing);
    }

    @NonNull
    default public SessionConfig.OptionUnpacker getSessionOptionUnpacker() {
        return this.retrieveOption(OPTION_SESSION_CONFIG_UNPACKER);
    }

    @Nullable
    default public CaptureConfig.OptionUnpacker getCaptureOptionUnpacker(@Nullable CaptureConfig.OptionUnpacker valueIfMissing) {
        return this.retrieveOption(OPTION_CAPTURE_CONFIG_UNPACKER, valueIfMissing);
    }

    @NonNull
    default public CaptureConfig.OptionUnpacker getCaptureOptionUnpacker() {
        return this.retrieveOption(OPTION_CAPTURE_CONFIG_UNPACKER);
    }

    default public int getSurfaceOccupancyPriority(int valueIfMissing) {
        return this.retrieveOption(OPTION_SURFACE_OCCUPANCY_PRIORITY, valueIfMissing);
    }

    default public int getSurfaceOccupancyPriority() {
        return this.retrieveOption(OPTION_SURFACE_OCCUPANCY_PRIORITY);
    }

    @Nullable
    default public Range<Integer> getTargetFrameRate(@Nullable Range<Integer> valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_FRAME_RATE, valueIfMissing);
    }

    @NonNull
    default public Range<Integer> getTargetFrameRate() {
        return this.retrieveOption(OPTION_TARGET_FRAME_RATE);
    }

    default public boolean isZslDisabled(boolean valueIfMissing) {
        return this.retrieveOption(OPTION_ZSL_DISABLED, valueIfMissing);
    }

    default public boolean isHighResolutionDisabled(boolean valueIfMissing) {
        return this.retrieveOption(OPTION_HIGH_RESOLUTION_DISABLED, valueIfMissing);
    }

    @NonNull
    default public UseCaseConfigFactory.CaptureType getCaptureType() {
        return this.retrieveOption(OPTION_CAPTURE_TYPE);
    }

    default public int getPreviewStabilizationMode() {
        return this.retrieveOption(OPTION_PREVIEW_STABILIZATION_MODE, 0);
    }

    default public int getVideoStabilizationMode() {
        return this.retrieveOption(OPTION_VIDEO_STABILIZATION_MODE, 0);
    }

    @NonNull
    default public TakePictureManager.Provider getTakePictureManagerProvider() {
        return Objects.requireNonNull((TakePictureManager.Provider)this.retrieveOption(OPTION_TAKE_PICTURE_MANAGER_PROVIDER, new TakePictureManager.Provider(){

            @Override
            @NonNull
            public TakePictureManager newInstance(@NonNull ImageCaptureControl imageCaptureControl) {
                return new TakePictureManagerImpl(imageCaptureControl);
            }
        }));
    }

    public static interface Builder<T extends UseCase, C extends UseCaseConfig<T>, B>
    extends TargetConfig.Builder<T, B>,
    ExtendableBuilder<T> {
        @NonNull
        public B setDefaultSessionConfig(@NonNull SessionConfig var1);

        @NonNull
        public B setDefaultCaptureConfig(@NonNull CaptureConfig var1);

        @NonNull
        public B setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker var1);

        @NonNull
        public B setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker var1);

        @NonNull
        public B setSurfaceOccupancyPriority(int var1);

        @NonNull
        public B setZslDisabled(boolean var1);

        @NonNull
        public B setHighResolutionDisabled(boolean var1);

        @NonNull
        public B setCaptureType(@NonNull UseCaseConfigFactory.CaptureType var1);

        @NonNull
        public C getUseCaseConfig();
    }
}

