/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import android.os.Build;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraCaptureMetaData;
import androidx.camera.core.impl.utils.ExifAttribute;
import androidx.camera.core.impl.utils.ExifTag;
import androidx.camera.core.impl.utils.LongRational;
import androidx.core.util.Preconditions;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExifData {
    private static final String TAG = "ExifData";
    private static final boolean DEBUG = false;
    static final String[] IFD_FORMAT_NAMES = new String[]{"", "BYTE", "STRING", "USHORT", "ULONG", "URATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "SINGLE", "DOUBLE", "IFD"};
    static final String TAG_EXIF_IFD_POINTER = "ExifIFDPointer";
    static final String TAG_GPS_INFO_IFD_POINTER = "GPSInfoIFDPointer";
    static final String TAG_INTEROPERABILITY_IFD_POINTER = "InteroperabilityIFDPointer";
    static final String TAG_SUB_IFD_POINTER = "SubIFDPointer";
    private static final ExifTag[] IFD_TIFF_TAGS = new ExifTag[]{new ExifTag("ImageWidth", 256, 3, 4), new ExifTag("ImageLength", 257, 3, 4), new ExifTag("Make", 271, 2), new ExifTag("Model", 272, 2), new ExifTag("Orientation", 274, 3), new ExifTag("XResolution", 282, 5), new ExifTag("YResolution", 283, 5), new ExifTag("ResolutionUnit", 296, 3), new ExifTag("Software", 305, 2), new ExifTag("DateTime", 306, 2), new ExifTag("YCbCrPositioning", 531, 3), new ExifTag("SubIFDPointer", 330, 4), new ExifTag("ExifIFDPointer", 34665, 4), new ExifTag("GPSInfoIFDPointer", 34853, 4)};
    private static final ExifTag[] IFD_EXIF_TAGS = new ExifTag[]{new ExifTag("ExposureTime", 33434, 5), new ExifTag("FNumber", 33437, 5), new ExifTag("ExposureProgram", 34850, 3), new ExifTag("PhotographicSensitivity", 34855, 3), new ExifTag("SensitivityType", 34864, 3), new ExifTag("ExifVersion", 36864, 2), new ExifTag("DateTimeOriginal", 36867, 2), new ExifTag("DateTimeDigitized", 36868, 2), new ExifTag("ComponentsConfiguration", 37121, 7), new ExifTag("ShutterSpeedValue", 37377, 10), new ExifTag("ApertureValue", 37378, 5), new ExifTag("BrightnessValue", 37379, 10), new ExifTag("ExposureBiasValue", 37380, 10), new ExifTag("MaxApertureValue", 37381, 5), new ExifTag("MeteringMode", 37383, 3), new ExifTag("LightSource", 37384, 3), new ExifTag("Flash", 37385, 3), new ExifTag("FocalLength", 37386, 5), new ExifTag("SubSecTime", 37520, 2), new ExifTag("SubSecTimeOriginal", 37521, 2), new ExifTag("SubSecTimeDigitized", 37522, 2), new ExifTag("FlashpixVersion", 40960, 7), new ExifTag("ColorSpace", 40961, 3), new ExifTag("PixelXDimension", 40962, 3, 4), new ExifTag("PixelYDimension", 40963, 3, 4), new ExifTag("InteroperabilityIFDPointer", 40965, 4), new ExifTag("FocalPlaneResolutionUnit", 41488, 3), new ExifTag("SensingMethod", 41495, 3), new ExifTag("FileSource", 41728, 7), new ExifTag("SceneType", 41729, 7), new ExifTag("CustomRendered", 41985, 3), new ExifTag("ExposureMode", 41986, 3), new ExifTag("WhiteBalance", 41987, 3), new ExifTag("SceneCaptureType", 41990, 3), new ExifTag("Contrast", 41992, 3), new ExifTag("Saturation", 41993, 3), new ExifTag("Sharpness", 41994, 3)};
    private static final ExifTag[] IFD_GPS_TAGS = new ExifTag[]{new ExifTag("GPSVersionID", 0, 1), new ExifTag("GPSLatitudeRef", 1, 2), new ExifTag("GPSLatitude", 2, 5, 10), new ExifTag("GPSLongitudeRef", 3, 2), new ExifTag("GPSLongitude", 4, 5, 10), new ExifTag("GPSAltitudeRef", 5, 1), new ExifTag("GPSAltitude", 6, 5), new ExifTag("GPSTimeStamp", 7, 5), new ExifTag("GPSSpeedRef", 12, 2), new ExifTag("GPSTrackRef", 14, 2), new ExifTag("GPSImgDirectionRef", 16, 2), new ExifTag("GPSDestBearingRef", 23, 2), new ExifTag("GPSDestDistanceRef", 25, 2)};
    static final ExifTag[] EXIF_POINTER_TAGS = new ExifTag[]{new ExifTag("SubIFDPointer", 330, 4), new ExifTag("ExifIFDPointer", 34665, 4), new ExifTag("GPSInfoIFDPointer", 34853, 4), new ExifTag("InteroperabilityIFDPointer", 40965, 4)};
    private static final ExifTag[] IFD_INTEROPERABILITY_TAGS = new ExifTag[]{new ExifTag("InteroperabilityIndex", 1, 2)};
    static final ExifTag[][] EXIF_TAGS = new ExifTag[][]{IFD_TIFF_TAGS, IFD_EXIF_TAGS, IFD_GPS_TAGS, IFD_INTEROPERABILITY_TAGS};
    static final int IFD_TYPE_PRIMARY = 0;
    static final int IFD_TYPE_EXIF = 1;
    static final int IFD_TYPE_GPS = 2;
    static final int IFD_TYPE_INTEROPERABILITY = 3;
    static final HashSet<String> sTagSetForCompatibility = new HashSet<String>(Arrays.asList("FNumber", "ExposureTime", "GPSTimeStamp"));
    private static final int MM_IN_MICRONS = 1000;
    private static final String COMPONENTS_CONFIGURATION_YCBCR = new String(new byte[]{1, 2, 3, 0}, StandardCharsets.UTF_8);
    private final List<Map<String, ExifAttribute>> mAttributes;
    private final ByteOrder mByteOrder;

    ExifData(ByteOrder order, List<Map<String, ExifAttribute>> attributes) {
        Preconditions.checkState((attributes.size() == EXIF_TAGS.length ? 1 : 0) != 0, (String)"Malformed attributes list. Number of IFDs mismatch.");
        this.mByteOrder = order;
        this.mAttributes = attributes;
    }

    @NonNull
    public static ExifData create(@NonNull ImageProxy imageProxy, int rotationDegrees) {
        Builder builder = ExifData.builderForDevice();
        if (imageProxy.getImageInfo() != null) {
            imageProxy.getImageInfo().populateExifData(builder);
        }
        builder.setOrientationDegrees(rotationDegrees);
        return builder.setImageWidth(imageProxy.getWidth()).setImageHeight(imageProxy.getHeight()).build();
    }

    @NonNull
    public ByteOrder getByteOrder() {
        return this.mByteOrder;
    }

    @NonNull
    Map<String, ExifAttribute> getAttributes(int ifdIndex) {
        Preconditions.checkArgumentInRange((int)ifdIndex, (int)0, (int)EXIF_TAGS.length, (String)("Invalid IFD index: " + ifdIndex + ". Index should be between [0, EXIF_TAGS.length] "));
        return this.mAttributes.get(ifdIndex);
    }

    @Nullable
    public String getAttribute(@NonNull String tag) {
        ExifAttribute attribute = this.getExifAttribute(tag);
        if (attribute != null) {
            if (!sTagSetForCompatibility.contains(tag)) {
                return attribute.getStringValue(this.mByteOrder);
            }
            if (tag.equals("GPSTimeStamp")) {
                if (attribute.format != 5 && attribute.format != 10) {
                    Logger.w(TAG, "GPS Timestamp format is not rational. format=" + attribute.format);
                    return null;
                }
                Object[] array = (LongRational[])attribute.getValue(this.mByteOrder);
                if (array == null || array.length != 3) {
                    Logger.w(TAG, "Invalid GPS Timestamp array. array=" + Arrays.toString(array));
                    return null;
                }
                return String.format(Locale.US, "%02d:%02d:%02d", (int)((float)((LongRational)array[0]).getNumerator() / (float)((LongRational)array[0]).getDenominator()), (int)((float)((LongRational)array[1]).getNumerator() / (float)((LongRational)array[1]).getDenominator()), (int)((float)((LongRational)array[2]).getNumerator() / (float)((LongRational)array[2]).getDenominator()));
            }
            try {
                return Double.toString(attribute.getDoubleValue(this.mByteOrder));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    private ExifAttribute getExifAttribute(@NonNull String tag) {
        if ("ISOSpeedRatings".equals(tag)) {
            tag = "PhotographicSensitivity";
        }
        for (int i = 0; i < EXIF_TAGS.length; ++i) {
            ExifAttribute value = this.mAttributes.get(i).get(tag);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @NonNull
    public static Builder builderForDevice() {
        return new Builder(ByteOrder.BIG_ENDIAN).setAttribute("Orientation", String.valueOf(1)).setAttribute("XResolution", "72/1").setAttribute("YResolution", "72/1").setAttribute("ResolutionUnit", String.valueOf(2)).setAttribute("YCbCrPositioning", String.valueOf(1)).setAttribute("Make", Build.MANUFACTURER).setAttribute("Model", Build.MODEL);
    }

    public static final class Builder {
        private static final Pattern GPS_TIMESTAMP_PATTERN = Pattern.compile("^(\\d{2}):(\\d{2}):(\\d{2})$");
        private static final Pattern DATETIME_PRIMARY_FORMAT_PATTERN = Pattern.compile("^(\\d{4}):(\\d{2}):(\\d{2})\\s(\\d{2}):(\\d{2}):(\\d{2})$");
        private static final Pattern DATETIME_SECONDARY_FORMAT_PATTERN = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})\\s(\\d{2}):(\\d{2}):(\\d{2})$");
        private static final int DATETIME_VALUE_STRING_LENGTH = 19;
        static final List<HashMap<String, ExifTag>> sExifTagMapsForWriting = Collections.list(new Enumeration<HashMap<String, ExifTag>>(){
            int mIfdIndex = 0;

            @Override
            public boolean hasMoreElements() {
                return this.mIfdIndex < EXIF_TAGS.length;
            }

            @Override
            public HashMap<String, ExifTag> nextElement() {
                HashMap<String, ExifTag> map = new HashMap<String, ExifTag>();
                for (ExifTag tag : EXIF_TAGS[this.mIfdIndex]) {
                    map.put(tag.name, tag);
                }
                ++this.mIfdIndex;
                return map;
            }
        });
        final List<Map<String, ExifAttribute>> mAttributes = Collections.list(new Enumeration<Map<String, ExifAttribute>>(){
            int mIfdIndex = 0;

            @Override
            public boolean hasMoreElements() {
                return this.mIfdIndex < EXIF_TAGS.length;
            }

            @Override
            public Map<String, ExifAttribute> nextElement() {
                ++this.mIfdIndex;
                return new HashMap<String, ExifAttribute>();
            }
        });
        private final ByteOrder mByteOrder;

        Builder(@NonNull ByteOrder byteOrder) {
            this.mByteOrder = byteOrder;
        }

        @NonNull
        public Builder setImageWidth(int width) {
            return this.setAttribute("ImageWidth", String.valueOf(width));
        }

        @NonNull
        public Builder setImageHeight(int height) {
            return this.setAttribute("ImageLength", String.valueOf(height));
        }

        @NonNull
        public Builder setOrientationDegrees(int orientationDegrees) {
            int orientationEnum;
            switch (orientationDegrees) {
                case 0: {
                    orientationEnum = 1;
                    break;
                }
                case 90: {
                    orientationEnum = 6;
                    break;
                }
                case 180: {
                    orientationEnum = 3;
                    break;
                }
                case 270: {
                    orientationEnum = 8;
                    break;
                }
                default: {
                    Logger.w(ExifData.TAG, "Unexpected orientation value: " + orientationDegrees + ". Must be one of 0, 90, 180, 270.");
                    orientationEnum = 0;
                }
            }
            return this.setAttribute("Orientation", String.valueOf(orientationEnum));
        }

        @NonNull
        public Builder setFlashState(@NonNull CameraCaptureMetaData.FlashState flashState) {
            int value;
            if (flashState == CameraCaptureMetaData.FlashState.UNKNOWN) {
                return this;
            }
            switch (flashState) {
                case READY: {
                    value = 0;
                    break;
                }
                case NONE: {
                    value = 32;
                    break;
                }
                case FIRED: {
                    value = 1;
                    break;
                }
                default: {
                    Logger.w(ExifData.TAG, "Unknown flash state: " + (Object)((Object)flashState));
                    return this;
                }
            }
            if ((value & 1) == 1) {
                this.setAttribute("LightSource", String.valueOf(4));
            }
            return this.setAttribute("Flash", String.valueOf(value));
        }

        @NonNull
        public Builder setExposureTimeNanos(long exposureTimeNs) {
            return this.setAttribute("ExposureTime", String.valueOf((double)exposureTimeNs / (double)TimeUnit.SECONDS.toNanos(1L)));
        }

        @NonNull
        public Builder setLensFNumber(float fNumber) {
            return this.setAttribute("FNumber", String.valueOf(fNumber));
        }

        @NonNull
        public Builder setIso(int iso) {
            return this.setAttribute("SensitivityType", String.valueOf(3)).setAttribute("PhotographicSensitivity", String.valueOf(Math.min(65535, iso)));
        }

        @NonNull
        public Builder setFocalLength(float focalLength) {
            LongRational focalLengthRational = new LongRational((long)(focalLength * 1000.0f), 1000L);
            return this.setAttribute("FocalLength", focalLengthRational.toString());
        }

        @NonNull
        public Builder setWhiteBalanceMode(@NonNull WhiteBalanceMode whiteBalanceMode) {
            String wbString = null;
            switch (whiteBalanceMode.ordinal()) {
                case 0: {
                    wbString = String.valueOf(0);
                    break;
                }
                case 1: {
                    wbString = String.valueOf(1);
                }
            }
            return this.setAttribute("WhiteBalance", wbString);
        }

        @NonNull
        public Builder setAttribute(@NonNull String tag, @NonNull String value) {
            this.setAttributeInternal(tag, value, this.mAttributes);
            return this;
        }

        @NonNull
        public Builder removeAttribute(@NonNull String tag) {
            this.setAttributeInternal(tag, null, this.mAttributes);
            return this;
        }

        private void setAttributeIfMissing(@NonNull String tag, @NonNull String value, @NonNull List<Map<String, ExifAttribute>> attributes) {
            for (Map<String, ExifAttribute> attrs : attributes) {
                if (!attrs.containsKey(tag)) continue;
                return;
            }
            this.setAttributeInternal(tag, value, attributes);
        }

        private void setAttributeInternal(@NonNull String tag, @Nullable String value, @NonNull List<Map<String, ExifAttribute>> attributes) {
            if (("DateTime".equals(tag) || "DateTimeOriginal".equals(tag) || "DateTimeDigitized".equals(tag)) && value != null) {
                boolean isPrimaryFormat = DATETIME_PRIMARY_FORMAT_PATTERN.matcher(value).find();
                boolean isSecondaryFormat = DATETIME_SECONDARY_FORMAT_PATTERN.matcher(value).find();
                if (value.length() != 19 || !isPrimaryFormat && !isSecondaryFormat) {
                    Logger.w(ExifData.TAG, "Invalid value for " + tag + " : " + value);
                    return;
                }
                if (isSecondaryFormat) {
                    value = value.replaceAll("-", ":");
                }
            }
            if ("ISOSpeedRatings".equals(tag)) {
                tag = "PhotographicSensitivity";
            }
            if (value != null && sTagSetForCompatibility.contains(tag)) {
                if (tag.equals("GPSTimeStamp")) {
                    Matcher m = GPS_TIMESTAMP_PATTERN.matcher(value);
                    if (!m.find()) {
                        Logger.w(ExifData.TAG, "Invalid value for " + tag + " : " + value);
                        return;
                    }
                    value = Integer.parseInt((String)Preconditions.checkNotNull((Object)m.group(1))) + "/1," + Integer.parseInt((String)Preconditions.checkNotNull((Object)m.group(2))) + "/1," + Integer.parseInt((String)Preconditions.checkNotNull((Object)m.group(3))) + "/1";
                } else {
                    try {
                        double doubleValue = Double.parseDouble(value);
                        value = new LongRational(doubleValue).toString();
                    }
                    catch (NumberFormatException e) {
                        Logger.w(ExifData.TAG, "Invalid value for " + tag + " : " + value, e);
                        return;
                    }
                }
            }
            block12: for (int i = 0; i < EXIF_TAGS.length; ++i) {
                int dataFormat;
                ExifTag exifTag = sExifTagMapsForWriting.get(i).get(tag);
                if (exifTag == null) continue;
                if (value == null) {
                    attributes.get(i).remove(tag);
                    continue;
                }
                Pair<Integer, Integer> guess = Builder.guessDataFormat(value);
                if (exifTag.primaryFormat == (Integer)guess.first || exifTag.primaryFormat == (Integer)guess.second) {
                    dataFormat = exifTag.primaryFormat;
                } else if (exifTag.secondaryFormat != -1 && (exifTag.secondaryFormat == (Integer)guess.first || exifTag.secondaryFormat == (Integer)guess.second)) {
                    dataFormat = exifTag.secondaryFormat;
                } else {
                    if (exifTag.primaryFormat != 1 && exifTag.primaryFormat != 7 && exifTag.primaryFormat != 2) continue;
                    dataFormat = exifTag.primaryFormat;
                }
                switch (dataFormat) {
                    case 1: {
                        attributes.get(i).put(tag, ExifAttribute.createByte(value));
                        continue block12;
                    }
                    case 2: 
                    case 7: {
                        attributes.get(i).put(tag, ExifAttribute.createString(value));
                        continue block12;
                    }
                    case 3: {
                        int j;
                        String[] values = value.split(",", -1);
                        int[] intArray = new int[values.length];
                        for (j = 0; j < values.length; ++j) {
                            intArray[j] = Integer.parseInt(values[j]);
                        }
                        attributes.get(i).put(tag, ExifAttribute.createUShort(intArray, this.mByteOrder));
                        continue block12;
                    }
                    case 9: {
                        int j;
                        String[] values = value.split(",", -1);
                        int[] intArray = new int[values.length];
                        for (j = 0; j < values.length; ++j) {
                            intArray[j] = Integer.parseInt(values[j]);
                        }
                        attributes.get(i).put(tag, ExifAttribute.createSLong(intArray, this.mByteOrder));
                        continue block12;
                    }
                    case 4: {
                        int j;
                        String[] values = value.split(",", -1);
                        long[] longArray = new long[values.length];
                        for (j = 0; j < values.length; ++j) {
                            longArray[j] = Long.parseLong(values[j]);
                        }
                        attributes.get(i).put(tag, ExifAttribute.createULong(longArray, this.mByteOrder));
                        continue block12;
                    }
                    case 5: {
                        String[] numbers;
                        int j;
                        String[] values = value.split(",", -1);
                        LongRational[] rationalArray = new LongRational[values.length];
                        for (j = 0; j < values.length; ++j) {
                            numbers = values[j].split("/", -1);
                            rationalArray[j] = new LongRational((long)Double.parseDouble(numbers[0]), (long)Double.parseDouble(numbers[1]));
                        }
                        attributes.get(i).put(tag, ExifAttribute.createURational(rationalArray, this.mByteOrder));
                        continue block12;
                    }
                    case 10: {
                        String[] numbers;
                        int j;
                        String[] values = value.split(",", -1);
                        LongRational[] rationalArray = new LongRational[values.length];
                        for (j = 0; j < values.length; ++j) {
                            numbers = values[j].split("/", -1);
                            rationalArray[j] = new LongRational((long)Double.parseDouble(numbers[0]), (long)Double.parseDouble(numbers[1]));
                        }
                        attributes.get(i).put(tag, ExifAttribute.createSRational(rationalArray, this.mByteOrder));
                        continue block12;
                    }
                    case 12: {
                        int j;
                        String[] values = value.split(",", -1);
                        double[] doubleArray = new double[values.length];
                        for (j = 0; j < values.length; ++j) {
                            doubleArray[j] = Double.parseDouble(values[j]);
                        }
                        attributes.get(i).put(tag, ExifAttribute.createDouble(doubleArray, this.mByteOrder));
                        continue block12;
                    }
                }
            }
        }

        @NonNull
        public ExifData build() {
            ArrayList<Map<String, ExifAttribute>> attributes = Collections.list(new Enumeration<Map<String, ExifAttribute>>(){
                final Enumeration<Map<String, ExifAttribute>> mMapEnumeration;
                {
                    this.mMapEnumeration = Collections.enumeration(mAttributes);
                }

                @Override
                public boolean hasMoreElements() {
                    return this.mMapEnumeration.hasMoreElements();
                }

                @Override
                public Map<String, ExifAttribute> nextElement() {
                    return new HashMap<String, ExifAttribute>(this.mMapEnumeration.nextElement());
                }
            });
            if (!((Map)attributes.get(1)).isEmpty()) {
                this.setAttributeIfMissing("ExposureProgram", String.valueOf(0), attributes);
                this.setAttributeIfMissing("ExifVersion", "0230", attributes);
                this.setAttributeIfMissing("ComponentsConfiguration", COMPONENTS_CONFIGURATION_YCBCR, attributes);
                this.setAttributeIfMissing("MeteringMode", String.valueOf(0), attributes);
                this.setAttributeIfMissing("LightSource", String.valueOf(0), attributes);
                this.setAttributeIfMissing("FlashpixVersion", "0100", attributes);
                this.setAttributeIfMissing("FocalPlaneResolutionUnit", String.valueOf(2), attributes);
                this.setAttributeIfMissing("FileSource", String.valueOf(3), attributes);
                this.setAttributeIfMissing("SceneType", String.valueOf(1), attributes);
                this.setAttributeIfMissing("CustomRendered", String.valueOf(0), attributes);
                this.setAttributeIfMissing("SceneCaptureType", String.valueOf(0), attributes);
                this.setAttributeIfMissing("Contrast", String.valueOf(0), attributes);
                this.setAttributeIfMissing("Saturation", String.valueOf(0), attributes);
                this.setAttributeIfMissing("Sharpness", String.valueOf(0), attributes);
            }
            if (!((Map)attributes.get(2)).isEmpty()) {
                this.setAttributeIfMissing("GPSVersionID", "2300", attributes);
                this.setAttributeIfMissing("GPSSpeedRef", "K", attributes);
                this.setAttributeIfMissing("GPSTrackRef", "T", attributes);
                this.setAttributeIfMissing("GPSImgDirectionRef", "T", attributes);
                this.setAttributeIfMissing("GPSDestBearingRef", "T", attributes);
                this.setAttributeIfMissing("GPSDestDistanceRef", "K", attributes);
            }
            return new ExifData(this.mByteOrder, attributes);
        }

        private static Pair<Integer, Integer> guessDataFormat(String entryValue) {
            if (entryValue.contains(",")) {
                String[] entryValues = entryValue.split(",", -1);
                Pair dataFormat = Builder.guessDataFormat(entryValues[0]);
                if ((Integer)dataFormat.first == 2) {
                    return dataFormat;
                }
                for (int i = 1; i < entryValues.length; ++i) {
                    Pair<Integer, Integer> guessDataFormat = Builder.guessDataFormat(entryValues[i]);
                    int first = -1;
                    int second = -1;
                    if (((Integer)guessDataFormat.first).equals(dataFormat.first) || ((Integer)guessDataFormat.second).equals(dataFormat.first)) {
                        first = (Integer)dataFormat.first;
                    }
                    if ((Integer)dataFormat.second != -1 && (((Integer)guessDataFormat.first).equals(dataFormat.second) || ((Integer)guessDataFormat.second).equals(dataFormat.second))) {
                        second = (Integer)dataFormat.second;
                    }
                    if (first == -1 && second == -1) {
                        return new Pair((Object)2, (Object)-1);
                    }
                    if (first == -1) {
                        dataFormat = new Pair((Object)second, (Object)-1);
                        continue;
                    }
                    if (second != -1) continue;
                    dataFormat = new Pair((Object)first, (Object)-1);
                }
                return dataFormat;
            }
            if (entryValue.contains("/")) {
                String[] rationalNumber = entryValue.split("/", -1);
                if (rationalNumber.length == 2) {
                    try {
                        long numerator = (long)Double.parseDouble(rationalNumber[0]);
                        long denominator = (long)Double.parseDouble(rationalNumber[1]);
                        if (numerator < 0L || denominator < 0L) {
                            return new Pair((Object)10, (Object)-1);
                        }
                        if (numerator > Integer.MAX_VALUE || denominator > Integer.MAX_VALUE) {
                            return new Pair((Object)5, (Object)-1);
                        }
                        return new Pair((Object)10, (Object)5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return new Pair((Object)2, (Object)-1);
            }
            try {
                long longValue = Long.parseLong(entryValue);
                if (longValue >= 0L && longValue <= 65535L) {
                    return new Pair((Object)3, (Object)4);
                }
                if (longValue < 0L) {
                    return new Pair((Object)9, (Object)-1);
                }
                return new Pair((Object)4, (Object)-1);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    Double.parseDouble(entryValue);
                    return new Pair((Object)12, (Object)-1);
                }
                catch (NumberFormatException numberFormatException2) {
                    return new Pair((Object)2, (Object)-1);
                }
            }
        }
    }

    public static enum WhiteBalanceMode {
        AUTO,
        MANUAL;

    }
}

