/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import androidx.annotation.GuardedBy;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0011\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\b\u0010\u0011\u001a\u00020\u000bH\u0002J\u0006\u0010\u0012\u001a\u00020\u000bJ\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/camera/core/internal/ScreenFlashWrapper;", "Landroidx/camera/core/ImageCapture$ScreenFlash;", "screenFlash", "(Landroidx/camera/core/ImageCapture$ScreenFlash;)V", "isClearScreenFlashPending", "", "lock", "Ljava/lang/Object;", "pendingListener", "Landroidx/camera/core/ImageCapture$ScreenFlashListener;", "apply", "", "expirationTimeMillis", "", "screenFlashListener", "clear", "completePendingScreenFlashClear", "completePendingScreenFlashListener", "completePendingTasks", "getBaseScreenFlash", "Companion", "camera-core_release"})
public final class ScreenFlashWrapper
implements ImageCapture.ScreenFlash {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ImageCapture.ScreenFlash screenFlash;
    @NotNull
    private final Object lock;
    @GuardedBy(value="lock")
    private boolean isClearScreenFlashPending;
    @GuardedBy(value="lock")
    @Nullable
    private ImageCapture.ScreenFlashListener pendingListener;
    @NotNull
    private static final String TAG = "ScreenFlashWrapper";

    private ScreenFlashWrapper(ImageCapture.ScreenFlash screenFlash) {
        this.screenFlash = screenFlash;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(long expirationTimeMillis, @NotNull ImageCapture.ScreenFlashListener screenFlashListener) {
        block5: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)screenFlashListener, (String)"screenFlashListener");
            Object object = this.lock;
            synchronized (object) {
                boolean $i$a$-synchronized-ScreenFlashWrapper$apply$22 = false;
                this.isClearScreenFlashPending = true;
                this.pendingListener = screenFlashListener;
                Unit $i$a$-synchronized-ScreenFlashWrapper$apply$22 = Unit.INSTANCE;
            }
            ImageCapture.ScreenFlash screenFlash = this.screenFlash;
            if (screenFlash != null) {
                screenFlash.apply(expirationTimeMillis, () -> ScreenFlashWrapper.apply$lambda$2(this));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block5;
            ScreenFlashWrapper $this$apply_u24lambda_u243 = this;
            boolean bl = false;
            Logger.e(TAG, "apply: screenFlash is null!");
            $this$apply_u24lambda_u243.completePendingScreenFlashListener();
        }
    }

    @Override
    public void clear() {
        this.completePendingScreenFlashClear();
    }

    @Nullable
    public final ImageCapture.ScreenFlash getBaseScreenFlash() {
        return this.screenFlash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void completePendingScreenFlashListener() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            ImageCapture.ScreenFlashListener screenFlashListener = this.pendingListener;
            if (screenFlashListener != null) {
                screenFlashListener.onCompleted();
            }
            this.pendingListener = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void completePendingScreenFlashClear() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.isClearScreenFlashPending) {
                Unit unit;
                ImageCapture.ScreenFlash screenFlash = this.screenFlash;
                if (screenFlash != null) {
                    screenFlash.clear();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    ScreenFlashWrapper $this$completePendingScreenFlashClear_u24lambda_u246_u24lambda_u245 = this;
                    boolean bl2 = false;
                    Logger.e(TAG, "completePendingScreenFlashClear: screenFlash is null!");
                }
            } else {
                Logger.w(TAG, "completePendingScreenFlashClear: none pending!");
            }
            this.isClearScreenFlashPending = false;
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void completePendingTasks() {
        this.completePendingScreenFlashListener();
        this.completePendingScreenFlashClear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void apply$lambda$2(ScreenFlashWrapper this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            if (this$0.pendingListener == null) {
                Logger.w(TAG, "apply: pendingListener is null!");
            }
            this$0.completePendingScreenFlashListener();
            Unit unit = Unit.INSTANCE;
        }
    }

    @JvmStatic
    @NotNull
    public static final ScreenFlashWrapper from(@Nullable ImageCapture.ScreenFlash screenFlash) {
        return Companion.from(screenFlash);
    }

    public /* synthetic */ ScreenFlashWrapper(ImageCapture.ScreenFlash screenFlash, DefaultConstructorMarker $constructor_marker) {
        this(screenFlash);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/camera/core/internal/ScreenFlashWrapper$Companion;", "", "()V", "TAG", "", "from", "Landroidx/camera/core/internal/ScreenFlashWrapper;", "screenFlash", "Landroidx/camera/core/ImageCapture$ScreenFlash;", "camera-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ScreenFlashWrapper from(@Nullable ImageCapture.ScreenFlash screenFlash) {
            return new ScreenFlashWrapper(screenFlash, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

