/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.AspectRatioUtil;
import androidx.camera.core.impl.utils.CameraOrientationUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.internal.SupportedOutputSizesSorterLegacy;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.camera.core.resolutionselector.AspectRatioStrategy;
import androidx.camera.core.resolutionselector.ResolutionFilter;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import androidx.camera.core.resolutionselector.ResolutionStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SupportedOutputSizesSorter {
    private static final String TAG = "SupportedOutputSizesCollector";
    private final CameraInfoInternal mCameraInfoInternal;
    private final int mSensorOrientation;
    private final int mLensFacing;
    private final Rational mFullFovRatio;
    private final SupportedOutputSizesSorterLegacy mSupportedOutputSizesSorterLegacy;

    public SupportedOutputSizesSorter(@NonNull CameraInfoInternal cameraInfoInternal, @Nullable Size activeArraySize) {
        this.mCameraInfoInternal = cameraInfoInternal;
        this.mSensorOrientation = this.mCameraInfoInternal.getSensorRotationDegrees();
        this.mLensFacing = this.mCameraInfoInternal.getLensFacing();
        this.mFullFovRatio = activeArraySize != null ? this.calculateFullFovRatioFromActiveArraySize(activeArraySize) : this.calculateFullFovRatioFromSupportedOutputSizes(this.mCameraInfoInternal);
        this.mSupportedOutputSizesSorterLegacy = new SupportedOutputSizesSorterLegacy(cameraInfoInternal, this.mFullFovRatio);
    }

    @NonNull
    private Rational calculateFullFovRatioFromActiveArraySize(@NonNull Size activeArraySize) {
        return new Rational(activeArraySize.getWidth(), activeArraySize.getHeight());
    }

    @Nullable
    private Rational calculateFullFovRatioFromSupportedOutputSizes(@NonNull CameraInfoInternal cameraInfoInternal) {
        List<Size> jpegOutputSizes = cameraInfoInternal.getSupportedResolutions(256);
        if (jpegOutputSizes.isEmpty()) {
            return null;
        }
        Size maxSize = Collections.max(jpegOutputSizes, new CompareSizesByArea());
        return new Rational(maxSize.getWidth(), maxSize.getHeight());
    }

    @NonNull
    public List<Size> getSortedSupportedOutputSizes(@NonNull UseCaseConfig<?> useCaseConfig) {
        ImageOutputConfig imageOutputConfig = (ImageOutputConfig)((Object)useCaseConfig);
        List<Size> customOrderedResolutions = imageOutputConfig.getCustomOrderedResolutions(null);
        if (customOrderedResolutions != null) {
            return customOrderedResolutions;
        }
        ResolutionSelector resolutionSelector = imageOutputConfig.getResolutionSelector(null);
        List<Pair<Integer, Size[]>> customResolutions = imageOutputConfig.getSupportedResolutions(null);
        List<Size> candidateSizes = this.getResolutionCandidateList(customResolutions, useCaseConfig.getInputFormat());
        if (resolutionSelector == null) {
            return this.mSupportedOutputSizesSorterLegacy.sortSupportedOutputSizes(candidateSizes, useCaseConfig);
        }
        Size maxResolution = ((ImageOutputConfig)((Object)useCaseConfig)).getMaxResolution(null);
        int targetRotation = imageOutputConfig.getTargetRotation(0);
        if (!useCaseConfig.isHighResolutionDisabled(false)) {
            candidateSizes = this.applyHighResolutionSettings(candidateSizes, resolutionSelector, useCaseConfig.getInputFormat());
        }
        return SupportedOutputSizesSorter.sortSupportedOutputSizesByResolutionSelector(imageOutputConfig.getResolutionSelector(), candidateSizes, maxResolution, targetRotation, this.mFullFovRatio, this.mSensorOrientation, this.mLensFacing);
    }

    @Nullable
    private List<Size> getSizeListByFormat(@Nullable List<Pair<Integer, Size[]>> resolutionsPairList, int imageFormat) {
        Size[] outputSizes = null;
        if (resolutionsPairList != null) {
            for (Pair<Integer, Size[]> formatResolutionPair : resolutionsPairList) {
                if ((Integer)formatResolutionPair.first != imageFormat) continue;
                outputSizes = (Size[])formatResolutionPair.second;
                break;
            }
        }
        return outputSizes == null ? null : Arrays.asList(outputSizes);
    }

    @NonNull
    public static List<Size> sortSupportedOutputSizesByResolutionSelector(@NonNull ResolutionSelector resolutionSelector, @NonNull List<Size> candidateSizes, @Nullable Size maxResolution, int targetRotation, @NonNull Rational fullFovRatio, int sensorOrientation, int lensFacing) {
        LinkedHashMap<Rational, List<Size>> aspectRatioSizeListMap = SupportedOutputSizesSorter.applyAspectRatioStrategy(candidateSizes, resolutionSelector.getAspectRatioStrategy(), fullFovRatio);
        if (maxResolution != null) {
            SupportedOutputSizesSorter.applyMaxResolutionRestriction(aspectRatioSizeListMap, maxResolution);
        }
        SupportedOutputSizesSorter.applyResolutionStrategy(aspectRatioSizeListMap, resolutionSelector.getResolutionStrategy());
        ArrayList<Size> resultList = new ArrayList<Size>();
        for (List<Size> sortedSizes : aspectRatioSizeListMap.values()) {
            for (Size size : sortedSizes) {
                if (resultList.contains(size)) continue;
                resultList.add(size);
            }
        }
        return SupportedOutputSizesSorter.applyResolutionFilter(resultList, resolutionSelector.getResolutionFilter(), targetRotation, sensorOrientation, lensFacing);
    }

    @NonNull
    private List<Size> getResolutionCandidateList(@Nullable List<Pair<Integer, Size[]>> customResolutions, int imageFormat) {
        List<Size> resolutionCandidateList = this.getSizeListByFormat(customResolutions, imageFormat);
        if (resolutionCandidateList == null) {
            resolutionCandidateList = this.mCameraInfoInternal.getSupportedResolutions(imageFormat);
        }
        resolutionCandidateList = new ArrayList<Size>(resolutionCandidateList);
        Collections.sort(resolutionCandidateList, new CompareSizesByArea(true));
        if (resolutionCandidateList.isEmpty()) {
            Logger.w(TAG, "The retrieved supported resolutions from camera info internal is empty. Format is " + imageFormat + ".");
        }
        return resolutionCandidateList;
    }

    @NonNull
    private List<Size> applyHighResolutionSettings(@NonNull List<Size> resolutionCandidateList, @NonNull ResolutionSelector resolutionSelector, int imageFormat) {
        if (resolutionSelector.getAllowedResolutionMode() == 1) {
            ArrayList<Size> allSizesList = new ArrayList<Size>();
            allSizesList.addAll(resolutionCandidateList);
            allSizesList.addAll(this.mCameraInfoInternal.getSupportedHighResolutions(imageFormat));
            Collections.sort(allSizesList, new CompareSizesByArea(true));
            return allSizesList;
        }
        return resolutionCandidateList;
    }

    @NonNull
    private static LinkedHashMap<Rational, List<Size>> applyAspectRatioStrategy(@NonNull List<Size> resolutionCandidateList, @NonNull AspectRatioStrategy aspectRatioStrategy, Rational fullFovRatio) {
        Map<Rational, List<Size>> aspectRatioSizeListMap = SupportedOutputSizesSorter.groupSizesByAspectRatio(resolutionCandidateList);
        return SupportedOutputSizesSorter.applyAspectRatioStrategyFallbackRule(aspectRatioSizeListMap, aspectRatioStrategy, fullFovRatio);
    }

    private static LinkedHashMap<Rational, List<Size>> applyAspectRatioStrategyFallbackRule(@NonNull Map<Rational, List<Size>> sizeGroupsMap, @NonNull AspectRatioStrategy aspectRatioStrategy, Rational fullFovRatio) {
        boolean isSensorLandscapeResolution = fullFovRatio != null ? fullFovRatio.getNumerator() >= fullFovRatio.getDenominator() : true;
        Rational aspectRatio = SupportedOutputSizesSorter.getTargetAspectRatioRationalValue(aspectRatioStrategy.getPreferredAspectRatio(), isSensorLandscapeResolution);
        if (aspectRatioStrategy.getFallbackRule() == 0) {
            Rational preferredAspectRatio = SupportedOutputSizesSorter.getTargetAspectRatioRationalValue(aspectRatioStrategy.getPreferredAspectRatio(), isSensorLandscapeResolution);
            for (Rational ratio : new ArrayList<Rational>(sizeGroupsMap.keySet())) {
                if (ratio.equals((Object)preferredAspectRatio)) continue;
                sizeGroupsMap.remove(ratio);
            }
        }
        ArrayList<Rational> aspectRatios = new ArrayList<Rational>(sizeGroupsMap.keySet());
        Collections.sort(aspectRatios, new AspectRatioUtil.CompareAspectRatiosByMappingAreaInFullFovAspectRatioSpace(aspectRatio, fullFovRatio));
        LinkedHashMap<Rational, List<Size>> sortedAspectRatioSizeListMap = new LinkedHashMap<Rational, List<Size>>();
        for (Rational ratio : aspectRatios) {
            sortedAspectRatioSizeListMap.put(ratio, sizeGroupsMap.get(ratio));
        }
        return sortedAspectRatioSizeListMap;
    }

    private static void applyResolutionStrategy(@NonNull LinkedHashMap<Rational, List<Size>> sortedAspectRatioSizeListMap, @Nullable ResolutionStrategy resolutionStrategy) {
        if (resolutionStrategy == null) {
            return;
        }
        for (Rational key : sortedAspectRatioSizeListMap.keySet()) {
            SupportedOutputSizesSorter.applyResolutionStrategyFallbackRule(sortedAspectRatioSizeListMap.get(key), resolutionStrategy);
        }
    }

    private static void applyResolutionStrategyFallbackRule(@NonNull List<Size> supportedSizesList, @NonNull ResolutionStrategy resolutionStrategy) {
        if (supportedSizesList.isEmpty()) {
            return;
        }
        Integer fallbackRule = resolutionStrategy.getFallbackRule();
        if (resolutionStrategy.equals(ResolutionStrategy.HIGHEST_AVAILABLE_STRATEGY)) {
            return;
        }
        Size boundSize = resolutionStrategy.getBoundSize();
        switch (fallbackRule) {
            case 0: {
                SupportedOutputSizesSorter.sortSupportedSizesByFallbackRuleNone(supportedSizesList, boundSize);
                break;
            }
            case 1: {
                SupportedOutputSizesSorter.sortSupportedSizesByFallbackRuleClosestHigherThenLower(supportedSizesList, boundSize, true);
                break;
            }
            case 2: {
                SupportedOutputSizesSorter.sortSupportedSizesByFallbackRuleClosestHigherThenLower(supportedSizesList, boundSize, false);
                break;
            }
            case 3: {
                SupportedOutputSizesSorter.sortSupportedSizesByFallbackRuleClosestLowerThenHigher(supportedSizesList, boundSize, true);
                break;
            }
            case 4: {
                SupportedOutputSizesSorter.sortSupportedSizesByFallbackRuleClosestLowerThenHigher(supportedSizesList, boundSize, false);
                break;
            }
        }
    }

    private static void applyMaxResolutionRestriction(@NonNull LinkedHashMap<Rational, List<Size>> sortedAspectRatioSizeListMap, @NonNull Size maxResolution) {
        int maxResolutionAreaSize = SizeUtil.getArea(maxResolution);
        for (Rational key : sortedAspectRatioSizeListMap.keySet()) {
            List<Size> supportedSizesList = sortedAspectRatioSizeListMap.get(key);
            ArrayList<Size> filteredResultList = new ArrayList<Size>();
            for (Size size : supportedSizesList) {
                if (SizeUtil.getArea(size) > maxResolutionAreaSize) continue;
                filteredResultList.add(size);
            }
            supportedSizesList.clear();
            supportedSizesList.addAll(filteredResultList);
        }
    }

    @NonNull
    private static List<Size> applyResolutionFilter(@NonNull List<Size> sizeList, @Nullable ResolutionFilter resolutionFilter, int targetRotation, int sensorOrientation, int lensFacing) {
        if (resolutionFilter == null) {
            return sizeList;
        }
        int destRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees(targetRotation);
        int rotationDegrees = CameraOrientationUtil.getRelativeImageRotation(destRotationDegrees, sensorOrientation, lensFacing == 1);
        List<Size> filteredResultList = resolutionFilter.filter(new ArrayList<Size>(sizeList), rotationDegrees);
        if (sizeList.containsAll(filteredResultList)) {
            return filteredResultList;
        }
        throw new IllegalArgumentException("The returned sizes list of the resolution filter must be a subset of the provided sizes list.");
    }

    private static void sortSupportedSizesByFallbackRuleNone(@NonNull List<Size> supportedSizesList, @NonNull Size boundSize) {
        boolean containsBoundSize = supportedSizesList.contains(boundSize);
        supportedSizesList.clear();
        if (containsBoundSize) {
            supportedSizesList.add(boundSize);
        }
    }

    static void sortSupportedSizesByFallbackRuleClosestHigherThenLower(@NonNull List<Size> supportedSizesList, @NonNull Size boundSize, boolean keepLowerSizes) {
        Size outputSize;
        ArrayList<Size> lowerSizes = new ArrayList<Size>();
        for (int i = supportedSizesList.size() - 1; i >= 0 && ((outputSize = supportedSizesList.get(i)).getWidth() < boundSize.getWidth() || outputSize.getHeight() < boundSize.getHeight()); --i) {
            lowerSizes.add(0, outputSize);
        }
        supportedSizesList.removeAll(lowerSizes);
        Collections.reverse(supportedSizesList);
        if (keepLowerSizes) {
            supportedSizesList.addAll(lowerSizes);
        }
    }

    private static void sortSupportedSizesByFallbackRuleClosestLowerThenHigher(@NonNull List<Size> supportedSizesList, @NonNull Size boundSize, boolean keepHigherSizes) {
        Size outputSize;
        ArrayList<Size> higherSizes = new ArrayList<Size>();
        for (int i = 0; i < supportedSizesList.size() && ((outputSize = supportedSizesList.get(i)).getWidth() > boundSize.getWidth() || outputSize.getHeight() > boundSize.getHeight()); ++i) {
            higherSizes.add(0, outputSize);
        }
        supportedSizesList.removeAll(higherSizes);
        if (keepHigherSizes) {
            supportedSizesList.addAll(higherSizes);
        }
    }

    @Nullable
    static Rational getTargetAspectRatioRationalValue(int aspectRatio, boolean isSensorLandscapeResolution) {
        Rational outputRatio = null;
        switch (aspectRatio) {
            case 0: {
                outputRatio = isSensorLandscapeResolution ? AspectRatioUtil.ASPECT_RATIO_4_3 : AspectRatioUtil.ASPECT_RATIO_3_4;
                break;
            }
            case 1: {
                outputRatio = isSensorLandscapeResolution ? AspectRatioUtil.ASPECT_RATIO_16_9 : AspectRatioUtil.ASPECT_RATIO_9_16;
                break;
            }
            case -1: {
                break;
            }
            default: {
                Logger.e(TAG, "Undefined target aspect ratio: " + aspectRatio);
            }
        }
        return outputRatio;
    }

    @NonNull
    static List<Rational> getResolutionListGroupingAspectRatioKeys(@NonNull List<Size> resolutionCandidateList) {
        ArrayList<Rational> aspectRatios = new ArrayList<Rational>();
        aspectRatios.add(AspectRatioUtil.ASPECT_RATIO_4_3);
        aspectRatios.add(AspectRatioUtil.ASPECT_RATIO_16_9);
        for (Size size : resolutionCandidateList) {
            Rational newRatio = new Rational(size.getWidth(), size.getHeight());
            boolean aspectRatioFound = aspectRatios.contains(newRatio);
            if (aspectRatioFound) continue;
            boolean hasMatchingAspectRatio = false;
            for (Rational aspectRatio : aspectRatios) {
                if (!AspectRatioUtil.hasMatchingAspectRatio(size, aspectRatio)) continue;
                hasMatchingAspectRatio = true;
                break;
            }
            if (hasMatchingAspectRatio) continue;
            aspectRatios.add(newRatio);
        }
        return aspectRatios;
    }

    static Map<Rational, List<Size>> groupSizesByAspectRatio(@NonNull List<Size> sizes) {
        HashMap<Rational, List<Size>> aspectRatioSizeListMap = new HashMap<Rational, List<Size>>();
        List<Rational> aspectRatioKeys = SupportedOutputSizesSorter.getResolutionListGroupingAspectRatioKeys(sizes);
        for (Rational aspectRatio : aspectRatioKeys) {
            aspectRatioSizeListMap.put(aspectRatio, new ArrayList());
        }
        for (Size outputSize : sizes) {
            for (Rational key : aspectRatioSizeListMap.keySet()) {
                if (!AspectRatioUtil.hasMatchingAspectRatio(outputSize, key)) continue;
                ((List)aspectRatioSizeListMap.get(key)).add(outputSize);
            }
        }
        return aspectRatioSizeListMap;
    }
}

