/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal.compat.quirk;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.Quirk;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class ImageCaptureFailedForSpecificCombinationQuirk
implements Quirk {
    private static final Set<String> PIXEL_MODELS = new HashSet<String>(Arrays.asList("pixel 4a", "pixel 4a (5g)", "pixel 5", "pixel 5a"));

    static boolean load() {
        return ImageCaptureFailedForSpecificCombinationQuirk.isOnePlus12() || ImageCaptureFailedForSpecificCombinationQuirk.isPixelProblematicDevice();
    }

    private static boolean isOnePlus12() {
        return "oneplus".equalsIgnoreCase(Build.BRAND) && "cph2583".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isPixelProblematicDevice() {
        return "google".equalsIgnoreCase(Build.BRAND) && PIXEL_MODELS.contains(Build.MODEL.toLowerCase());
    }

    public boolean shouldForceEnableStreamSharing(@NonNull String cameraId, @NonNull Collection<UseCase> appUseCases) {
        if (ImageCaptureFailedForSpecificCombinationQuirk.isOnePlus12()) {
            return this.shouldForceEnableStreamSharingForOnePlus12(cameraId, appUseCases);
        }
        if (ImageCaptureFailedForSpecificCombinationQuirk.isPixelProblematicDevice()) {
            return this.shouldForceEnableStreamSharingForPixelDevice(cameraId, appUseCases);
        }
        return false;
    }

    private boolean shouldForceEnableStreamSharingForOnePlus12(@NonNull String cameraId, @NonNull Collection<UseCase> appUseCases) {
        return cameraId.equals("1") && this.isVideoCapturePreviewImageCaptureCombination(appUseCases);
    }

    private boolean shouldForceEnableStreamSharingForPixelDevice(@NonNull String cameraId, @NonNull Collection<UseCase> appUseCases) {
        return cameraId.equals("1") && this.isVideoCapturePreviewImageCaptureCombination(appUseCases);
    }

    private boolean isVideoCapturePreviewImageCaptureCombination(@NonNull Collection<UseCase> appUseCases) {
        if (appUseCases.size() != 3) {
            return false;
        }
        boolean hasPreview = false;
        boolean hasVideoCapture = false;
        boolean hasImageCapture = false;
        for (UseCase useCase : appUseCases) {
            if (useCase instanceof Preview) {
                hasPreview = true;
                continue;
            }
            if (useCase instanceof ImageCapture) {
                hasImageCapture = true;
                continue;
            }
            if (!useCase.getCurrentConfig().containsOption(UseCaseConfig.OPTION_CAPTURE_TYPE)) continue;
            hasVideoCapture = useCase.getCurrentConfig().getCaptureType() == UseCaseConfigFactory.CaptureType.VIDEO_CAPTURE;
        }
        return hasPreview && hasVideoCapture && hasImageCapture;
    }
}

