/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing;

import androidx.annotation.NonNull;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProcessor;
import androidx.camera.core.ProcessingException;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import java.util.Objects;
import java.util.concurrent.Executor;

public class InternalImageProcessor {
    @NonNull
    private final Executor mExecutor;
    @NonNull
    private final ImageProcessor mImageProcessor;
    @NonNull
    private final Consumer<Throwable> mErrorListener;

    public InternalImageProcessor(@NonNull CameraEffect cameraEffect) {
        Preconditions.checkArgument((cameraEffect.getTargets() == 4 ? 1 : 0) != 0);
        this.mExecutor = cameraEffect.getExecutor();
        this.mImageProcessor = Objects.requireNonNull(cameraEffect.getImageProcessor());
        this.mErrorListener = cameraEffect.getErrorListener();
    }

    @NonNull
    public ImageProcessor.Response safeProcess(@NonNull ImageProcessor.Request request) throws ImageCaptureException {
        try {
            return (ImageProcessor.Response)CallbackToFutureAdapter.getFuture(completer -> {
                this.mExecutor.execute(() -> {
                    ImageProcessor.Response response;
                    try {
                        response = this.mImageProcessor.process(request);
                    }
                    catch (ProcessingException e) {
                        this.mErrorListener.accept((Object)e);
                        completer.setException((Throwable)e);
                        return;
                    }
                    completer.set((Object)response);
                });
                return "InternalImageProcessor#process " + request.hashCode();
            }).get();
        }
        catch (Exception e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw new ImageCaptureException(0, "Failed to invoke ImageProcessor.", cause);
        }
    }
}

