/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.processing.util;

import android.graphics.Rect;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.processing.SurfaceEdge;
import androidx.camera.core.processing.util.AutoValue_OutConfig;
import com.google.auto.value.AutoValue;
import java.util.UUID;

@AutoValue
public abstract class OutConfig {
    @NonNull
    abstract UUID getUuid();

    public abstract int getTargets();

    public abstract int getFormat();

    @NonNull
    public abstract Rect getCropRect();

    @NonNull
    public abstract Size getSize();

    public abstract int getRotationDegrees();

    public abstract boolean isMirroring();

    public abstract boolean shouldRespectInputCropRect();

    @NonNull
    public static OutConfig of(@NonNull SurfaceEdge inputEdge) {
        return OutConfig.of(inputEdge.getTargets(), inputEdge.getFormat(), inputEdge.getCropRect(), TransformUtils.getRotatedSize(inputEdge.getCropRect(), inputEdge.getRotationDegrees()), inputEdge.getRotationDegrees(), inputEdge.isMirroring());
    }

    @NonNull
    public static OutConfig of(int targets, int format, @NonNull Rect cropRect, @NonNull Size size, int rotationDegrees, boolean mirroring) {
        return OutConfig.of(targets, format, cropRect, size, rotationDegrees, mirroring, false);
    }

    @NonNull
    public static OutConfig of(int targets, int format, @NonNull Rect cropRect, @NonNull Size size, int rotationDegrees, boolean mirroring, boolean shouldRespectInputCropRect) {
        return new AutoValue_OutConfig(UUID.randomUUID(), targets, format, cropRect, size, rotationDegrees, mirroring, shouldRespectInputCropRect);
    }
}

