/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.streamsharing;

import android.graphics.Rect;
import android.util.Log;
import android.util.Size;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.CompositionSettings;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.processing.DefaultSurfaceProcessor;
import androidx.camera.core.processing.SurfaceEdge;
import androidx.camera.core.processing.SurfaceProcessorNode;
import androidx.camera.core.processing.concurrent.DualOutConfig;
import androidx.camera.core.processing.concurrent.DualSurfaceProcessor;
import androidx.camera.core.processing.concurrent.DualSurfaceProcessorNode;
import androidx.camera.core.processing.util.OutConfig;
import androidx.camera.core.streamsharing.StreamSharingBuilder;
import androidx.camera.core.streamsharing.StreamSharingConfig;
import androidx.camera.core.streamsharing.VirtualCameraAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class StreamSharing
extends UseCase {
    private static final String TAG = "StreamSharing";
    @NonNull
    private final StreamSharingConfig mDefaultConfig;
    @NonNull
    private final VirtualCameraAdapter mVirtualCameraAdapter;
    @NonNull
    private final CompositionSettings mCompositionSettings;
    @NonNull
    private final CompositionSettings mSecondaryCompositionSettings;
    @Nullable
    private SurfaceProcessorNode mEffectNode;
    @Nullable
    private SurfaceProcessorNode mSharingNode;
    @Nullable
    private DualSurfaceProcessorNode mDualSharingNode;
    @Nullable
    private SurfaceEdge mCameraEdge;
    @Nullable
    private SurfaceEdge mSecondaryCameraEdge;
    @Nullable
    private SurfaceEdge mSharingInputEdge;
    @Nullable
    private SurfaceEdge mSecondarySharingInputEdge;
    SessionConfig.Builder mSessionConfigBuilder;
    SessionConfig.Builder mSecondarySessionConfigBuilder;
    @Nullable
    private SessionConfig.CloseableErrorListener mCloseableErrorListener;

    private static StreamSharingConfig getDefaultConfig(Set<UseCase> children) {
        MutableConfig mutableConfig = new StreamSharingBuilder().getMutableConfig();
        mutableConfig.insertOption(ImageInputConfig.OPTION_INPUT_FORMAT, 34);
        ArrayList<UseCaseConfigFactory.CaptureType> captureTypes = new ArrayList<UseCaseConfigFactory.CaptureType>();
        for (UseCase child : children) {
            if (child.getCurrentConfig().containsOption(UseCaseConfig.OPTION_CAPTURE_TYPE)) {
                captureTypes.add(child.getCurrentConfig().getCaptureType());
                continue;
            }
            Log.e((String)TAG, (String)"A child does not have capture type.");
        }
        mutableConfig.insertOption(StreamSharingConfig.OPTION_CAPTURE_TYPES, captureTypes);
        mutableConfig.insertOption(ImageOutputConfig.OPTION_MIRROR_MODE, 2);
        return new StreamSharingConfig(OptionsBundle.from(mutableConfig));
    }

    public StreamSharing(@NonNull CameraInternal camera, @Nullable CameraInternal secondaryCamera, @NonNull CompositionSettings compositionSettings, @NonNull CompositionSettings secondaryCompositionSettings, @NonNull Set<UseCase> children, @NonNull UseCaseConfigFactory useCaseConfigFactory) {
        super(StreamSharing.getDefaultConfig(children));
        this.mDefaultConfig = StreamSharing.getDefaultConfig(children);
        this.mCompositionSettings = compositionSettings;
        this.mSecondaryCompositionSettings = secondaryCompositionSettings;
        this.mVirtualCameraAdapter = new VirtualCameraAdapter(camera, secondaryCamera, children, useCaseConfigFactory, (jpegQuality, rotationDegrees) -> {
            SurfaceProcessorNode sharingNode = this.mSharingNode;
            if (sharingNode != null) {
                return sharingNode.getSurfaceProcessor().snapshot(jpegQuality, rotationDegrees);
            }
            return Futures.immediateFailedFuture(new Exception("Failed to take picture: pipeline is not ready."));
        });
    }

    @Override
    @Nullable
    public UseCaseConfig<?> getDefaultConfig(boolean applyDefaultConfig, @NonNull UseCaseConfigFactory factory) {
        Config captureConfig = factory.getConfig(this.mDefaultConfig.getCaptureType(), 1);
        if (applyDefaultConfig) {
            captureConfig = Config.mergeConfigs(captureConfig, this.mDefaultConfig.getConfig());
        }
        return captureConfig == null ? null : (UseCaseConfig<?>)this.getUseCaseConfigBuilder(captureConfig).getUseCaseConfig();
    }

    @Override
    @NonNull
    public UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config config) {
        return new StreamSharingBuilder(MutableOptionsBundle.from(config));
    }

    @Override
    @NonNull
    protected UseCaseConfig<?> onMergeConfig(@NonNull CameraInfoInternal cameraInfo, @NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        this.mVirtualCameraAdapter.mergeChildrenConfigs(builder.getMutableConfig());
        return builder.getUseCaseConfig();
    }

    @Override
    @NonNull
    protected StreamSpec onSuggestedStreamSpecUpdated(@NonNull StreamSpec primaryStreamSpec, @Nullable StreamSpec secondaryStreamSpec) {
        this.updateSessionConfig(this.createPipelineAndUpdateChildrenSpecs(this.getCameraId(), this.getSecondaryCameraId(), this.getCurrentConfig(), primaryStreamSpec, secondaryStreamSpec));
        this.notifyActive();
        return primaryStreamSpec;
    }

    @Override
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected StreamSpec onSuggestedStreamSpecImplementationOptionsUpdated(@NonNull Config config) {
        this.mSessionConfigBuilder.addImplementationOptions(config);
        this.updateSessionConfig(List.of(this.mSessionConfigBuilder.build()));
        return this.getAttachedStreamSpec().toBuilder().setImplementationOptions(config).build();
    }

    @Override
    public void onBind() {
        super.onBind();
        this.mVirtualCameraAdapter.bindChildren();
    }

    @Override
    public void onUnbind() {
        super.onUnbind();
        this.clearPipeline();
        this.mVirtualCameraAdapter.unbindChildren();
    }

    @Override
    public void onStateAttached() {
        super.onStateAttached();
        this.mVirtualCameraAdapter.notifyStateAttached();
    }

    @Override
    public void onStateDetached() {
        super.onStateDetached();
        this.mVirtualCameraAdapter.notifyStateDetached();
    }

    @NonNull
    public Set<UseCase> getChildren() {
        return this.mVirtualCameraAdapter.getChildren();
    }

    @Override
    @NonNull
    public Set<Integer> getSupportedEffectTargets() {
        HashSet<Integer> targets = new HashSet<Integer>();
        targets.add(3);
        return targets;
    }

    @NonNull
    @MainThread
    private List<SessionConfig> createPipelineAndUpdateChildrenSpecs(@NonNull String cameraId, @Nullable String secondaryCameraId, @NonNull UseCaseConfig<?> config, @NonNull StreamSpec primaryStreamSpec, @Nullable StreamSpec secondaryStreamSpec) {
        Threads.checkMainThread();
        if (secondaryStreamSpec == null) {
            this.createPrimaryCamera(cameraId, secondaryCameraId, config, primaryStreamSpec, null);
            this.mSharingNode = this.getSharingNode(Objects.requireNonNull(this.getCamera()), primaryStreamSpec);
            boolean isViewportSet = this.getViewPortCropRect() != null;
            Map<UseCase, OutConfig> outConfigMap = this.mVirtualCameraAdapter.getChildrenOutConfigs(this.mSharingInputEdge, this.getTargetRotationInternal(), isViewportSet);
            SurfaceProcessorNode.Out out = this.mSharingNode.transform(SurfaceProcessorNode.In.of(this.mSharingInputEdge, new ArrayList<OutConfig>(outConfigMap.values())));
            HashMap<UseCase, SurfaceEdge> outputEdges = new HashMap<UseCase, SurfaceEdge>();
            for (Map.Entry<UseCase, OutConfig> entry : outConfigMap.entrySet()) {
                outputEdges.put(entry.getKey(), (SurfaceEdge)out.get(entry.getValue()));
            }
            this.mVirtualCameraAdapter.setChildrenEdges(outputEdges);
            return List.of(this.mSessionConfigBuilder.build());
        }
        this.createPrimaryCamera(cameraId, secondaryCameraId, config, primaryStreamSpec, secondaryStreamSpec);
        this.createSecondaryCamera(cameraId, secondaryCameraId, config, primaryStreamSpec, secondaryStreamSpec);
        this.mDualSharingNode = this.getDualSharingNode(this.getCamera(), this.getSecondaryCamera(), primaryStreamSpec, this.mCompositionSettings, this.mSecondaryCompositionSettings);
        boolean isViewportSet = this.getViewPortCropRect() != null;
        Map<UseCase, DualOutConfig> outConfigMap = this.mVirtualCameraAdapter.getChildrenOutConfigs(this.mSharingInputEdge, this.mSecondarySharingInputEdge, this.getTargetRotationInternal(), isViewportSet);
        DualSurfaceProcessorNode.Out out = this.mDualSharingNode.transform(DualSurfaceProcessorNode.In.of(this.mSharingInputEdge, this.mSecondarySharingInputEdge, new ArrayList<DualOutConfig>(outConfigMap.values())));
        HashMap<UseCase, SurfaceEdge> outputEdges = new HashMap<UseCase, SurfaceEdge>();
        for (Map.Entry<UseCase, DualOutConfig> entry : outConfigMap.entrySet()) {
            outputEdges.put(entry.getKey(), (SurfaceEdge)out.get(entry.getValue()));
        }
        this.mVirtualCameraAdapter.setChildrenEdges(outputEdges);
        return List.of(this.mSessionConfigBuilder.build(), this.mSecondarySessionConfigBuilder.build());
    }

    private void createPrimaryCamera(@NonNull String cameraId, @Nullable String secondaryCameraId, @NonNull UseCaseConfig<?> config, @NonNull StreamSpec primaryStreamSpec, @Nullable StreamSpec secondaryStreamSpec) {
        this.mCameraEdge = new SurfaceEdge(3, 34, primaryStreamSpec, this.getSensorToBufferTransformMatrix(), Objects.requireNonNull(this.getCamera()).getHasTransform(), Objects.requireNonNull(this.getCropRect(primaryStreamSpec.getResolution())), this.getRelativeRotation(Objects.requireNonNull(this.getCamera())), -1, this.isMirroringRequired(Objects.requireNonNull(this.getCamera())));
        this.mSharingInputEdge = this.getSharingInputEdge(this.mCameraEdge, Objects.requireNonNull(this.getCamera()));
        this.mSessionConfigBuilder = this.createSessionConfigBuilder(this.mCameraEdge, config, primaryStreamSpec);
        this.addCameraErrorListener(this.mSessionConfigBuilder, cameraId, secondaryCameraId, config, primaryStreamSpec, secondaryStreamSpec);
    }

    private void createSecondaryCamera(@NonNull String cameraId, @Nullable String secondaryCameraId, @NonNull UseCaseConfig<?> config, @NonNull StreamSpec primaryStreamSpec, @Nullable StreamSpec secondaryStreamSpec) {
        this.mSecondaryCameraEdge = new SurfaceEdge(3, 34, secondaryStreamSpec, this.getSensorToBufferTransformMatrix(), Objects.requireNonNull(this.getSecondaryCamera()).getHasTransform(), Objects.requireNonNull(this.getCropRect(secondaryStreamSpec.getResolution())), this.getRelativeRotation(Objects.requireNonNull(this.getSecondaryCamera())), -1, this.isMirroringRequired(Objects.requireNonNull(this.getSecondaryCamera())));
        this.mSecondarySharingInputEdge = this.getSharingInputEdge(this.mSecondaryCameraEdge, Objects.requireNonNull(this.getSecondaryCamera()));
        this.mSecondarySessionConfigBuilder = this.createSessionConfigBuilder(this.mSecondaryCameraEdge, config, secondaryStreamSpec);
        this.addCameraErrorListener(this.mSecondarySessionConfigBuilder, cameraId, secondaryCameraId, config, primaryStreamSpec, secondaryStreamSpec);
    }

    @NonNull
    private SessionConfig.Builder createSessionConfigBuilder(@NonNull SurfaceEdge surfaceEdge, @NonNull UseCaseConfig<?> config, @NonNull StreamSpec streamSpec) {
        SessionConfig.Builder builder = SessionConfig.Builder.createFrom(config, streamSpec.getResolution());
        this.propagateChildrenTemplate(builder);
        this.propagateChildrenCamera2Interop(streamSpec.getResolution(), builder);
        DeferrableSurface deferrableSurface = surfaceEdge.getDeferrableSurface();
        builder.addSurface(deferrableSurface, streamSpec.getDynamicRange(), null, -1);
        builder.addRepeatingCameraCaptureCallback(this.mVirtualCameraAdapter.getParentMetadataCallback());
        if (streamSpec.getImplementationOptions() != null) {
            builder.addImplementationOptions(streamSpec.getImplementationOptions());
        }
        this.applyExpectedFrameRateRange(builder, streamSpec);
        return builder;
    }

    private void propagateChildrenTemplate(@NonNull SessionConfig.Builder builder) {
        int targetTemplate = -1;
        for (UseCase child : this.getChildren()) {
            targetTemplate = SessionConfig.getHigherPriorityTemplateType(targetTemplate, StreamSharing.getChildTemplate(child));
        }
        if (targetTemplate != -1) {
            builder.setTemplateType(targetTemplate);
        }
    }

    private static int getChildTemplate(@NonNull UseCase useCase) {
        return useCase.getCurrentConfig().getDefaultSessionConfig().getTemplateType();
    }

    private void propagateChildrenCamera2Interop(@NonNull Size resolution, @NonNull SessionConfig.Builder builder) {
        for (UseCase useCase : this.getChildren()) {
            SessionConfig childConfig = SessionConfig.Builder.createFrom(useCase.getCurrentConfig(), resolution).build();
            builder.addAllRepeatingCameraCaptureCallbacks(childConfig.getRepeatingCameraCaptureCallbacks());
            builder.addAllCameraCaptureCallbacks(childConfig.getSingleCameraCaptureCallbacks());
            builder.addAllSessionStateCallbacks(childConfig.getSessionStateCallbacks());
            builder.addAllDeviceStateCallbacks(childConfig.getDeviceStateCallbacks());
            builder.addImplementationOptions(childConfig.getImplementationOptions());
        }
    }

    @NonNull
    private SurfaceEdge getSharingInputEdge(@NonNull SurfaceEdge cameraEdge, @NonNull CameraInternal camera) {
        if (this.getEffect() == null) {
            return cameraEdge;
        }
        if (this.getEffect().getTransformation() == 2) {
            return cameraEdge;
        }
        if (this.getEffect().getOutputOption() == 1) {
            return cameraEdge;
        }
        this.mEffectNode = new SurfaceProcessorNode(camera, this.getEffect().createSurfaceProcessorInternal());
        int rotationAppliedByEffect = this.getRotationAppliedByEffect();
        Rect cropRectAppliedByEffect = this.getCropRectAppliedByEffect(cameraEdge);
        OutConfig outConfig = OutConfig.of(cameraEdge.getTargets(), cameraEdge.getFormat(), cropRectAppliedByEffect, TransformUtils.getRotatedSize(cropRectAppliedByEffect, rotationAppliedByEffect), rotationAppliedByEffect, this.getMirroringAppliedByEffect(), true);
        SurfaceProcessorNode.In in = SurfaceProcessorNode.In.of(cameraEdge, Collections.singletonList(outConfig));
        SurfaceProcessorNode.Out out = this.mEffectNode.transform(in);
        return Objects.requireNonNull((SurfaceEdge)out.get(outConfig));
    }

    @NonNull
    private SurfaceProcessorNode getSharingNode(@NonNull CameraInternal camera, @NonNull StreamSpec streamSpec) {
        if (this.getEffect() != null && this.getEffect().getOutputOption() == 1) {
            this.mEffectNode = new SurfaceProcessorNode(camera, this.getEffect().createSurfaceProcessorInternal());
            return this.mEffectNode;
        }
        return new SurfaceProcessorNode(camera, DefaultSurfaceProcessor.Factory.newInstance(streamSpec.getDynamicRange()));
    }

    @NonNull
    private DualSurfaceProcessorNode getDualSharingNode(@NonNull CameraInternal primaryCamera, @NonNull CameraInternal secondaryCamera, @NonNull StreamSpec streamSpec, @NonNull CompositionSettings primaryCompositionSettings, @NonNull CompositionSettings secondaryCompositionSettings) {
        return new DualSurfaceProcessorNode(primaryCamera, secondaryCamera, DualSurfaceProcessor.Factory.newInstance(streamSpec.getDynamicRange(), primaryCompositionSettings, secondaryCompositionSettings));
    }

    private int getRotationAppliedByEffect() {
        CameraEffect effect = (CameraEffect)Preconditions.checkNotNull((Object)this.getEffect());
        if (effect.getTransformation() == 1) {
            return this.getRelativeRotation((CameraInternal)Preconditions.checkNotNull((Object)this.getCamera()));
        }
        return 0;
    }

    private boolean getMirroringAppliedByEffect() {
        CameraEffect effect = (CameraEffect)Preconditions.checkNotNull((Object)this.getEffect());
        if (effect.getTransformation() == 1) {
            CameraInternal camera = (CameraInternal)Preconditions.checkNotNull((Object)this.getCamera());
            return camera.isFrontFacing() && camera.getHasTransform();
        }
        return false;
    }

    private Rect getCropRectAppliedByEffect(SurfaceEdge cameraEdge) {
        CameraEffect effect = (CameraEffect)Preconditions.checkNotNull((Object)this.getEffect());
        if (effect.getTransformation() == 1) {
            Size parentSize = cameraEdge.getStreamSpec().getResolution();
            return TransformUtils.sizeToRect(parentSize);
        }
        return cameraEdge.getCropRect();
    }

    private void addCameraErrorListener(@NonNull SessionConfig.Builder sessionConfigBuilder, @NonNull String cameraId, @Nullable String secondaryCameraId, @NonNull UseCaseConfig<?> config, @NonNull StreamSpec primaryStreamSpec, @Nullable StreamSpec secondaryStreamSpec) {
        if (this.mCloseableErrorListener != null) {
            this.mCloseableErrorListener.close();
        }
        this.mCloseableErrorListener = new SessionConfig.CloseableErrorListener((sessionConfig, error) -> {
            if (this.getCamera() == null) {
                return;
            }
            this.clearPipeline();
            this.updateSessionConfig(this.createPipelineAndUpdateChildrenSpecs(cameraId, secondaryCameraId, config, primaryStreamSpec, secondaryStreamSpec));
            this.notifyReset();
            this.mVirtualCameraAdapter.resetChildren();
        });
        sessionConfigBuilder.setErrorListener(this.mCloseableErrorListener);
    }

    private void clearPipeline() {
        if (this.mCloseableErrorListener != null) {
            this.mCloseableErrorListener.close();
            this.mCloseableErrorListener = null;
        }
        if (this.mCameraEdge != null) {
            this.mCameraEdge.close();
            this.mCameraEdge = null;
        }
        if (this.mSecondaryCameraEdge != null) {
            this.mSecondaryCameraEdge.close();
            this.mSecondaryCameraEdge = null;
        }
        if (this.mSharingInputEdge != null) {
            this.mSharingInputEdge.close();
            this.mSharingInputEdge = null;
        }
        if (this.mSecondarySharingInputEdge != null) {
            this.mSecondarySharingInputEdge.close();
            this.mSecondarySharingInputEdge = null;
        }
        if (this.mSharingNode != null) {
            this.mSharingNode.release();
            this.mSharingNode = null;
        }
        if (this.mDualSharingNode != null) {
            this.mDualSharingNode.release();
            this.mDualSharingNode = null;
        }
        if (this.mEffectNode != null) {
            this.mEffectNode.release();
            this.mEffectNode = null;
        }
    }

    @Nullable
    private Rect getCropRect(@NonNull Size surfaceResolution) {
        if (this.getViewPortCropRect() != null) {
            return this.getViewPortCropRect();
        }
        return new Rect(0, 0, surfaceResolution.getWidth(), surfaceResolution.getHeight());
    }

    @VisibleForTesting
    @Nullable
    SurfaceEdge getCameraEdge() {
        return this.mCameraEdge;
    }

    @VisibleForTesting
    @Nullable
    SurfaceProcessorNode getSharingNode() {
        return this.mSharingNode;
    }

    @VisibleForTesting
    @NonNull
    VirtualCameraAdapter getVirtualCameraAdapter() {
        return this.mVirtualCameraAdapter;
    }

    @NonNull
    public static List<UseCaseConfigFactory.CaptureType> getCaptureTypes(@NonNull UseCase useCase) {
        ArrayList<UseCaseConfigFactory.CaptureType> result = new ArrayList<UseCaseConfigFactory.CaptureType>();
        if (StreamSharing.isStreamSharing(useCase)) {
            for (UseCase child : ((StreamSharing)useCase).getChildren()) {
                result.add(child.getCurrentConfig().getCaptureType());
            }
        } else {
            result.add(useCase.getCurrentConfig().getCaptureType());
        }
        return result;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isStreamSharing(@Nullable UseCase useCase) {
        return useCase instanceof StreamSharing;
    }

    @VisibleForTesting
    @Nullable
    public SurfaceEdge getSharingInputEdge() {
        return this.mSharingInputEdge;
    }

    static interface Control {
        @NonNull
        public ListenableFuture<Void> jpegSnapshot(@IntRange(from=0L, to=100L) int var1, @IntRange(from=0L, to=359L) int var2);
    }
}

