/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.streamsharing;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.streamsharing.StreamSharing;
import androidx.camera.core.streamsharing.VirtualCameraControl;
import androidx.camera.core.streamsharing.VirtualCameraInfo;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;

class VirtualCamera
implements CameraInternal {
    private static final String UNSUPPORTED_MESSAGE = "Operation not supported by VirtualCamera.";
    @NonNull
    private final CameraInternal mParentCamera;
    @NonNull
    private final VirtualCameraControl mVirtualCameraControl;
    @NonNull
    private final VirtualCameraInfo mVirtualCameraInfo;
    private final UseCase.StateChangeCallback mStateChangeCallback;

    VirtualCamera(@NonNull CameraInternal parentCamera, @NonNull UseCase.StateChangeCallback useCaseStateCallback, @NonNull StreamSharing.Control streamSharingControl) {
        this.mParentCamera = parentCamera;
        this.mStateChangeCallback = useCaseStateCallback;
        this.mVirtualCameraControl = new VirtualCameraControl(parentCamera.getCameraControlInternal(), streamSharingControl);
        this.mVirtualCameraInfo = new VirtualCameraInfo(parentCamera.getCameraInfoInternal());
    }

    void setRotationDegrees(int sensorRotationDegrees) {
        this.mVirtualCameraInfo.setVirtualCameraRotationDegrees(sensorRotationDegrees);
    }

    @Override
    @MainThread
    public void onUseCaseActive(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        this.mStateChangeCallback.onUseCaseActive(useCase);
    }

    @Override
    @MainThread
    public void onUseCaseInactive(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        this.mStateChangeCallback.onUseCaseInactive(useCase);
    }

    @Override
    @MainThread
    public void onUseCaseUpdated(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        this.mStateChangeCallback.onUseCaseUpdated(useCase);
    }

    @Override
    @MainThread
    public void onUseCaseReset(@NonNull UseCase useCase) {
        Threads.checkMainThread();
        this.mStateChangeCallback.onUseCaseReset(useCase);
    }

    @Override
    public boolean getHasTransform() {
        return false;
    }

    @Override
    @NonNull
    public CameraControlInternal getCameraControlInternal() {
        return this.mVirtualCameraControl;
    }

    @Override
    @NonNull
    public CameraInfoInternal getCameraInfoInternal() {
        return this.mVirtualCameraInfo;
    }

    @Override
    @NonNull
    public Observable<CameraInternal.State> getCameraState() {
        return this.mParentCamera.getCameraState();
    }

    @Override
    public void open() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    @NonNull
    public ListenableFuture<Void> release() {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void attachUseCases(@NonNull Collection<UseCase> useCases) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }

    @Override
    public void detachUseCases(@NonNull Collection<UseCase> useCases) {
        throw new UnsupportedOperationException(UNSUPPORTED_MESSAGE);
    }
}

