/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.mlkit.vision;

import android.graphics.Matrix;
import android.media.Image;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.view.TransformExperimental;
import androidx.camera.view.transform.CoordinateTransform;
import androidx.camera.view.transform.ImageProxyTransformFactory;
import androidx.camera.view.transform.OutputTransform;
import androidx.core.util.Consumer;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.mlkit.vision.interfaces.Detector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
public class MlKitAnalyzer
implements ImageAnalysis.Analyzer {
    private static final String TAG = "MlKitAnalyzer";
    private static final Size DEFAULT_SIZE = new Size(480, 360);
    @NonNull
    private final List<Detector<?>> mDetectors;
    private final int mTargetCoordinateSystem;
    @NonNull
    final Consumer<Result> mConsumer;
    final ImageProxyTransformFactory mImageAnalysisTransformFactory;
    @NonNull
    private final Executor mExecutor;
    @Nullable
    private Matrix mSensorToTarget;

    @OptIn(markerClass={TransformExperimental.class})
    public MlKitAnalyzer(@NonNull List<Detector<?>> detectors, int targetCoordinateSystem, @NonNull Executor executor, @NonNull Consumer<Result> consumer) {
        if (targetCoordinateSystem != 0) {
            for (Detector<?> detector : detectors) {
                Preconditions.checkArgument((detector.getDetectorType() != 7 ? 1 : 0) != 0, (Object)"Segmentation only works with COORDINATE_SYSTEM_ORIGINAL");
            }
        }
        this.mDetectors = new ArrayList(detectors);
        this.mTargetCoordinateSystem = targetCoordinateSystem;
        this.mConsumer = consumer;
        this.mExecutor = executor;
        this.mImageAnalysisTransformFactory = new ImageProxyTransformFactory();
        this.mImageAnalysisTransformFactory.setUsingRotationDegrees(true);
    }

    @OptIn(markerClass={TransformExperimental.class})
    public final void analyze(@NonNull ImageProxy imageProxy) {
        Matrix transform = new Matrix();
        if (this.mTargetCoordinateSystem != 0) {
            Matrix sensorToTarget = this.mSensorToTarget;
            if (sensorToTarget == null) {
                Logger.d((String)TAG, (String)"Transform is null.");
                imageProxy.close();
                return;
            }
            OutputTransform analysisTransform = this.mImageAnalysisTransformFactory.getOutputTransform(imageProxy);
            Size cropRectSize = new Size(imageProxy.getCropRect().width(), imageProxy.getCropRect().height());
            CoordinateTransform coordinateTransform = new CoordinateTransform(analysisTransform, new OutputTransform(sensorToTarget, cropRectSize));
            coordinateTransform.transform(transform);
        }
        this.detectRecursively(imageProxy, 0, transform, new HashMap(), new HashMap());
    }

    @OptIn(markerClass={ExperimentalGetImage.class})
    private void detectRecursively(@NonNull ImageProxy imageProxy, int detectorIndex, @NonNull Matrix transform, Map<Detector<?>, Object> values, @NonNull Map<Detector<?>, Throwable> throwables) {
        Task mlKitTask;
        Image image = imageProxy.getImage();
        if (image == null) {
            Logger.e((String)TAG, (String)"Image is null.");
            imageProxy.close();
            return;
        }
        if (detectorIndex > this.mDetectors.size() - 1) {
            imageProxy.close();
            this.mExecutor.execute(() -> this.mConsumer.accept((Object)new Result(values, imageProxy.getImageInfo().getTimestamp(), throwables)));
            return;
        }
        Detector<?> detector = this.mDetectors.get(detectorIndex);
        int rotationDegrees = imageProxy.getImageInfo().getRotationDegrees();
        try {
            mlKitTask = detector.process(image, rotationDegrees, transform);
        }
        catch (Exception e) {
            throwables.put(detector, new RuntimeException("Failed to process the image.", e));
            this.detectRecursively(imageProxy, detectorIndex + 1, transform, values, throwables);
            return;
        }
        mlKitTask.addOnCompleteListener(this.mExecutor, task -> {
            if (task.isCanceled()) {
                throwables.put(detector, new CancellationException("The task is canceled."));
            } else if (task.isSuccessful()) {
                values.put(detector, task.getResult());
            } else {
                throwables.put(detector, task.getException());
            }
            this.detectRecursively(imageProxy, detectorIndex + 1, transform, values, throwables);
        });
    }

    @NonNull
    public final Size getDefaultTargetResolution() {
        Size size = DEFAULT_SIZE;
        for (Detector<?> detector : this.mDetectors) {
            Size detectorSize = this.getTargetResolution(detector.getDetectorType());
            if (detectorSize.getHeight() * detectorSize.getWidth() <= size.getWidth() * size.getHeight()) continue;
            size = detectorSize;
        }
        return size;
    }

    @NonNull
    private Size getTargetResolution(int detectorType) {
        switch (detectorType) {
            case 1: 
            case 4: {
                return new Size(1280, 720);
            }
        }
        return DEFAULT_SIZE;
    }

    public final int getTargetCoordinateSystem() {
        return this.mTargetCoordinateSystem;
    }

    public final void updateTransform(@Nullable Matrix matrix) {
        this.mSensorToTarget = matrix == null ? null : new Matrix(matrix);
    }

    public static final class Result {
        @NonNull
        private final Map<Detector<?>, Object> mValues;
        @NonNull
        private final Map<Detector<?>, Throwable> mThrowables;
        private final long mTimestamp;

        public Result(@NonNull Map<Detector<?>, Object> values, long timestamp, @NonNull Map<Detector<?>, Throwable> throwables) {
            this.mValues = values;
            this.mThrowables = throwables;
            this.mTimestamp = timestamp;
        }

        @Nullable
        public <T> T getValue(@NonNull Detector<T> detector) {
            this.checkDetectorExists(detector);
            return (T)this.mValues.get(detector);
        }

        @Nullable
        public Throwable getThrowable(@NonNull Detector<?> detector) {
            this.checkDetectorExists(detector);
            return this.mThrowables.get(detector);
        }

        public long getTimestamp() {
            return this.mTimestamp;
        }

        private void checkDetectorExists(@NonNull Detector<?> detector) {
            Preconditions.checkArgument((this.mValues.containsKey(detector) || this.mThrowables.containsKey(detector) ? 1 : 0) != 0, (Object)"The detector does not exist");
        }
    }
}

