/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.video.AutoValue_Quality_ConstantQuality;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@RequiresApi(value=21)
public class Quality {
    public static final Quality SD = ConstantQuality.of(4, "SD", Collections.unmodifiableList(Arrays.asList(new Size(720, 480), new Size(640, 480))));
    public static final Quality HD = ConstantQuality.of(5, "HD", Collections.singletonList(new Size(1280, 720)));
    public static final Quality FHD = ConstantQuality.of(6, "FHD", Collections.singletonList(new Size(1920, 1080)));
    public static final Quality UHD = ConstantQuality.of(8, "UHD", Collections.singletonList(new Size(3840, 2160)));
    public static final Quality LOWEST = ConstantQuality.of(0, "LOWEST", Collections.emptyList());
    public static final Quality HIGHEST = ConstantQuality.of(1, "HIGHEST", Collections.emptyList());
    static final Quality NONE = ConstantQuality.of(-1, "NONE", Collections.emptyList());
    private static final Set<Quality> QUALITIES = new HashSet<Quality>(Arrays.asList(LOWEST, HIGHEST, SD, HD, FHD, UHD));
    private static final List<Quality> QUALITIES_ORDER_BY_SIZE = Arrays.asList(UHD, FHD, HD, SD);

    private Quality() {
    }

    static boolean containsQuality(@NonNull Quality quality) {
        return QUALITIES.contains(quality);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public static List<Quality> getSortedQualities() {
        return new ArrayList<Quality>(QUALITIES_ORDER_BY_SIZE);
    }

    @RequiresApi(value=21)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @AutoValue
    public static abstract class ConstantQuality
    extends Quality {
        @NonNull
        static ConstantQuality of(int value, @NonNull String name, @NonNull List<Size> typicalSizes) {
            return new AutoValue_Quality_ConstantQuality(value, name, typicalSizes);
        }

        public abstract int getValue();

        @NonNull
        public abstract String getName();

        @NonNull
        public abstract List<Size> getTypicalSizes();
    }
}

