/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.core.impl.utils.CloseGuardHelper;
import androidx.camera.video.ExperimentalPersistentRecording;
import androidx.camera.video.OutputOptions;
import androidx.camera.video.PendingRecording;
import androidx.camera.video.Recorder;
import androidx.core.util.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;

@RequiresApi(value=21)
public final class Recording
implements AutoCloseable {
    private final AtomicBoolean mIsClosed = new AtomicBoolean(false);
    private final Recorder mRecorder;
    private final long mRecordingId;
    private final OutputOptions mOutputOptions;
    private final boolean mIsPersistent;
    private final CloseGuardHelper mCloseGuard = CloseGuardHelper.create();

    Recording(@NonNull Recorder recorder, long recordingId, @NonNull OutputOptions options, boolean isPersistent, boolean finalizedOnCreation) {
        this.mRecorder = recorder;
        this.mRecordingId = recordingId;
        this.mOutputOptions = options;
        this.mIsPersistent = isPersistent;
        if (finalizedOnCreation) {
            this.mIsClosed.set(true);
        } else {
            this.mCloseGuard.open("stop");
        }
    }

    @NonNull
    static Recording from(@NonNull PendingRecording pendingRecording, long recordingId) {
        Preconditions.checkNotNull((Object)pendingRecording, (Object)"The given PendingRecording cannot be null.");
        return new Recording(pendingRecording.getRecorder(), recordingId, pendingRecording.getOutputOptions(), pendingRecording.isPersistent(), false);
    }

    @NonNull
    static Recording createFinalizedFrom(@NonNull PendingRecording pendingRecording, long recordingId) {
        Preconditions.checkNotNull((Object)pendingRecording, (Object)"The given PendingRecording cannot be null.");
        return new Recording(pendingRecording.getRecorder(), recordingId, pendingRecording.getOutputOptions(), pendingRecording.isPersistent(), true);
    }

    @NonNull
    OutputOptions getOutputOptions() {
        return this.mOutputOptions;
    }

    @ExperimentalPersistentRecording
    public boolean isPersistent() {
        return this.mIsPersistent;
    }

    public void pause() {
        if (this.mIsClosed.get()) {
            throw new IllegalStateException("The recording has been stopped.");
        }
        this.mRecorder.pause(this);
    }

    public void resume() {
        if (this.mIsClosed.get()) {
            throw new IllegalStateException("The recording has been stopped.");
        }
        this.mRecorder.resume(this);
    }

    public void stop() {
        this.close();
    }

    public void mute(boolean muted) {
        if (this.mIsClosed.get()) {
            throw new IllegalStateException("The recording has been stopped.");
        }
        this.mRecorder.mute(this, muted);
    }

    @Override
    public void close() {
        this.stopWithError(0, null);
    }

    protected void finalize() throws Throwable {
        try {
            this.mCloseGuard.warnIfOpen();
            this.stopWithError(10, new RuntimeException("Recording stopped due to being garbage collected."));
        }
        finally {
            super.finalize();
        }
    }

    long getRecordingId() {
        return this.mRecordingId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isClosed() {
        return this.mIsClosed.get();
    }

    private void stopWithError(int error, @Nullable Throwable errorCause) {
        this.mCloseGuard.close();
        if (this.mIsClosed.getAndSet(true)) {
            return;
        }
        this.mRecorder.stop(this, error, errorCause);
    }
}

