/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.arch.core.util.Function;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.camera.video.CapabilitiesByQuality;
import androidx.camera.video.Quality;
import androidx.camera.video.internal.DynamicRangeMatchedEncoderProfilesProvider;
import androidx.camera.video.internal.VideoValidatedEncoderProfilesProxy;
import androidx.camera.video.internal.config.VideoConfigUtil;
import androidx.camera.video.internal.encoder.VideoEncoderConfig;
import androidx.camera.video.internal.encoder.VideoEncoderInfo;
import androidx.camera.video.internal.utils.DynamicRangeUtil;
import androidx.camera.video.internal.utils.EncoderProfilesUtil;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

@RequiresApi(value=21)
public class QualityExploredEncoderProfilesProvider
implements EncoderProfilesProvider {
    private final EncoderProfilesProvider mBaseEncoderProfilesProvider;
    private final Set<Quality> mTargetQualities;
    private final Set<Size> mCameraSupportedResolutions;
    private final Set<DynamicRange> mTargetDynamicRanges;
    private final Function<VideoEncoderConfig, VideoEncoderInfo> mVideoEncoderInfoFinder;
    private final Map<Integer, EncoderProfilesProxy> mEncoderProfilesCache = new HashMap<Integer, EncoderProfilesProxy>();
    private final Map<DynamicRange, CapabilitiesByQuality> mDynamicRangeToCapabilitiesMap = new HashMap<DynamicRange, CapabilitiesByQuality>();

    public QualityExploredEncoderProfilesProvider(@NonNull EncoderProfilesProvider baseProvider, @NonNull Collection<Quality> targetQualities, @NonNull Collection<DynamicRange> targetDynamicRanges, @NonNull Collection<Size> cameraSupportedResolutions, @NonNull Function<VideoEncoderConfig, VideoEncoderInfo> videoEncoderInfoFinder) {
        QualityExploredEncoderProfilesProvider.checkFullySpecifiedOrThrow(targetDynamicRanges);
        this.mBaseEncoderProfilesProvider = baseProvider;
        this.mTargetQualities = new HashSet<Quality>(targetQualities);
        this.mTargetDynamicRanges = new HashSet<DynamicRange>(targetDynamicRanges);
        this.mCameraSupportedResolutions = new HashSet<Size>(cameraSupportedResolutions);
        this.mVideoEncoderInfoFinder = videoEncoderInfoFinder;
    }

    public boolean hasProfile(int quality) {
        return this.getProfilesInternal(quality) != null;
    }

    @Nullable
    public EncoderProfilesProxy getAll(int quality) {
        return this.getProfilesInternal(quality);
    }

    @Nullable
    private EncoderProfilesProxy getProfilesInternal(int qualityValue) {
        if (this.mEncoderProfilesCache.containsKey(qualityValue)) {
            return this.mEncoderProfilesCache.get(qualityValue);
        }
        EncoderProfilesProxy profiles = this.mBaseEncoderProfilesProvider.getAll(qualityValue);
        Quality.ConstantQuality quality = this.findQualityInTargetQualities(qualityValue);
        if (quality != null && !this.hasMatchedVideoProfileForAllTargetDynamicRanges(profiles)) {
            profiles = QualityExploredEncoderProfilesProvider.mergeEncoderProfiles(profiles, this.exploreProfiles(quality));
        }
        this.mEncoderProfilesCache.put(qualityValue, profiles);
        return profiles;
    }

    private boolean hasMatchedVideoProfileForAllTargetDynamicRanges(@Nullable EncoderProfilesProxy encoderProfiles) {
        if (encoderProfiles == null) {
            return false;
        }
        for (DynamicRange dynamicRange : this.mTargetDynamicRanges) {
            if (QualityExploredEncoderProfilesProvider.hasMatchedVideoProfileForDynamicRange(encoderProfiles, dynamicRange)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private EncoderProfilesProxy exploreProfiles(@NonNull Quality.ConstantQuality quality) {
        Preconditions.checkArgument((boolean)this.mTargetQualities.contains(quality));
        EncoderProfilesProxy qualityMappedProfiles = this.mBaseEncoderProfilesProvider.getAll(quality.getValue());
        for (Size size : quality.getTypicalSizes()) {
            if (!this.mCameraSupportedResolutions.contains(size)) continue;
            TreeMap<Size, VideoValidatedEncoderProfilesProxy> areaSortedSizeToEncoderProfilesMap = new TreeMap<Size, VideoValidatedEncoderProfilesProxy>((Comparator<Size>)new CompareSizesByArea());
            ArrayList<EncoderProfilesProxy.VideoProfileProxy> generatedVideoProfiles = new ArrayList<EncoderProfilesProxy.VideoProfileProxy>();
            for (DynamicRange dynamicRange : this.mTargetDynamicRanges) {
                EncoderProfilesProxy.VideoProfileProxy baseVideoProfile;
                VideoEncoderConfig encoderConfig;
                VideoEncoderInfo encoderInfo;
                VideoValidatedEncoderProfilesProxy encoderProfiles;
                if (QualityExploredEncoderProfilesProvider.hasMatchedVideoProfileForDynamicRange(qualityMappedProfiles, dynamicRange) || (encoderProfiles = this.getCapabilitiesByQualityFor(dynamicRange).findNearestHigherSupportedEncoderProfilesFor(size)) == null || (encoderInfo = (VideoEncoderInfo)this.mVideoEncoderInfoFinder.apply((Object)(encoderConfig = VideoConfigUtil.toVideoEncoderConfig(baseVideoProfile = encoderProfiles.getDefaultVideoProfile())))) == null || !encoderInfo.isSizeSupportedAllowSwapping(size.getWidth(), size.getHeight())) continue;
                areaSortedSizeToEncoderProfilesMap.put(new Size(baseVideoProfile.getWidth(), baseVideoProfile.getHeight()), encoderProfiles);
                generatedVideoProfiles.add(EncoderProfilesUtil.deriveVideoProfile(baseVideoProfile, size, encoderInfo.getSupportedBitrateRange()));
            }
            if (generatedVideoProfiles.isEmpty()) continue;
            EncoderProfilesProxy baseProfiles = Objects.requireNonNull((EncoderProfilesProxy)SizeUtil.findNearestHigherFor((Size)size, areaSortedSizeToEncoderProfilesMap));
            return EncoderProfilesProxy.ImmutableEncoderProfilesProxy.create((int)baseProfiles.getDefaultDurationSeconds(), (int)baseProfiles.getRecommendedFileFormat(), (List)baseProfiles.getAudioProfiles(), generatedVideoProfiles);
        }
        return null;
    }

    @Nullable
    private Quality.ConstantQuality findQualityInTargetQualities(int qualityValue) {
        for (Quality quality : this.mTargetQualities) {
            Quality.ConstantQuality constantQuality = (Quality.ConstantQuality)quality;
            if (constantQuality.getValue() != qualityValue) continue;
            return constantQuality;
        }
        return null;
    }

    @NonNull
    private CapabilitiesByQuality getCapabilitiesByQualityFor(@NonNull DynamicRange dynamicRange) {
        if (this.mDynamicRangeToCapabilitiesMap.containsKey(dynamicRange)) {
            return Objects.requireNonNull(this.mDynamicRangeToCapabilitiesMap.get(dynamicRange));
        }
        DynamicRangeMatchedEncoderProfilesProvider constrainedProvider = new DynamicRangeMatchedEncoderProfilesProvider(this.mBaseEncoderProfilesProvider, dynamicRange);
        CapabilitiesByQuality capabilities = new CapabilitiesByQuality(constrainedProvider);
        this.mDynamicRangeToCapabilitiesMap.put(dynamicRange, capabilities);
        return capabilities;
    }

    @Nullable
    private static EncoderProfilesProxy mergeEncoderProfiles(@Nullable EncoderProfilesProxy baseProfiles, @Nullable EncoderProfilesProxy profilesToMerge) {
        if (baseProfiles == null && profilesToMerge == null) {
            return null;
        }
        int duration = baseProfiles != null ? baseProfiles.getDefaultDurationSeconds() : profilesToMerge.getDefaultDurationSeconds();
        int format = baseProfiles != null ? baseProfiles.getRecommendedFileFormat() : profilesToMerge.getRecommendedFileFormat();
        List audioProfiles = baseProfiles != null ? baseProfiles.getAudioProfiles() : profilesToMerge.getAudioProfiles();
        ArrayList videoProfiles = new ArrayList();
        if (baseProfiles != null) {
            videoProfiles.addAll(baseProfiles.getVideoProfiles());
        }
        if (profilesToMerge != null) {
            videoProfiles.addAll(profilesToMerge.getVideoProfiles());
        }
        return EncoderProfilesProxy.ImmutableEncoderProfilesProxy.create((int)duration, (int)format, (List)audioProfiles, videoProfiles);
    }

    private static boolean hasMatchedVideoProfileForDynamicRange(@Nullable EncoderProfilesProxy encoderProfiles, @NonNull DynamicRange dynamicRange) {
        if (encoderProfiles == null) {
            return false;
        }
        for (EncoderProfilesProxy.VideoProfileProxy videoProfile : encoderProfiles.getVideoProfiles()) {
            if (!DynamicRangeUtil.isHdrSettingsMatched(videoProfile, dynamicRange)) continue;
            return true;
        }
        return false;
    }

    private static void checkFullySpecifiedOrThrow(@NonNull Collection<DynamicRange> dynamicRanges) {
        for (DynamicRange dynamicRange : dynamicRanges) {
            if (dynamicRange.isFullySpecified()) continue;
            throw new IllegalArgumentException("Contains non-fully specified DynamicRange: " + dynamicRange);
        }
    }
}

