/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.audio;

import androidx.annotation.IntRange;
import androidx.camera.video.internal.audio.AudioSettings;

final class AutoValue_AudioSettings
extends AudioSettings {
    private final int audioSource;
    private final int sampleRate;
    private final int channelCount;
    private final int audioFormat;

    private AutoValue_AudioSettings(int audioSource, int sampleRate, int channelCount, int audioFormat) {
        this.audioSource = audioSource;
        this.sampleRate = sampleRate;
        this.channelCount = channelCount;
        this.audioFormat = audioFormat;
    }

    @Override
    public int getAudioSource() {
        return this.audioSource;
    }

    @Override
    @IntRange(from=1L)
    public int getSampleRate() {
        return this.sampleRate;
    }

    @Override
    @IntRange(from=1L)
    public int getChannelCount() {
        return this.channelCount;
    }

    @Override
    public int getAudioFormat() {
        return this.audioFormat;
    }

    public String toString() {
        return "AudioSettings{audioSource=" + this.audioSource + ", sampleRate=" + this.sampleRate + ", channelCount=" + this.channelCount + ", audioFormat=" + this.audioFormat + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AudioSettings) {
            AudioSettings that = (AudioSettings)o;
            return this.audioSource == that.getAudioSource() && this.sampleRate == that.getSampleRate() && this.channelCount == that.getChannelCount() && this.audioFormat == that.getAudioFormat();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.audioSource;
        h$ *= 1000003;
        h$ ^= this.sampleRate;
        h$ *= 1000003;
        h$ ^= this.channelCount;
        h$ *= 1000003;
        return h$ ^= this.audioFormat;
    }

    @Override
    public AudioSettings.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AudioSettings.Builder {
        private Integer audioSource;
        private Integer sampleRate;
        private Integer channelCount;
        private Integer audioFormat;

        Builder() {
        }

        private Builder(AudioSettings source) {
            this.audioSource = source.getAudioSource();
            this.sampleRate = source.getSampleRate();
            this.channelCount = source.getChannelCount();
            this.audioFormat = source.getAudioFormat();
        }

        @Override
        public AudioSettings.Builder setAudioSource(int audioSource) {
            this.audioSource = audioSource;
            return this;
        }

        @Override
        public AudioSettings.Builder setSampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        @Override
        public AudioSettings.Builder setChannelCount(int channelCount) {
            this.channelCount = channelCount;
            return this;
        }

        @Override
        public AudioSettings.Builder setAudioFormat(int audioFormat) {
            this.audioFormat = audioFormat;
            return this;
        }

        @Override
        AudioSettings autoBuild() {
            String missing = "";
            if (this.audioSource == null) {
                missing = missing + " audioSource";
            }
            if (this.sampleRate == null) {
                missing = missing + " sampleRate";
            }
            if (this.channelCount == null) {
                missing = missing + " channelCount";
            }
            if (this.audioFormat == null) {
                missing = missing + " audioFormat";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AudioSettings(this.audioSource, this.sampleRate, this.channelCount, this.audioFormat);
        }
    }
}

