/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.compat.quirk;

import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.Quirk;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@RequiresApi(value=21)
public class AudioTimestampFramePositionIncorrectQuirk
implements Quirk {
    private static final List<String> AFFECTED_OPPO_MODELS = Arrays.asList("cph1920", "cph1923", "cph2015", "cph2083");

    static boolean load() {
        return AudioTimestampFramePositionIncorrectQuirk.isAffectedOppoDevices() || AudioTimestampFramePositionIncorrectQuirk.isLgK10() || AudioTimestampFramePositionIncorrectQuirk.isMotoC() || AudioTimestampFramePositionIncorrectQuirk.isRealmeC2() || AudioTimestampFramePositionIncorrectQuirk.isRedmi6A() || AudioTimestampFramePositionIncorrectQuirk.isVivo1820();
    }

    private static boolean isAffectedOppoDevices() {
        return "oppo".equalsIgnoreCase(Build.BRAND) && AFFECTED_OPPO_MODELS.contains(Build.MODEL.toLowerCase(Locale.ROOT));
    }

    private static boolean isLgK10() {
        return "lge".equalsIgnoreCase(Build.BRAND) && "lg-m250".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isMotoC() {
        return "motorola".equalsIgnoreCase(Build.BRAND) && "moto c".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isRealmeC2() {
        return "realme".equalsIgnoreCase(Build.BRAND) && "rmx1941".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isRedmi6A() {
        return "Xiaomi".equalsIgnoreCase(Build.BRAND) && "Redmi 6A".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isVivo1820() {
        return "vivo".equalsIgnoreCase(Build.BRAND) && "vivo 1820".equalsIgnoreCase(Build.MODEL);
    }
}

