/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.compat.quirk;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.video.Quality;
import androidx.camera.video.internal.compat.quirk.VideoQualityQuirk;

@RequiresApi(value=21)
public class VideoEncoderCrashQuirk
implements VideoQualityQuirk {
    static boolean load() {
        return VideoEncoderCrashQuirk.isPositivoTwist2Pro();
    }

    private static boolean isPositivoTwist2Pro() {
        return "positivo".equalsIgnoreCase(Build.BRAND) && "twist 2 pro".equalsIgnoreCase(Build.MODEL);
    }

    @Override
    public boolean isProblematicVideoQuality(@NonNull CameraInfoInternal cameraInfo, @NonNull Quality quality) {
        if (VideoEncoderCrashQuirk.isPositivoTwist2Pro()) {
            return cameraInfo.getLensFacing() == 0 && quality == Quality.SD;
        }
        return false;
    }

    @Override
    public boolean workaroundBySurfaceProcessing() {
        return false;
    }
}

