/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.encoder;

import android.media.MediaCodecInfo;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.video.internal.encoder.EncoderInfo;
import androidx.camera.video.internal.encoder.InvalidConfigException;
import java.util.Objects;

@RequiresApi(value=21)
public abstract class EncoderInfoImpl
implements EncoderInfo {
    private final MediaCodecInfo mMediaCodecInfo;
    protected final MediaCodecInfo.CodecCapabilities mCodecCapabilities;

    EncoderInfoImpl(@NonNull MediaCodecInfo codecInfo, @NonNull String mime) throws InvalidConfigException {
        this.mMediaCodecInfo = codecInfo;
        try {
            this.mCodecCapabilities = Objects.requireNonNull(codecInfo.getCapabilitiesForType(mime));
        }
        catch (RuntimeException e) {
            throw new InvalidConfigException("Unable to get CodecCapabilities for mime: " + mime, e);
        }
    }

    @Override
    @NonNull
    public String getName() {
        return this.mMediaCodecInfo.getName();
    }
}

