/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.workaround;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.Timebase;
import androidx.camera.video.internal.compat.quirk.CameraUseInconsistentTimebaseQuirk;
import androidx.camera.video.internal.encoder.TimeProvider;

@RequiresApi(value=21)
public class VideoTimebaseConverter {
    private static final String TAG = "VideoTimebaseConverter";
    private static final long UPTIME_REALTIME_DIFF_THRESHOLD_US = 3000000L;
    private final TimeProvider mTimeProvider;
    private final Timebase mInputTimebase;
    private final CameraUseInconsistentTimebaseQuirk mCameraUseInconsistentTimebaseQuirk;
    private long mUptimeToRealtimeOffsetUs = -1L;
    @Nullable
    private Timebase mResolvedInputTimebase;

    public VideoTimebaseConverter(@NonNull TimeProvider timeProvider, @NonNull Timebase inputTimebase, @Nullable CameraUseInconsistentTimebaseQuirk cameraUseInconsistentTimebaseQuirk) {
        this.mTimeProvider = timeProvider;
        this.mInputTimebase = inputTimebase;
        this.mCameraUseInconsistentTimebaseQuirk = cameraUseInconsistentTimebaseQuirk;
    }

    public long convertToUptimeUs(long timestampUs) {
        if (this.mResolvedInputTimebase == null) {
            this.mResolvedInputTimebase = this.resolveInputTimebase(timestampUs);
        }
        switch (this.mResolvedInputTimebase) {
            case REALTIME: {
                if (this.mUptimeToRealtimeOffsetUs == -1L) {
                    this.mUptimeToRealtimeOffsetUs = this.calculateUptimeToRealtimeOffsetUs();
                    Logger.d((String)TAG, (String)("mUptimeToRealtimeOffsetUs = " + this.mUptimeToRealtimeOffsetUs));
                }
                return timestampUs - this.mUptimeToRealtimeOffsetUs;
            }
            case UPTIME: {
                return timestampUs;
            }
        }
        throw new AssertionError((Object)("Unknown timebase: " + this.mResolvedInputTimebase));
    }

    @NonNull
    private Timebase resolveInputTimebase(long timestampUs) {
        Timebase resolvedTimebase;
        boolean isSystemTimeDiverged = false;
        if (this.mCameraUseInconsistentTimebaseQuirk != null) {
            Logger.w((String)TAG, (String)"CameraUseInconsistentTimebaseQuirk is enabled");
        } else if (this.exceedUptimeRealtimeDiffThreshold()) {
            isSystemTimeDiverged = true;
        } else {
            return this.mInputTimebase;
        }
        Timebase timebase = resolvedTimebase = this.isCloseToRealtime(timestampUs) ? Timebase.REALTIME : Timebase.UPTIME;
        if (isSystemTimeDiverged && resolvedTimebase != this.mInputTimebase) {
            String socModelInfo = "";
            if (Build.VERSION.SDK_INT >= 31) {
                socModelInfo = ", SOC: " + Build.SOC_MODEL;
            }
            Logger.e((String)TAG, (String)String.format("Detected camera timebase inconsistent. Please file an issue at https://issuetracker.google.com/issues/new?component=618491&template=1257717 with this error message [Manufacturer: %s, Model: %s, Hardware: %s, API Level: %d%s].\nCamera timebase is inconsistent. The timebase reported by the camera is %s, but the actual timebase contained in the frame is detected as %s.", Build.MANUFACTURER, Build.MODEL, Build.HARDWARE, Build.VERSION.SDK_INT, socModelInfo, this.mInputTimebase, resolvedTimebase));
        } else {
            Logger.d((String)TAG, (String)("Detect input timebase = " + resolvedTimebase));
        }
        return resolvedTimebase;
    }

    private boolean exceedUptimeRealtimeDiffThreshold() {
        long uptimeUs = this.mTimeProvider.uptimeUs();
        long realTimeUs = this.mTimeProvider.realtimeUs();
        return realTimeUs - uptimeUs > 3000000L;
    }

    private boolean isCloseToRealtime(long timeUs) {
        long uptimeUs = this.mTimeProvider.uptimeUs();
        long realtimeUs = this.mTimeProvider.realtimeUs();
        return Math.abs(timeUs - realtimeUs) < Math.abs(timeUs - uptimeUs);
    }

    private long calculateUptimeToRealtimeOffsetUs() {
        long bestGap = Long.MAX_VALUE;
        long measured = 0L;
        for (int i = 0; i < 3; ++i) {
            long uptime1 = this.mTimeProvider.uptimeUs();
            long realtime = this.mTimeProvider.realtimeUs();
            long uptime2 = this.mTimeProvider.uptimeUs();
            long gap = uptime2 - uptime1;
            if (i != 0 && gap >= bestGap) continue;
            bestGap = gap;
            measured = realtime - (uptime1 + uptime2 >> 1);
        }
        return Math.max(0L, measured);
    }
}

