/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.ColorRes;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.Logger;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.core.Preview;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.view.CameraController;
import androidx.camera.view.PreviewStreamStateObserver;
import androidx.camera.view.PreviewViewImplementation;
import androidx.camera.view.PreviewViewMeteringPointFactory;
import androidx.camera.view.R;
import androidx.camera.view.SurfaceViewImplementation;
import androidx.camera.view.TextureViewImplementation;
import androidx.camera.view.preview.transform.PreviewTransform;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import java.util.concurrent.atomic.AtomicReference;

public class PreviewView
extends FrameLayout {
    private static final String TAG = "PreviewView";
    @ColorRes
    static final int DEFAULT_BACKGROUND_COLOR = 17170444;
    private static final ImplementationMode DEFAULT_IMPL_MODE = ImplementationMode.PERFORMANCE;
    @NonNull
    private ImplementationMode mImplementationMode = DEFAULT_IMPL_MODE;
    @VisibleForTesting
    @Nullable
    PreviewViewImplementation mImplementation;
    @NonNull
    PreviewTransform mPreviewTransform = new PreviewTransform();
    @NonNull
    private MutableLiveData<StreamState> mPreviewStreamStateLiveData = new MutableLiveData((Object)StreamState.IDLE);
    @Nullable
    private AtomicReference<PreviewStreamStateObserver> mActiveStreamStateObserver = new AtomicReference();
    CameraController mCameraController;
    @NonNull
    PreviewViewMeteringPointFactory mPreviewViewMeteringPointFactory = new PreviewViewMeteringPointFactory();
    private final View.OnLayoutChangeListener mOnLayoutChangeListener = new View.OnLayoutChangeListener(){

        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            boolean isSizeChanged;
            if (PreviewView.this.mImplementation != null) {
                PreviewView.this.mImplementation.redrawPreview();
            }
            PreviewView.this.mPreviewViewMeteringPointFactory.setViewSize(PreviewView.this.getWidth(), PreviewView.this.getHeight());
            boolean bl = isSizeChanged = right - left != oldRight - oldLeft || bottom - top != oldBottom - oldTop;
            if (PreviewView.this.mCameraController != null && isSizeChanged) {
                PreviewView.this.mCameraController.attachPreviewSurface(PreviewView.this.createSurfaceProvider(), PreviewView.this.getWidth(), PreviewView.this.getHeight());
            }
        }
    };

    public PreviewView(@NonNull Context context) {
        this(context, null);
    }

    public PreviewView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PreviewView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreviewView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PreviewView, defStyleAttr, defStyleRes);
        if (Build.VERSION.SDK_INT >= 29) {
            this.saveAttributeDataForStyleable(context, R.styleable.PreviewView, attrs, attributes, defStyleAttr, defStyleRes);
        }
        try {
            int scaleTypeId = attributes.getInteger(R.styleable.PreviewView_scaleType, this.mPreviewTransform.getScaleType().getId());
            this.setScaleType(ScaleType.fromId(scaleTypeId));
        }
        finally {
            attributes.recycle();
        }
        if (this.getBackground() == null) {
            this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)17170444));
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.addOnLayoutChangeListener(this.mOnLayoutChangeListener);
        if (this.mImplementation != null) {
            this.mImplementation.onAttachedToWindow();
        }
        this.mPreviewViewMeteringPointFactory.setDisplay(this.getDisplay());
        if (this.mCameraController != null) {
            this.mCameraController.attachPreviewSurface(this.createSurfaceProvider(), this.getWidth(), this.getHeight());
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeOnLayoutChangeListener(this.mOnLayoutChangeListener);
        if (this.mImplementation != null) {
            this.mImplementation.onDetachedFromWindow();
        }
        this.mPreviewViewMeteringPointFactory.setDisplay(this.getDisplay());
        if (this.mCameraController != null) {
            this.mCameraController.clearPreviewSurface();
        }
    }

    public void setImplementationMode(@NonNull ImplementationMode implementationMode) {
        this.mImplementationMode = implementationMode;
    }

    @NonNull
    public ImplementationMode getImplementationMode() {
        return this.mImplementationMode;
    }

    @NonNull
    @UiThread
    public Preview.SurfaceProvider createSurfaceProvider() {
        Threads.checkMainThread();
        return surfaceRequest -> {
            Logger.d((String)TAG, (String)"Surface requested by Preview.");
            CameraInternal camera = (CameraInternal)surfaceRequest.getCamera();
            this.mPreviewTransform.setSensorDimensionFlipNeeded(this.isSensorDimensionFlipNeeded(camera.getCameraInfo()));
            this.mImplementation = this.shouldUseTextureView(camera.getCameraInfo(), this.mImplementationMode) ? new TextureViewImplementation() : new SurfaceViewImplementation();
            this.mImplementation.init(this, this.mPreviewTransform);
            PreviewStreamStateObserver streamStateObserver = new PreviewStreamStateObserver((CameraInfoInternal)camera.getCameraInfo(), this.mPreviewStreamStateLiveData, this.mImplementation);
            this.mActiveStreamStateObserver.set(streamStateObserver);
            camera.getCameraState().addObserver(ContextCompat.getMainExecutor((Context)this.getContext()), (Observable.Observer)streamStateObserver);
            this.mPreviewViewMeteringPointFactory.setViewImplementationResolution(surfaceRequest.getResolution());
            this.mPreviewViewMeteringPointFactory.setCameraInfo(camera.getCameraInfo());
            this.mImplementation.onSurfaceRequested(surfaceRequest, () -> {
                if (this.mActiveStreamStateObserver.compareAndSet(streamStateObserver, null)) {
                    streamStateObserver.updatePreviewStreamState(StreamState.IDLE);
                }
                streamStateObserver.clear();
                camera.getCameraState().removeObserver((Observable.Observer)streamStateObserver);
            });
        };
    }

    public void setScaleType(@NonNull ScaleType scaleType) {
        this.mPreviewTransform.setScaleType(scaleType);
        this.mPreviewViewMeteringPointFactory.setScaleType(scaleType);
        if (this.mImplementation != null) {
            this.mImplementation.redrawPreview();
        }
    }

    public int getDeviceRotationForRemoteDisplayMode() {
        return this.mPreviewTransform.getDeviceRotation();
    }

    public void setDeviceRotationForRemoteDisplayMode(int deviceRotation) {
        if (deviceRotation == this.mPreviewTransform.getDeviceRotation() || !this.isRemoteDisplayMode()) {
            return;
        }
        this.mPreviewTransform.setDeviceRotation(deviceRotation);
        if (this.mImplementation != null) {
            this.mImplementation.redrawPreview();
        }
    }

    @NonNull
    public ScaleType getScaleType() {
        return this.mPreviewTransform.getScaleType();
    }

    @NonNull
    public MeteringPointFactory getMeteringPointFactory() {
        return this.mPreviewViewMeteringPointFactory;
    }

    @NonNull
    public LiveData<StreamState> getPreviewStreamState() {
        return this.mPreviewStreamStateLiveData;
    }

    @Nullable
    public Bitmap getBitmap() {
        return this.mImplementation == null ? null : this.mImplementation.getBitmap();
    }

    private boolean shouldUseTextureView(@NonNull CameraInfo cameraInfo, @NonNull ImplementationMode implementationMode) {
        if (Build.VERSION.SDK_INT <= 24 || cameraInfo.getImplementationType().equals("androidx.camera.camera2.legacy") || this.isRemoteDisplayMode()) {
            return true;
        }
        switch (implementationMode) {
            case COMPATIBLE: {
                return true;
            }
            case PERFORMANCE: {
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid implementation mode: " + (Object)((Object)implementationMode));
    }

    private boolean isSensorDimensionFlipNeeded(@NonNull CameraInfo cameraInfo) {
        int sensorDegrees = cameraInfo.getSensorRotationDegrees();
        return sensorDegrees % 180 == 90;
    }

    private boolean isRemoteDisplayMode() {
        DisplayManager displayManager = (DisplayManager)this.getContext().getSystemService("display");
        Display display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay();
        if (displayManager.getDisplays().length <= 1) {
            return false;
        }
        return display != null && display.getDisplayId() != 0;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @MainThread
    public void setController(@Nullable CameraController cameraController) {
        Threads.checkMainThread();
        if (this.mCameraController != null && this.mCameraController != cameraController) {
            this.mCameraController.clearPreviewSurface();
        }
        this.mCameraController = cameraController;
        if (this.mCameraController != null) {
            this.mCameraController.attachPreviewSurface(this.createSurfaceProvider(), this.getWidth(), this.getHeight());
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    @MainThread
    public CameraController getController() {
        Threads.checkMainThread();
        return this.mCameraController;
    }

    public static enum StreamState {
        IDLE,
        STREAMING;

    }

    public static enum ScaleType {
        FILL_START(0),
        FILL_CENTER(1),
        FILL_END(2),
        FIT_START(3),
        FIT_CENTER(4),
        FIT_END(5);

        private final int mId;

        private ScaleType(int id) {
            this.mId = id;
        }

        int getId() {
            return this.mId;
        }

        static ScaleType fromId(int id) {
            for (ScaleType scaleType : ScaleType.values()) {
                if (scaleType.mId != id) continue;
                return scaleType;
            }
            throw new IllegalArgumentException("Unknown scale type id " + id);
        }
    }

    public static enum ImplementationMode {
        PERFORMANCE,
        COMPATIBLE;

    }
}

