/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.util.Size;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.view.PreviewView;
import androidx.camera.view.preview.transform.PreviewTransform;
import androidx.camera.view.preview.transform.transformation.Transformation;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;

abstract class PreviewViewImplementation {
    @Nullable
    Size mResolution;
    @Nullable
    FrameLayout mParent;
    @Nullable
    private PreviewTransform mPreviewTransform;

    PreviewViewImplementation() {
    }

    abstract void initializePreview();

    @Nullable
    abstract View getPreview();

    abstract void onSurfaceRequested(@NonNull SurfaceRequest var1, @Nullable OnSurfaceNotInUseListener var2);

    void init(@NonNull FrameLayout parent, @NonNull PreviewTransform previewTransform) {
        this.mParent = parent;
        this.mPreviewTransform = previewTransform;
    }

    void redrawPreview() {
        this.applyCurrentScaleType();
    }

    void onSurfaceProvided() {
        this.applyCurrentScaleType();
    }

    private void applyCurrentScaleType() {
        View preview = this.getPreview();
        if (this.mPreviewTransform != null && this.mParent != null && preview != null && this.mResolution != null) {
            this.mPreviewTransform.applyCurrentScaleType((View)this.mParent, preview, this.mResolution);
        }
    }

    abstract void onAttachedToWindow();

    abstract void onDetachedFromWindow();

    @NonNull
    abstract ListenableFuture<Void> waitForNextFrame();

    @Nullable
    Bitmap getBitmap() {
        Bitmap bitmap = this.getPreviewBitmap();
        if (bitmap == null) {
            return bitmap;
        }
        Preconditions.checkNotNull((Object)this.mPreviewTransform);
        Transformation transformation = this.mPreviewTransform.getCurrentTransformation();
        if (transformation == null) {
            return bitmap;
        }
        Matrix scale = new Matrix();
        scale.setScale(transformation.getScaleX(), transformation.getScaleY());
        scale.postRotate(transformation.getRotation());
        Bitmap scaled = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)scale, (boolean)true);
        PreviewView.ScaleType scaleType = this.mPreviewTransform.getScaleType();
        Preconditions.checkNotNull((Object)this.mParent);
        int x = 0;
        int y = 0;
        switch (scaleType) {
            case FIT_START: 
            case FIT_CENTER: 
            case FIT_END: {
                return scaled;
            }
            case FILL_START: {
                x = 0;
                y = 0;
                break;
            }
            case FILL_CENTER: {
                x = (scaled.getWidth() - this.mParent.getWidth()) / 2;
                y = (scaled.getHeight() - this.mParent.getHeight()) / 2;
                break;
            }
            case FILL_END: {
                x = scaled.getWidth() - this.mParent.getWidth();
                y = scaled.getHeight() - this.mParent.getHeight();
            }
        }
        return Bitmap.createBitmap((Bitmap)scaled, (int)x, (int)y, (int)this.mParent.getWidth(), (int)this.mParent.getHeight());
    }

    @Nullable
    abstract Bitmap getPreviewBitmap();

    static interface OnSurfaceNotInUseListener {
        public void onSurfaceNotInUse();
    }
}

