/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.graphics.Point;
import android.graphics.PointF;
import android.util.Size;
import android.view.Display;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.DisplayOrientedMeteringPointFactory;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.view.PreviewView;

class PreviewViewMeteringPointFactory
extends MeteringPointFactory {
    @GuardedBy(value="mLock")
    private DisplayOrientedMeteringPointFactory mDisplayOrientedMeteringPointFactory;
    @GuardedBy(value="mLock")
    private float mViewWidth;
    @GuardedBy(value="mLock")
    private float mViewHeight;
    @GuardedBy(value="mLock")
    private float mFactoryWidth;
    @GuardedBy(value="mLock")
    private float mFactoryHeight;
    @Nullable
    @GuardedBy(value="mLock")
    private Size mResolution;
    @GuardedBy(value="mLock")
    private Display mDisplay;
    @GuardedBy(value="mLock")
    private CameraInfo mCameraInfo;
    @GuardedBy(value="mLock")
    private PreviewView.ScaleType mScaleType = PreviewView.ScaleType.FILL_CENTER;
    @GuardedBy(value="mLock")
    private boolean mIsValid;
    @GuardedBy(value="mLock")
    private boolean mIsCalculationStale = true;
    private final Object mLock = new Object();

    PreviewViewMeteringPointFactory() {
        this.mIsValid = false;
    }

    PreviewViewMeteringPointFactory(@Nullable Display display, @Nullable CameraInfo cameraInfo, @Nullable Size resolution, @Nullable PreviewView.ScaleType scaleType, int viewWidth, int viewHeight) {
        this.mDisplay = display;
        this.mCameraInfo = cameraInfo;
        this.mResolution = resolution;
        this.mScaleType = scaleType;
        this.mViewWidth = viewWidth;
        this.mViewHeight = viewHeight;
        this.recalculate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recalculate() {
        Object object = this.mLock;
        synchronized (object) {
            float scale;
            int bufferRotatedHeight;
            int bufferRotatedWidth;
            this.mIsCalculationStale = false;
            if (this.mResolution == null || this.mViewWidth <= 0.0f || this.mViewHeight <= 0.0f || this.mDisplay == null || this.mCameraInfo == null) {
                this.mIsValid = false;
                return;
            }
            this.mIsValid = true;
            boolean needReverse = false;
            if (this.isNaturalPortrait(this.mDisplay)) {
                if (this.mDisplay.getRotation() == 0 || this.mDisplay.getRotation() == 2) {
                    needReverse = true;
                }
            } else if (this.mDisplay.getRotation() == 1 || this.mDisplay.getRotation() == 3) {
                needReverse = true;
            }
            if (needReverse) {
                bufferRotatedWidth = this.mResolution.getHeight();
                bufferRotatedHeight = this.mResolution.getWidth();
            } else {
                bufferRotatedWidth = this.mResolution.getWidth();
                bufferRotatedHeight = this.mResolution.getHeight();
            }
            if (this.mScaleType == PreviewView.ScaleType.FILL_CENTER || this.mScaleType == PreviewView.ScaleType.FILL_START || this.mScaleType == PreviewView.ScaleType.FILL_END) {
                scale = Math.max(this.mViewWidth / (float)bufferRotatedWidth, this.mViewHeight / (float)bufferRotatedHeight);
            } else if (this.mScaleType == PreviewView.ScaleType.FIT_START || this.mScaleType == PreviewView.ScaleType.FIT_CENTER || this.mScaleType == PreviewView.ScaleType.FIT_END) {
                scale = Math.min(this.mViewWidth / (float)bufferRotatedWidth, this.mViewHeight / (float)bufferRotatedHeight);
            } else {
                throw new IllegalArgumentException("Unknown scale type " + (Object)((Object)this.mScaleType));
            }
            this.mFactoryWidth = (float)bufferRotatedWidth * scale;
            this.mFactoryHeight = (float)bufferRotatedHeight * scale;
            this.mDisplayOrientedMeteringPointFactory = new DisplayOrientedMeteringPointFactory(this.mDisplay, this.mCameraInfo, this.mFactoryWidth, this.mFactoryHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setScaleType(@Nullable PreviewView.ScaleType scaleType) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mScaleType == null || this.mScaleType != scaleType) {
                this.mScaleType = scaleType;
                this.mIsCalculationStale = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setViewSize(int viewWidth, int viewHeight) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mViewWidth != (float)viewWidth || this.mViewHeight != (float)viewHeight) {
                this.mViewWidth = viewWidth;
                this.mViewHeight = viewHeight;
                this.mIsCalculationStale = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setViewImplementationResolution(@Nullable Size resolution) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mResolution == null || !this.mResolution.equals((Object)resolution)) {
                this.mResolution = resolution;
                this.mIsCalculationStale = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDisplay(@Nullable Display display) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDisplay == null || this.mDisplay != display) {
                this.mDisplay = display;
                this.mIsCalculationStale = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCameraInfo(@Nullable CameraInfo cameraInfo) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCameraInfo == null || this.mCameraInfo != cameraInfo) {
                this.mCameraInfo = cameraInfo;
                this.mIsCalculationStale = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected PointF convertPoint(float x, float y) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsCalculationStale) {
                this.recalculate();
            }
            if (!this.mIsValid) {
                return new PointF(2.0f, 2.0f);
            }
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            if (this.mScaleType == PreviewView.ScaleType.FILL_START || this.mScaleType == PreviewView.ScaleType.FIT_START) {
                offsetX = 0.0f;
                offsetY = 0.0f;
            } else if (this.mScaleType == PreviewView.ScaleType.FILL_CENTER || this.mScaleType == PreviewView.ScaleType.FIT_CENTER) {
                offsetX = (this.mFactoryWidth - this.mViewWidth) / 2.0f;
                offsetY = (this.mFactoryHeight - this.mViewHeight) / 2.0f;
            } else if (this.mScaleType == PreviewView.ScaleType.FILL_END || this.mScaleType == PreviewView.ScaleType.FIT_END) {
                offsetX = this.mFactoryWidth - this.mViewWidth;
                offsetY = this.mFactoryHeight - this.mViewHeight;
            }
            float adjustedX = x + offsetX;
            float adjustedY = y + offsetY;
            MeteringPoint pt = this.mDisplayOrientedMeteringPointFactory.createPoint(adjustedX, adjustedY);
            return new PointF(pt.getX(), pt.getY());
        }
    }

    private boolean isNaturalPortrait(Display display) {
        Point deviceSize = new Point();
        display.getRealSize(deviceSize);
        int rotation = display.getRotation();
        int width = deviceSize.x;
        int height = deviceSize.y;
        return (rotation == 0 || rotation == 2) && width < height || (rotation == 1 || rotation == 3) && width >= height;
    }
}

