/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view.preview.transform;

import android.util.Pair;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.camera.view.preview.transform.RotationTransform;
import androidx.camera.view.preview.transform.transformation.TranslationTransformation;

final class TranslationTransform {
    private TranslationTransform() {
    }

    static TranslationTransformation start(@NonNull View view, @NonNull Pair<Float, Float> scaleXY, int deviceRotation) {
        int targetCenterY;
        int targetCenterX;
        boolean isPortrait;
        if (view.getWidth() == 0 || view.getHeight() == 0) {
            return new TranslationTransformation(0.0f, 0.0f);
        }
        int scaledWidth = (int)((float)view.getWidth() * ((Float)scaleXY.first).floatValue());
        int scaledHeight = (int)((float)view.getHeight() * ((Float)scaleXY.second).floatValue());
        int viewRotationDegrees = (int)RotationTransform.getRotationDegrees(view, deviceRotation);
        boolean bl = isPortrait = viewRotationDegrees == 0 || viewRotationDegrees == 180;
        if (isPortrait) {
            targetCenterX = scaledWidth / 2;
            targetCenterY = scaledHeight / 2;
        } else {
            targetCenterX = scaledHeight / 2;
            targetCenterY = scaledWidth / 2;
        }
        int currentCenterX = view.getWidth() / 2;
        int currentCenterY = view.getHeight() / 2;
        int transX = TranslationTransform.reverseIfRTLLayout(view, targetCenterX - currentCenterX);
        int transY = targetCenterY - currentCenterY;
        return new TranslationTransformation(transX, transY);
    }

    static TranslationTransformation center(@NonNull View container, @NonNull View view) {
        if (view.getWidth() == 0 || view.getHeight() == 0) {
            return new TranslationTransformation(0.0f, 0.0f);
        }
        int targetCenterX = container.getWidth() / 2;
        int targetCenterY = container.getHeight() / 2;
        int currentCenterX = view.getWidth() / 2;
        int currentCenterY = view.getHeight() / 2;
        int transX = TranslationTransform.reverseIfRTLLayout(view, targetCenterX - currentCenterX);
        int transY = targetCenterY - currentCenterY;
        return new TranslationTransformation(transX, transY);
    }

    static TranslationTransformation end(@NonNull View container, @NonNull View view, @NonNull Pair<Float, Float> scaleXY, int deviceRotation) {
        int targetCenterY;
        int targetCenterX;
        boolean isPortrait;
        if (view.getWidth() == 0 || view.getHeight() == 0) {
            return new TranslationTransformation(0.0f, 0.0f);
        }
        int endX = container.getWidth();
        int endY = container.getHeight();
        int scaledWidth = (int)((float)view.getWidth() * ((Float)scaleXY.first).floatValue());
        int scaledHeight = (int)((float)view.getHeight() * ((Float)scaleXY.second).floatValue());
        int viewRotationDegrees = (int)RotationTransform.getRotationDegrees(view, deviceRotation);
        boolean bl = isPortrait = viewRotationDegrees == 0 || viewRotationDegrees == 180;
        if (isPortrait) {
            targetCenterX = endX - scaledWidth / 2;
            targetCenterY = endY - scaledHeight / 2;
        } else {
            targetCenterX = endX - scaledHeight / 2;
            targetCenterY = endY - scaledWidth / 2;
        }
        int currentCenterX = view.getWidth() / 2;
        int currentCenterY = view.getHeight() / 2;
        int transX = TranslationTransform.reverseIfRTLLayout(view, targetCenterX - currentCenterX);
        int transY = targetCenterY - currentCenterY;
        return new TranslationTransformation(transX, transY);
    }

    private static int reverseIfRTLLayout(@NonNull View view, int transX) {
        boolean isRTLDirection = view.getLayoutDirection() == 1;
        return isRTLDirection ? -transX : transX;
    }
}

