/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.view.CameraController;
import androidx.camera.view.internal.ScreenFlashUiInfo;

@RequiresApi(value=21)
public final class ScreenFlashView
extends View {
    private static final String TAG = "ScreenFlashView";
    private CameraController mCameraController;
    private Window mScreenFlashWindow;
    private ImageCapture.ScreenFlash mScreenFlash;

    @UiThread
    public ScreenFlashView(@NonNull Context context) {
        this(context, null);
    }

    @UiThread
    public ScreenFlashView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    @UiThread
    public ScreenFlashView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    @UiThread
    public ScreenFlashView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setBackgroundColor(-1);
        this.setAlpha(0.0f);
        this.setElevation(Float.MAX_VALUE);
    }

    @UiThread
    public void setController(@Nullable CameraController cameraController) {
        Threads.checkMainThread();
        if (this.mCameraController != null && this.mCameraController != cameraController) {
            this.setScreenFlashUiInfo(null);
        }
        this.mCameraController = cameraController;
        if (cameraController == null) {
            return;
        }
        if (cameraController.getImageCaptureFlashMode() == 3 && this.mScreenFlashWindow == null) {
            throw new IllegalStateException("No window set despite setting FLASH_MODE_SCREEN in CameraController");
        }
        this.setScreenFlashUiInfo(this.getScreenFlash());
    }

    private void setScreenFlashUiInfo(ImageCapture.ScreenFlash control) {
        if (this.mCameraController == null) {
            Logger.d((String)TAG, (String)"setScreenFlashUiInfo: mCameraController is null!");
            return;
        }
        this.mCameraController.setScreenFlashUiInfo(new ScreenFlashUiInfo(ScreenFlashUiInfo.ProviderType.SCREEN_FLASH_VIEW, control));
    }

    @UiThread
    public void setScreenFlashWindow(@Nullable Window screenFlashWindow) {
        Threads.checkMainThread();
        this.updateScreenFlash(screenFlashWindow);
        this.mScreenFlashWindow = screenFlashWindow;
        this.setScreenFlashUiInfo(this.getScreenFlash());
    }

    private void updateScreenFlash(Window window) {
        if (this.mScreenFlashWindow != window) {
            this.mScreenFlash = window == null ? null : new ImageCapture.ScreenFlash(){
                private float mPreviousBrightness;

                public void apply(long expirationTimeMillis, @NonNull ImageCapture.ScreenFlashListener screenFlashListener) {
                    Logger.d((String)ScreenFlashView.TAG, (String)"ScreenFlash#apply");
                    ScreenFlashView.this.setAlpha(1.0f);
                    WindowManager.LayoutParams layoutParam = ScreenFlashView.this.mScreenFlashWindow.getAttributes();
                    this.mPreviousBrightness = layoutParam.screenBrightness;
                    layoutParam.screenBrightness = 1.0f;
                    ScreenFlashView.this.mScreenFlashWindow.setAttributes(layoutParam);
                    screenFlashListener.onCompleted();
                }

                public void clear() {
                    Logger.d((String)ScreenFlashView.TAG, (String)"ScreenFlash#clearScreenFlashUi");
                    ScreenFlashView.this.setAlpha(0.0f);
                    WindowManager.LayoutParams layoutParam = ScreenFlashView.this.mScreenFlashWindow.getAttributes();
                    layoutParam.screenBrightness = this.mPreviousBrightness;
                    ScreenFlashView.this.mScreenFlashWindow.setAttributes(layoutParam);
                }
            };
        }
    }

    @UiThread
    @Nullable
    public ImageCapture.ScreenFlash getScreenFlash() {
        return this.mScreenFlash;
    }
}

