/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view.transform;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.view.TransformExperimental;
import androidx.camera.view.transform.OutputTransform;
import androidx.core.util.Preconditions;

@RequiresApi(value=21)
@TransformExperimental
public final class CoordinateTransform {
    private static final String TAG = "CoordinateTransform";
    private static final String MISMATCH_MSG = "The source viewport (%s) does not match the target viewport (%s). Please make sure they are associated with the same Viewport.";
    private final Matrix mMatrix;

    public CoordinateTransform(@NonNull OutputTransform source, @NonNull OutputTransform target) {
        if (!TransformUtils.isAspectRatioMatchingWithRoundingError((Size)source.getViewPortSize(), (Size)target.getViewPortSize())) {
            Logger.w((String)TAG, (String)String.format(MISMATCH_MSG, source.getViewPortSize(), target.getViewPortSize()));
        }
        this.mMatrix = new Matrix();
        Preconditions.checkState((boolean)source.getMatrix().invert(this.mMatrix), (String)"The source transform cannot be inverted");
        this.mMatrix.postConcat(target.getMatrix());
    }

    public void transform(@NonNull Matrix outMatrix) {
        outMatrix.set(this.mMatrix);
    }

    public void mapPoints(@NonNull float[] points) {
        this.mMatrix.mapPoints(points);
    }

    public void mapPoint(@NonNull PointF point) {
        float[] pointArray = new float[]{point.x, point.y};
        this.mMatrix.mapPoints(pointArray);
        point.x = pointArray[0];
        point.y = pointArray[1];
    }

    public void mapRect(@NonNull RectF rect) {
        this.mMatrix.mapRect(rect);
    }
}

