/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.impl.utils;

import android.os.Build;
import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001e\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/camera/impl/utils/Logger;", "", "()V", "DEFAULT_MIN_LOG_LEVEL", "", "MAX_TAG_LENGTH", "minLogLevel", "d", "", "tag", "", "message", "throwable", "", "e", "i", "isDebugEnabled", "", "isErrorEnabled", "isInfoEnabled", "isLogLevelEnabled", "truncatedTag", "logLevel", "isWarnEnabled", "resetMinLogLevel", "truncateTag", "w", "camera-viewfinder-core_release"})
public final class Logger {
    @NotNull
    public static final Logger INSTANCE = new Logger();
    private static final int MAX_TAG_LENGTH = 23;
    private static final int DEFAULT_MIN_LOG_LEVEL = 3;
    private static int minLogLevel = 3;

    private Logger() {
    }

    private final boolean isLogLevelEnabled(String truncatedTag, int logLevel) {
        return minLogLevel <= logLevel || Log.isLoggable((String)truncatedTag, (int)logLevel);
    }

    public final void resetMinLogLevel() {
        minLogLevel = 3;
    }

    public final boolean isDebugEnabled(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return this.isLogLevelEnabled(this.truncateTag(tag), 3);
    }

    public final boolean isInfoEnabled(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return this.isLogLevelEnabled(this.truncateTag(tag), 4);
    }

    public final boolean isWarnEnabled(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return this.isLogLevelEnabled(this.truncateTag(tag), 5);
    }

    public final boolean isErrorEnabled(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return this.isLogLevelEnabled(this.truncateTag(tag), 6);
    }

    public final void d(@NotNull String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String truncatedTag = this.truncateTag(tag);
        if (this.isLogLevelEnabled(truncatedTag, 3)) {
            Log.d((String)truncatedTag, (String)message);
        }
    }

    public final void d(@NotNull String tag, @NotNull String message, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        String truncatedTag = this.truncateTag(tag);
        if (this.isLogLevelEnabled(truncatedTag, 3)) {
            Log.d((String)truncatedTag, (String)message, (Throwable)throwable);
        }
    }

    public final void i(@NotNull String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String truncatedTag = this.truncateTag(tag);
        if (this.isLogLevelEnabled(truncatedTag, 4)) {
            Log.i((String)truncatedTag, (String)message);
        }
    }

    public final void i(@NotNull String tag, @NotNull String message, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        String truncatedTag = this.truncateTag(tag);
        if (this.isLogLevelEnabled(truncatedTag, 4)) {
            Log.i((String)truncatedTag, (String)message, (Throwable)throwable);
        }
    }

    public final void w(@NotNull String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String truncatedTag = this.truncateTag(tag);
        if (this.isLogLevelEnabled(truncatedTag, 5)) {
            Log.w((String)truncatedTag, (String)message);
        }
    }

    public final void w(@NotNull String tag, @NotNull String message, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        String truncatedTag = this.truncateTag(tag);
        if (this.isLogLevelEnabled(truncatedTag, 5)) {
            Log.w((String)truncatedTag, (String)message, (Throwable)throwable);
        }
    }

    public final void e(@NotNull String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String truncatedTag = this.truncateTag(tag);
        if (this.isLogLevelEnabled(truncatedTag, 6)) {
            Log.e((String)truncatedTag, (String)message);
        }
    }

    public final void e(@NotNull String tag, @NotNull String message, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        String truncatedTag = this.truncateTag(tag);
        if (this.isLogLevelEnabled(truncatedTag, 6)) {
            Log.e((String)truncatedTag, (String)message, (Throwable)throwable);
        }
    }

    private final String truncateTag(String tag) {
        String string;
        if (Build.VERSION.SDK_INT < 24 && 23 < tag.length()) {
            String string2 = tag.substring(0, 23);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = tag;
        }
        return string;
    }
}

