/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.impl.utils.executor;

import android.os.Handler;
import android.os.SystemClock;
import androidx.camera.impl.utils.executor.ViewfinderExecutors;
import androidx.camera.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001!B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J$\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J2\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0015\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00192\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u001e\u001a\u00020\u000fH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110 H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/camera/impl/utils/executor/HandlerScheduledExecutorService;", "Ljava/util/concurrent/AbstractExecutorService;", "Ljava/util/concurrent/ScheduledExecutorService;", "handler", "Landroid/os/Handler;", "(Landroid/os/Handler;)V", "awaitTermination", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "createPostFailedException", "Ljava/util/concurrent/RejectedExecutionException;", "execute", "", "command", "Ljava/lang/Runnable;", "isShutdown", "isTerminated", "schedule", "Ljava/util/concurrent/ScheduledFuture;", "delay", "V", "callable", "Ljava/util/concurrent/Callable;", "scheduleAtFixedRate", "initialDelay", "period", "scheduleWithFixedDelay", "shutdown", "shutdownNow", "", "HandlerScheduledFuture", "camera-viewfinder-core_release"})
public final class HandlerScheduledExecutorService
extends AbstractExecutorService
implements ScheduledExecutorService {
    @NotNull
    private final Handler handler;

    public HandlerScheduledExecutorService(@NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
    }

    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Callable<Void> wrapper = () -> HandlerScheduledExecutorService.schedule$lambda$0(command);
        return this.schedule(wrapper, delay, unit);
    }

    @Override
    @NotNull
    public <V> ScheduledFuture<V> schedule(@NotNull Callable<V> callable, long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        long runAtMillis = SystemClock.uptimeMillis() + TimeUnit.MILLISECONDS.convert(delay, unit);
        HandlerScheduledFuture<V> future = new HandlerScheduledFuture<V>(this.handler, runAtMillis, callable);
        return this.handler.postAtTime((Runnable)future, runAtMillis) ? (ScheduledFuture)future : Futures.INSTANCE.immediateFailedScheduledFuture(this.createPostFailedException());
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command, long initialDelay, long period, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        throw new UnsupportedOperationException(HandlerScheduledExecutorService.class.getSimpleName() + " does not yet support fixed-rate scheduling.");
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command, long initialDelay, long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        throw new UnsupportedOperationException(HandlerScheduledExecutorService.class.getSimpleName() + " does not yet support fixed-delay scheduling.");
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException(HandlerScheduledExecutorService.class.getSimpleName() + " cannot be shut down. Use Looper.quitSafely().");
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException(HandlerScheduledExecutorService.class.getSimpleName() + " cannot be shut down. Use Looper.quitSafely().");
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        throw new UnsupportedOperationException(HandlerScheduledExecutorService.class.getSimpleName() + " cannot be shut down. Use Looper.quitSafely().");
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (!this.handler.post(command)) {
            throw this.createPostFailedException();
        }
    }

    private final RejectedExecutionException createPostFailedException() {
        return new RejectedExecutionException(this.handler + " is shutting down");
    }

    private static final Void schedule$lambda$0(Runnable $command) {
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        $command.run();
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0096\u0002J\r\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0096\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001f\u001a\u00020\u0012H\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u0012H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u001f\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Landroidx/camera/impl/utils/executor/HandlerScheduledExecutorService$HandlerScheduledFuture;", "V", "Ljava/util/concurrent/RunnableScheduledFuture;", "handler", "Landroid/os/Handler;", "mRunAtMillis", "", "mTask", "Ljava/util/concurrent/Callable;", "(Landroid/os/Handler;JLjava/util/concurrent/Callable;)V", "mCompleter", "Ljava/util/concurrent/atomic/AtomicReference;", "Landroidx/concurrent/futures/CallbackToFutureAdapter$Completer;", "getMCompleter", "()Ljava/util/concurrent/atomic/AtomicReference;", "mDelegate", "Lcom/google/common/util/concurrent/ListenableFuture;", "cancel", "", "mayInterruptIfRunning", "compareTo", "", "other", "Ljava/util/concurrent/Delayed;", "get", "()Ljava/lang/Object;", "timeout", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getDelay", "isCancelled", "isDone", "isPeriodic", "run", "", "camera-viewfinder-core_release"})
    private static final class HandlerScheduledFuture<V>
    implements RunnableScheduledFuture<V> {
        private final long mRunAtMillis;
        @NotNull
        private final Callable<V> mTask;
        @NotNull
        private final AtomicReference<CallbackToFutureAdapter.Completer<V>> mCompleter;
        @NotNull
        private final ListenableFuture<V> mDelegate;

        public HandlerScheduledFuture(@NotNull Handler handler, long mRunAtMillis, @NotNull Callable<V> mTask) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter(mTask, (String)"mTask");
            this.mRunAtMillis = mRunAtMillis;
            this.mTask = mTask;
            this.mCompleter = new AtomicReference<Object>(null);
            ListenableFuture listenableFuture = CallbackToFutureAdapter.getFuture(arg_0 -> HandlerScheduledFuture._init_$lambda$1(this, handler, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"getFuture { completer ->\u2026ure-$mTask\"\n            }");
            this.mDelegate = listenableFuture;
        }

        @NotNull
        public final AtomicReference<CallbackToFutureAdapter.Completer<V>> getMCompleter() {
            return this.mCompleter;
        }

        @Override
        public boolean isPeriodic() {
            return false;
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            return unit.convert(this.mRunAtMillis - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(@NotNull Delayed other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.compare((long)this.getDelay(TimeUnit.MILLISECONDS), (long)other.getDelay(TimeUnit.MILLISECONDS));
        }

        @Override
        public void run() {
            CallbackToFutureAdapter.Completer completer = this.mCompleter.getAndSet(null);
            if (completer != null) {
                try {
                    completer.set(this.mTask.call());
                }
                catch (Exception e) {
                    completer.setException((Throwable)e);
                }
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.mDelegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.mDelegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.mDelegate.isDone();
        }

        @Override
        public V get() throws ExecutionException, InterruptedException {
            return (V)this.mDelegate.get();
        }

        @Override
        public V get(long timeout, @NotNull TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            return (V)this.mDelegate.get(timeout, unit);
        }

        private static final void lambda$1$lambda$0(HandlerScheduledFuture this$0, Handler $handler) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
            if (this$0.mCompleter.getAndSet(null) != null) {
                $handler.removeCallbacks((Runnable)this$0);
            }
        }

        private static final Object _init_$lambda$1(HandlerScheduledFuture this$0, Handler $handler, CallbackToFutureAdapter.Completer completer) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
            Intrinsics.checkNotNullParameter((Object)completer, (String)"completer");
            completer.addCancellationListener(() -> HandlerScheduledFuture.lambda$1$lambda$0(this$0, $handler), ViewfinderExecutors.directExecutor());
            this$0.mCompleter.set(completer);
            return "HandlerScheduledFuture-" + this$0.mTask;
        }
    }
}

