/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.impl.utils.futures;

import androidx.camera.impl.utils.executor.ViewfinderExecutors;
import androidx.camera.impl.utils.futures.AsyncFunction;
import androidx.camera.impl.utils.futures.FutureChain;
import androidx.camera.impl.utils.futures.Futures;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u00032\u00020\u0004B-\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\u000f\u0010\u001b\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u001cJ \u0010\u001b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0096\u0002\u00a2\u0006\u0002\u0010!J)\u0010\"\u001a\u00020\u0017\"\u0004\b\u0002\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0\r2\u0006\u0010%\u001a\u0002H#H\u0002\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u0017H\u0016J!\u0010(\u001a\u0002H#\"\u0004\b\u0002\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0\rH\u0002\u00a2\u0006\u0002\u0010)R \u0010\n\u001a\u0014\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u0001\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\f\u0012\u0006\b\u0001\u0012\u00028\u0001\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006*"}, d2={"Landroidx/camera/impl/utils/futures/ChainingListenableFuture;", "I", "O", "Landroidx/camera/impl/utils/futures/FutureChain;", "Ljava/lang/Runnable;", "function", "Landroidx/camera/impl/utils/futures/AsyncFunction;", "inputFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "(Landroidx/camera/impl/utils/futures/AsyncFunction;Lcom/google/common/util/concurrent/ListenableFuture;)V", "mFunction", "mInputFuture", "mMayInterruptIfRunningChannel", "Ljava/util/concurrent/BlockingQueue;", "", "mOutputCreated", "Ljava/util/concurrent/CountDownLatch;", "mOutputFuture", "getMOutputFuture", "()Lcom/google/common/util/concurrent/ListenableFuture;", "setMOutputFuture", "(Lcom/google/common/util/concurrent/ListenableFuture;)V", "cancel", "", "future", "Ljava/util/concurrent/Future;", "mayInterruptIfRunning", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "putUninterruptibly", "E", "queue", "element", "(Ljava/util/concurrent/BlockingQueue;Ljava/lang/Object;)V", "run", "takeUninterruptibly", "(Ljava/util/concurrent/BlockingQueue;)Ljava/lang/Object;", "camera-viewfinder-core_release"})
@SourceDebugExtension(value={"SMAP\nChainingListenableFuture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChainingListenableFuture.kt\nandroidx/camera/impl/utils/futures/ChainingListenableFuture\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,285:1\n1#2:286\n*E\n"})
public final class ChainingListenableFuture<I, O>
extends FutureChain<O>
implements Runnable {
    @Nullable
    private AsyncFunction<? super I, ? extends O> mFunction;
    @NotNull
    private final BlockingQueue<Boolean> mMayInterruptIfRunningChannel;
    @NotNull
    private final CountDownLatch mOutputCreated;
    @Nullable
    private ListenableFuture<? extends I> mInputFuture;
    @Nullable
    private volatile ListenableFuture<? extends O> mOutputFuture;

    public ChainingListenableFuture(@NotNull AsyncFunction<? super I, ? extends O> function, @NotNull ListenableFuture<? extends I> inputFuture) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Intrinsics.checkNotNullParameter(inputFuture, (String)"inputFuture");
        this.mMayInterruptIfRunningChannel = new LinkedBlockingQueue(1);
        this.mOutputCreated = new CountDownLatch(1);
        this.mFunction = (AsyncFunction)Preconditions.checkNotNull(function);
        this.mInputFuture = (ListenableFuture)Preconditions.checkNotNull(inputFuture);
    }

    @Nullable
    public final ListenableFuture<? extends O> getMOutputFuture() {
        return this.mOutputFuture;
    }

    public final void setMOutputFuture(@Nullable ListenableFuture<? extends O> listenableFuture) {
        this.mOutputFuture = listenableFuture;
    }

    @Override
    @Nullable
    public O get() throws InterruptedException, ExecutionException {
        block2: {
            ListenableFuture<? extends O> outputFuture;
            ListenableFuture<? extends I> inputFuture;
            if (this.isDone()) break block2;
            ListenableFuture<? extends I> listenableFuture = inputFuture = this.mInputFuture;
            if (listenableFuture != null) {
                listenableFuture.get();
            }
            this.mOutputCreated.await();
            ListenableFuture<? extends O> listenableFuture2 = outputFuture = this.mOutputFuture;
            if (listenableFuture2 != null) {
                listenableFuture2.get();
            }
        }
        return (O)super.get();
    }

    @Override
    @Nullable
    public O get(long timeout, @NotNull TimeUnit unit) throws TimeoutException, ExecutionException, InterruptedException {
        TimeUnit resultUnit;
        long resultTimeout;
        block4: {
            ListenableFuture<? extends O> outputFuture;
            long start;
            ListenableFuture<? extends I> inputFuture;
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            resultTimeout = timeout;
            resultUnit = unit;
            if (this.isDone()) break block4;
            if (resultUnit != TimeUnit.NANOSECONDS) {
                resultTimeout = TimeUnit.NANOSECONDS.convert(resultTimeout, resultUnit);
                resultUnit = TimeUnit.NANOSECONDS;
            }
            if ((inputFuture = this.mInputFuture) != null) {
                start = System.nanoTime();
                inputFuture.get(resultTimeout, resultUnit);
                resultTimeout -= Math.max(0L, System.nanoTime() - start);
            }
            start = System.nanoTime();
            if (!this.mOutputCreated.await(resultTimeout, resultUnit)) {
                throw new TimeoutException();
            }
            resultTimeout -= Math.max(0L, System.nanoTime() - start);
            ListenableFuture<? extends O> listenableFuture = outputFuture = this.mOutputFuture;
            if (listenableFuture != null) {
                listenableFuture.get(resultTimeout, resultUnit);
            }
        }
        return (O)super.get(resultTimeout, resultUnit);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (super.cancel(mayInterruptIfRunning)) {
            this.putUninterruptibly(this.mMayInterruptIfRunningChannel, mayInterruptIfRunning);
            this.cancel((Future)this.mInputFuture, mayInterruptIfRunning);
            this.cancel((Future)this.mOutputFuture, mayInterruptIfRunning);
            return true;
        }
        return false;
    }

    private final void cancel(Future<?> future, boolean mayInterruptIfRunning) {
        block0: {
            Future<?> future2 = future;
            if (future2 == null) break block0;
            future2.cancel(mayInterruptIfRunning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block18: {
            try {
                Object v;
                try {
                    ListenableFuture<? extends I> listenableFuture = this.mInputFuture;
                    Intrinsics.checkNotNull(listenableFuture);
                    v = Futures.INSTANCE.getUninterruptibly((Future)listenableFuture);
                }
                catch (CancellationException e) {
                    this.cancel(false);
                    this.mFunction = null;
                    this.mInputFuture = null;
                    this.mOutputCreated.countDown();
                    return;
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable != null) {
                        Throwable it = throwable;
                        boolean bl = false;
                        this.setException(it);
                    }
                    this.mFunction = null;
                    this.mInputFuture = null;
                    this.mOutputCreated.countDown();
                    return;
                }
                Object sourceResult = v;
                AsyncFunction asyncFunction = this.mFunction;
                Intrinsics.checkNotNull(asyncFunction);
                ListenableFuture<? extends O> outputFuture = this.mOutputFuture = asyncFunction.apply(sourceResult);
                if (this.isCancelled()) {
                    ListenableFuture<? extends O> listenableFuture = outputFuture;
                    Intrinsics.checkNotNull(listenableFuture);
                    listenableFuture.cancel(this.takeUninterruptibly(this.mMayInterruptIfRunningChannel).booleanValue());
                    this.mOutputFuture = null;
                    return;
                }
                ListenableFuture<? extends O> listenableFuture = outputFuture;
                Intrinsics.checkNotNull(listenableFuture);
                listenableFuture.addListener(() -> ChainingListenableFuture.run$lambda$2(this, outputFuture), ViewfinderExecutors.directExecutor());
                break block18;
                {
                    catch (UndeclaredThrowableException e) {
                        Throwable throwable = e.getCause();
                        if (throwable != null) {
                            Throwable it = throwable;
                            boolean bl = false;
                            this.setException(it);
                        }
                        break block18;
                    }
                    catch (Exception e) {
                        this.setException(e);
                        break block18;
                    }
                    catch (Error e) {
                        this.setException(e);
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.mFunction = null;
                this.mInputFuture = null;
                this.mOutputCreated.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <E> E takeUninterruptibly(BlockingQueue<E> queue) {
        boolean interrupted = false;
        try {
            while (true) {
                E e;
                try {
                    e = queue.take();
                }
                catch (InterruptedException e2) {
                    interrupted = true;
                    continue;
                }
                return e;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <E> void putUninterruptibly(BlockingQueue<E> queue, E element) {
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    queue.put(element);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void run$lambda$2(ChainingListenableFuture this$0, ListenableFuture $outputFuture) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.set(Futures.INSTANCE.getUninterruptibly((Future)$outputFuture));
        }
        catch (CancellationException e) {
            this$0.cancel(false);
            return;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                this$0.setException(it);
            }
        }
        finally {
            this$0.mOutputFuture = null;
        }
    }
}

