/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.impl.utils.futures;

import androidx.arch.core.util.Function;
import androidx.camera.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 %*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001%B\u0015\b\u0010\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0010\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u000f\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J \u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\u0015\u0010\u001b\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 J4\u0010!\u001a\b\u0012\u0004\u0012\u0002H\"0\u0000\"\u0004\b\u0001\u0010\"2\u0018\u0010#\u001a\u0014\u0012\b\b\u0000\u0012\u0004\u0018\u00018\u0000\u0012\u0006\b\u0001\u0012\u0002H\"0$2\u0006\u0010\r\u001a\u00020\u000eR\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Landroidx/camera/impl/utils/futures/FutureChain;", "V", "Lcom/google/common/util/concurrent/ListenableFuture;", "delegate", "(Lcom/google/common/util/concurrent/ListenableFuture;)V", "()V", "mCompleter", "Landroidx/concurrent/futures/CallbackToFutureAdapter$Completer;", "mDelegate", "addListener", "", "listener", "Ljava/lang/Runnable;", "executor", "Ljava/util/concurrent/Executor;", "cancel", "", "mayInterruptIfRunning", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "isCancelled", "isDone", "set", "value", "(Ljava/lang/Object;)Z", "setException", "throwable", "", "transform", "T", "function", "Landroidx/arch/core/util/Function;", "Companion", "camera-viewfinder-core_release"})
public class FutureChain<V>
implements ListenableFuture<V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ListenableFuture<V> mDelegate;
    @Nullable
    private CallbackToFutureAdapter.Completer<V> mCompleter;

    @NotNull
    public final <T> FutureChain<T> transform(@NotNull Function<? super V, ? extends T> function, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        ListenableFuture<? extends T> listenableFuture = Futures.INSTANCE.transform(this, function, executor);
        Intrinsics.checkNotNull(listenableFuture, (String)"null cannot be cast to non-null type androidx.camera.impl.utils.futures.FutureChain<T of androidx.camera.impl.utils.futures.FutureChain.transform>");
        return (FutureChain)listenableFuture;
    }

    public FutureChain(@NotNull ListenableFuture<V> delegate) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        Object object = Preconditions.checkNotNull(delegate);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"checkNotNull(delegate)");
        this.mDelegate = (ListenableFuture)object;
    }

    public FutureChain() {
        ListenableFuture listenableFuture = CallbackToFutureAdapter.getFuture(arg_0 -> FutureChain._init_$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"getFuture { completer ->\u2026tureChain + \"]\"\n        }");
        this.mDelegate = listenableFuture;
    }

    public void addListener(@NotNull Runnable listener, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.mDelegate.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.mDelegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.mDelegate.isCancelled();
    }

    public boolean isDone() {
        return this.mDelegate.isDone();
    }

    @Nullable
    public V get() throws InterruptedException, ExecutionException {
        return (V)this.mDelegate.get();
    }

    @Nullable
    public V get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return (V)this.mDelegate.get(timeout, unit);
    }

    public final boolean set(@Nullable V value) {
        boolean bl;
        if (this.mCompleter != null) {
            CallbackToFutureAdapter.Completer<V> completer = this.mCompleter;
            Intrinsics.checkNotNull(completer);
            bl = completer.set(value);
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean setException(@NotNull Throwable throwable) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (this.mCompleter != null) {
            CallbackToFutureAdapter.Completer<V> completer = this.mCompleter;
            Intrinsics.checkNotNull(completer);
            bl = completer.setException(throwable);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final Object _init_$lambda$0(FutureChain this$0, CallbackToFutureAdapter.Completer completer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)completer, (String)"completer");
        Preconditions.checkState((this$0.mCompleter == null ? 1 : 0) != 0, (String)"The result can only set once!");
        this$0.mCompleter = completer;
        return "FutureChain[" + this$0 + ']';
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007\u00a8\u0006\b"}, d2={"Landroidx/camera/impl/utils/futures/FutureChain$Companion;", "", "()V", "from", "Landroidx/camera/impl/utils/futures/FutureChain;", "V", "future", "Lcom/google/common/util/concurrent/ListenableFuture;", "camera-viewfinder-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <V> FutureChain<V> from(@NotNull ListenableFuture<V> future) {
            Intrinsics.checkNotNullParameter(future, (String)"future");
            return future instanceof FutureChain ? (FutureChain)future : new FutureChain<V>(future);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

