/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.impl.utils.futures;

import androidx.camera.impl.utils.executor.ViewfinderExecutors;
import androidx.camera.impl.utils.futures.AsyncFunction;
import androidx.camera.impl.utils.futures.ChainingListenableFuture;
import androidx.camera.impl.utils.futures.FutureCallback;
import androidx.camera.impl.utils.futures.Futures;
import androidx.camera.impl.utils.futures.ImmediateFuture;
import androidx.camera.impl.utils.futures.ListFuture;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J2\u0010\f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0005\u0018\u00010\r0\u0007\"\u0004\b\u0000\u0010\u00052\u0014\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u00070\u000fJ!\u0010\u0010\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0011\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u0013\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0011\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0015\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0016\u001a\u00020\u0017J#\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007\"\u0004\b\u0000\u0010\u00052\b\u0010\u0019\u001a\u0004\u0018\u0001H\u0005H\u0002\u00a2\u0006\u0002\u0010\u001aJ\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007H\u0007J*\u0010\u001c\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00050\u001fH\u0007JP\u0010 \u001a\u00020\u0004\"\u0004\b\u0000\u0010!\"\u0004\b\u0001\u0010\"2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H!0\u00072\u0016\u0010#\u001a\u0012\u0012\u0006\b\u0000\u0012\u0002H!\u0012\u0006\b\u0001\u0012\u0002H\"0$2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\"0\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0002JX\u0010 \u001a\u00020\u0004\"\u0004\b\u0000\u0010!\"\u0004\b\u0001\u0010\"2\u0006\u0010%\u001a\u00020&2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H!0\u00072\u0016\u0010#\u001a\u0012\u0012\u0006\b\u0000\u0012\u0002H!\u0012\u0006\b\u0001\u0012\u0002H\"0$2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\"0\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J2\u0010'\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0005\u0018\u00010\r0\u0007\"\u0004\b\u0000\u0010\u00052\u0014\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00050\u00070\u000fJH\u0010(\u001a\b\u0012\u0004\u0012\u0002H\"0\u0007\"\u0004\b\u0000\u0010!\"\u0004\b\u0001\u0010\"2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H!0\u00072\u0018\u0010#\u001a\u0014\u0012\b\b\u0000\u0012\u0004\u0018\u0001H!\u0012\u0006\b\u0001\u0012\u0002H\"0$2\u0006\u0010\n\u001a\u00020\u000bJF\u0010)\u001a\b\u0012\u0004\u0012\u0002H\"0\u0007\"\u0004\b\u0000\u0010!\"\u0004\b\u0001\u0010\"2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H!0\u00072\u0016\u0010#\u001a\u0012\u0012\u0006\b\u0000\u0012\u0002H!\u0012\u0006\b\u0001\u0012\u0002H\"0*2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006,"}, d2={"Landroidx/camera/impl/utils/futures/Futures;", "", "()V", "addCallback", "", "V", "future", "Lcom/google/common/util/concurrent/ListenableFuture;", "callback", "Landroidx/camera/impl/utils/futures/FutureCallback;", "executor", "Ljava/util/concurrent/Executor;", "allAsList", "", "futures", "", "getDone", "Ljava/util/concurrent/Future;", "(Ljava/util/concurrent/Future;)Ljava/lang/Object;", "getUninterruptibly", "immediateFailedScheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "cause", "", "immediateFuture", "value", "(Ljava/lang/Object;)Lcom/google/common/util/concurrent/ListenableFuture;", "nonCancellationPropagating", "propagate", "input", "completer", "Landroidx/concurrent/futures/CallbackToFutureAdapter$Completer;", "propagateTransform", "I", "O", "function", "Landroidx/arch/core/util/Function;", "propagateCancellation", "", "successfulAsList", "transform", "transformAsync", "Landroidx/camera/impl/utils/futures/AsyncFunction;", "CallbackListener", "camera-viewfinder-core_release"})
public final class Futures {
    @NotNull
    public static final Futures INSTANCE = new Futures();

    private Futures() {
    }

    private final <V> ListenableFuture<V> immediateFuture(V value) {
        return value == null ? ImmediateFuture.Companion.nullFuture() : (ListenableFuture)new ImmediateFuture.ImmediateSuccessfulFuture<V>(value);
    }

    @NotNull
    public final <V> ScheduledFuture<V> immediateFailedScheduledFuture(@NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        return new ImmediateFuture.ImmediateFailedScheduledFuture(cause);
    }

    @NotNull
    public final <I, O> ListenableFuture<O> transformAsync(@NotNull ListenableFuture<I> input, @NotNull AsyncFunction<? super I, ? extends O> function, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        ChainingListenableFuture<? super I, ? extends O> output = new ChainingListenableFuture<I, O>(function, input);
        input.addListener((Runnable)output, executor);
        return output;
    }

    @NotNull
    public final <I, O> ListenableFuture<O> transform(@NotNull ListenableFuture<I> input, @NotNull androidx.arch.core.util.Function<? super I, ? extends O> function, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Preconditions.checkNotNull(function);
        Function1 function1 = new Function1<I, ListenableFuture<O>>(function){
            final /* synthetic */ androidx.arch.core.util.Function<? super I, ? extends O> $function;
            {
                this.$function = $function;
                super(1);
            }

            @NotNull
            public final ListenableFuture<O> invoke(@Nullable I it) {
                return Futures.access$immediateFuture(Futures.INSTANCE, this.$function.apply(it));
            }
        };
        return this.transformAsync(input, new AsyncFunction(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ ListenableFuture apply(Object input) {
                return (ListenableFuture)this.function.invoke(input);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof AsyncFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        }, executor);
    }

    @JvmStatic
    public static final <V> void propagate(@NotNull ListenableFuture<V> input, @NotNull CallbackToFutureAdapter.Completer<V> completer) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(completer, (String)"completer");
        INSTANCE.propagateTransform(input, arg_0 -> Futures.propagate$lambda$0(propagate.1.INSTANCE, arg_0), completer, ViewfinderExecutors.directExecutor());
    }

    private final <I, O> void propagateTransform(ListenableFuture<I> input, androidx.arch.core.util.Function<? super I, ? extends O> function, CallbackToFutureAdapter.Completer<O> completer, Executor executor) {
        this.propagateTransform(true, input, function, completer, executor);
    }

    private final <I, O> void propagateTransform(boolean propagateCancellation, ListenableFuture<I> input, androidx.arch.core.util.Function<? super I, ? extends O> function, CallbackToFutureAdapter.Completer<O> completer, Executor executor) {
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(function);
        Preconditions.checkNotNull(completer);
        Preconditions.checkNotNull((Object)executor);
        Futures.addCallback(input, new FutureCallback<I>(completer, function){
            final /* synthetic */ CallbackToFutureAdapter.Completer<O> $completer;
            final /* synthetic */ androidx.arch.core.util.Function<? super I, ? extends O> $function;
            {
                this.$completer = $completer;
                this.$function = $function;
            }

            public void onSuccess(@Nullable I result) {
                try {
                    this.$completer.set(this.$function.apply(result));
                }
                catch (Throwable t) {
                    this.$completer.setException(t);
                }
            }

            public void onFailure(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$completer.setException(t);
            }
        }, executor);
        if (propagateCancellation) {
            completer.addCancellationListener(() -> Futures.propagateTransform$lambda$1(input), ViewfinderExecutors.directExecutor());
        }
    }

    @JvmStatic
    @NotNull
    public static final <V> ListenableFuture<V> nonCancellationPropagating(@NotNull ListenableFuture<V> future) {
        ListenableFuture listenableFuture;
        Intrinsics.checkNotNullParameter(future, (String)"future");
        Preconditions.checkNotNull(future);
        if (future.isDone()) {
            listenableFuture = future;
        } else {
            ListenableFuture listenableFuture2 = CallbackToFutureAdapter.getFuture(arg_0 -> Futures.nonCancellationPropagating$lambda$3(future, arg_0));
            listenableFuture = listenableFuture2;
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture2, (String)"getFuture {\n            \u2026ating[$future]\"\n        }");
        }
        return listenableFuture;
    }

    @NotNull
    public final <V> ListenableFuture<List<V>> successfulAsList(@NotNull Collection<? extends ListenableFuture<? extends V>> futures) {
        Intrinsics.checkNotNullParameter(futures, (String)"futures");
        return new ListFuture(CollectionsKt.toList((Iterable)futures), false, ViewfinderExecutors.directExecutor());
    }

    @NotNull
    public final <V> ListenableFuture<List<V>> allAsList(@NotNull Collection<? extends ListenableFuture<? extends V>> futures) {
        Intrinsics.checkNotNullParameter(futures, (String)"futures");
        return new ListFuture(CollectionsKt.toList((Iterable)futures), true, ViewfinderExecutors.directExecutor());
    }

    @JvmStatic
    public static final <V> void addCallback(@NotNull ListenableFuture<V> future, @NotNull FutureCallback<? super V> callback, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter(future, (String)"future");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Preconditions.checkNotNull(callback);
        future.addListener((Runnable)new CallbackListener<V>((Future)future, callback), executor);
    }

    @Nullable
    public final <V> V getDone(@NotNull Future<V> future) throws ExecutionException {
        Intrinsics.checkNotNullParameter(future, (String)"future");
        Preconditions.checkState((boolean)future.isDone(), (String)("Future was expected to be done, " + future));
        return this.getUninterruptibly(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <V> V getUninterruptibly(@NotNull Future<V> future) throws ExecutionException {
        Intrinsics.checkNotNullParameter(future, (String)"future");
        boolean interrupted = false;
        try {
            while (true) {
                V v;
                try {
                    v = future.get();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                return v;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final Object propagate$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final void propagateTransform$lambda$1(ListenableFuture $input) {
        Intrinsics.checkNotNullParameter((Object)$input, (String)"$input");
        $input.cancel(true);
    }

    private static final Object nonCancellationPropagating$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final Object nonCancellationPropagating$lambda$3(ListenableFuture $future, CallbackToFutureAdapter.Completer it) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.propagateTransform(false, $future, arg_0 -> Futures.nonCancellationPropagating$lambda$3$lambda$2(nonCancellationPropagating.1.1.INSTANCE, arg_0), it, ViewfinderExecutors.directExecutor());
        return "nonCancellationPropagating[" + $future + ']';
    }

    public static final /* synthetic */ ListenableFuture access$immediateFuture(Futures $this, Object value) {
        return $this.immediateFuture(value);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0019\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Landroidx/camera/impl/utils/futures/Futures$CallbackListener;", "V", "Ljava/lang/Runnable;", "mFuture", "Ljava/util/concurrent/Future;", "callback", "Landroidx/camera/impl/utils/futures/FutureCallback;", "(Ljava/util/concurrent/Future;Landroidx/camera/impl/utils/futures/FutureCallback;)V", "mCallback", "getMCallback", "()Landroidx/camera/impl/utils/futures/FutureCallback;", "getMFuture", "()Ljava/util/concurrent/Future;", "run", "", "toString", "", "camera-viewfinder-core_release"})
    @SourceDebugExtension(value={"SMAP\nFutures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Futures.kt\nandroidx/camera/impl/utils/futures/Futures$CallbackListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,395:1\n1#2:396\n*E\n"})
    private static final class CallbackListener<V>
    implements Runnable {
        @NotNull
        private final Future<V> mFuture;
        @NotNull
        private final FutureCallback<? super V> mCallback;

        public CallbackListener(@NotNull Future<V> mFuture, @NotNull FutureCallback<? super V> callback) {
            Intrinsics.checkNotNullParameter(mFuture, (String)"mFuture");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.mFuture = mFuture;
            this.mCallback = callback;
        }

        @NotNull
        public final Future<V> getMFuture() {
            return this.mFuture;
        }

        @NotNull
        public final FutureCallback<? super V> getMCallback() {
            return this.mCallback;
        }

        @Override
        public void run() {
            Object value = null;
            try {
                value = INSTANCE.getDone(this.mFuture);
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    this.mCallback.onFailure(it);
                }
                return;
            }
            catch (RuntimeException e) {
                this.mCallback.onFailure(e);
                return;
            }
            catch (Error e) {
                this.mCallback.onFailure(e);
                return;
            }
            this.mCallback.onSuccess(value);
        }

        @NotNull
        public String toString() {
            return this.getClass().getSimpleName() + ',' + this.mCallback;
        }
    }
}

