/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.impl.utils.futures;

import androidx.camera.impl.utils.Logger;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b \u0018\u0000 \u0016*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0004\u0016\u0017\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u000f\u0010\r\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\u000eJ \u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016\u00a8\u0006\u001a"}, d2={"Landroidx/camera/impl/utils/futures/ImmediateFuture;", "V", "Lcom/google/common/util/concurrent/ListenableFuture;", "()V", "addListener", "", "listener", "Ljava/lang/Runnable;", "executor", "Ljava/util/concurrent/Executor;", "cancel", "", "mayInterruptIfRunning", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "isCancelled", "isDone", "Companion", "ImmediateFailedFuture", "ImmediateFailedScheduledFuture", "ImmediateSuccessfulFuture", "camera-viewfinder-core_release"})
public abstract class ImmediateFuture<V>
implements ListenableFuture<V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "ImmediateFuture";

    public void addListener(@NotNull Runnable listener, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Preconditions.checkNotNull((Object)listener);
        Preconditions.checkNotNull((Object)executor);
        try {
            executor.execute(listener);
        }
        catch (RuntimeException e) {
            Logger.INSTANCE.e(TAG, "Experienced RuntimeException while attempting to notify " + listener + " on Executor " + executor, e);
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return true;
    }

    @Nullable
    public abstract V get() throws ExecutionException;

    @Nullable
    public V get(long timeout, @NotNull TimeUnit unit) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Preconditions.checkNotNull((Object)((Object)unit));
        return this.get();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0001\u0010\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/camera/impl/utils/futures/ImmediateFuture$Companion;", "", "()V", "TAG", "", "nullFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "V", "camera-viewfinder-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <V> ListenableFuture<V> nullFuture() {
            return new ImmediateSuccessfulFuture<Object>(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0010\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u0006\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/camera/impl/utils/futures/ImmediateFuture$ImmediateFailedFuture;", "V", "Landroidx/camera/impl/utils/futures/ImmediateFuture;", "mCause", "", "(Ljava/lang/Throwable;)V", "get", "()Ljava/lang/Object;", "toString", "", "camera-viewfinder-core_release"})
    public static class ImmediateFailedFuture<V>
    extends ImmediateFuture<V> {
        @NotNull
        private final Throwable mCause;

        public ImmediateFailedFuture(@NotNull Throwable mCause) {
            Intrinsics.checkNotNullParameter((Object)mCause, (String)"mCause");
            this.mCause = mCause;
        }

        @Override
        @Nullable
        public V get() throws ExecutionException {
            throw new ExecutionException(this.mCause);
        }

        @NotNull
        public String toString() {
            return super.toString() + "[status=FAILURE, cause=[" + this.mCause + "]]";
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Landroidx/camera/impl/utils/futures/ImmediateFuture$ImmediateFailedScheduledFuture;", "V", "Landroidx/camera/impl/utils/futures/ImmediateFuture$ImmediateFailedFuture;", "Ljava/util/concurrent/ScheduledFuture;", "cause", "", "(Ljava/lang/Throwable;)V", "compareTo", "", "other", "Ljava/util/concurrent/Delayed;", "getDelay", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "camera-viewfinder-core_release"})
    public static final class ImmediateFailedScheduledFuture<V>
    extends ImmediateFailedFuture<V>
    implements ScheduledFuture<V> {
        public ImmediateFailedScheduledFuture(@NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super(cause);
        }

        @Override
        public long getDelay(@NotNull TimeUnit timeUnit) {
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            return 0L;
        }

        @Override
        public int compareTo(@NotNull Delayed other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return -1;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\u0006\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u0012\u0010\u0003\u001a\u0004\u0018\u00018\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\n"}, d2={"Landroidx/camera/impl/utils/futures/ImmediateFuture$ImmediateSuccessfulFuture;", "V", "Landroidx/camera/impl/utils/futures/ImmediateFuture;", "mValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "get", "()Ljava/lang/Object;", "toString", "", "camera-viewfinder-core_release"})
    public static final class ImmediateSuccessfulFuture<V>
    extends ImmediateFuture<V> {
        @Nullable
        private final V mValue;

        public ImmediateSuccessfulFuture(@Nullable V mValue) {
            this.mValue = mValue;
        }

        @Override
        @Nullable
        public V get() {
            return this.mValue;
        }

        @NotNull
        public String toString() {
            return super.toString() + "[status=SUCCESS, result=[" + this.mValue + "]]";
        }
    }
}

