/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.impl.utils.futures;

import androidx.camera.impl.utils.executor.ViewfinderExecutors;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0001\u0018\u00010\u00030\u0002B+\u0012\u0014\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\u0012\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0003H\u0016J#\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0096\u0002J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010$\u001a\u00020\u0006H\u0016J\b\u0010%\u001a\u00020\u0006H\u0016J \u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\u000e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000*H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0002\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u00030\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000e\u001a\u0014\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0003\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Landroidx/camera/impl/utils/futures/ListFuture;", "V", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "futures", "allMustSucceed", "", "listenerExecutor", "Ljava/util/concurrent/Executor;", "(Ljava/util/List;ZLjava/util/concurrent/Executor;)V", "futuresInternal", "remaining", "Ljava/util/concurrent/atomic/AtomicInteger;", "result", "resultNotifier", "Landroidx/concurrent/futures/CallbackToFutureAdapter$Completer;", "getResultNotifier", "()Landroidx/concurrent/futures/CallbackToFutureAdapter$Completer;", "setResultNotifier", "(Landroidx/concurrent/futures/CallbackToFutureAdapter$Completer;)V", "values", "", "addListener", "", "listener", "Ljava/lang/Runnable;", "executor", "callAllGets", "cancel", "mayInterruptIfRunning", "get", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "init", "isCancelled", "isDone", "setOneValue", "index", "", "future", "Ljava/util/concurrent/Future;", "camera-viewfinder-core_release"})
public final class ListFuture<V>
implements ListenableFuture<List<? extends V>> {
    @NotNull
    private List<? extends ListenableFuture<? extends V>> futures;
    private final boolean allMustSucceed;
    @Nullable
    private List<? extends ListenableFuture<? extends V>> futuresInternal;
    @Nullable
    private List<V> values;
    @NotNull
    private final AtomicInteger remaining;
    @NotNull
    private final ListenableFuture<List<V>> result;
    @Nullable
    private CallbackToFutureAdapter.Completer<List<V>> resultNotifier;

    public ListFuture(@NotNull List<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed, @NotNull Executor listenerExecutor) {
        Intrinsics.checkNotNullParameter(futures, (String)"futures");
        Intrinsics.checkNotNullParameter((Object)listenerExecutor, (String)"listenerExecutor");
        this.futures = futures;
        this.allMustSucceed = allMustSucceed;
        this.futuresInternal = this.futures;
        this.values = new ArrayList(this.futures.size());
        this.remaining = new AtomicInteger(this.futures.size());
        ListenableFuture listenableFuture = CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<List<? extends V>>(){

            @NotNull
            public Object attachCompleter(@NotNull CallbackToFutureAdapter.Completer<List<V>> completer) {
                Intrinsics.checkNotNullParameter(completer, (String)"completer");
                Preconditions.checkState((this.getResultNotifier() == null ? 1 : 0) != 0, (String)"The result can only set once!");
                this.setResultNotifier(completer);
                return "ListFuture[" + this + ']';
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"getFuture(\n            o\u2026         }\n            })");
        this.result = listenableFuture;
        this.init(listenerExecutor);
    }

    @Nullable
    public final CallbackToFutureAdapter.Completer<List<V>> getResultNotifier() {
        return this.resultNotifier;
    }

    public final void setResultNotifier(@Nullable CallbackToFutureAdapter.Completer<List<V>> completer) {
        this.resultNotifier = completer;
    }

    private final void init(Executor listenerExecutor) {
        this.addListener(() -> ListFuture.init$lambda$0(this), ViewfinderExecutors.directExecutor());
        List<ListenableFuture<V>> list = this.futuresInternal;
        Intrinsics.checkNotNull(list);
        if (list.isEmpty()) {
            CallbackToFutureAdapter.Completer<List<V>> completer = this.resultNotifier;
            Intrinsics.checkNotNull(completer);
            List<V> list2 = this.values;
            Intrinsics.checkNotNull(list2);
            completer.set(new ArrayList(list2));
            return;
        }
        List<ListenableFuture<V>> list3 = this.futuresInternal;
        Intrinsics.checkNotNull(list3);
        int n = list3.size();
        for (int i = 0; i < n; ++i) {
            List<V> list4 = this.values;
            Intrinsics.checkNotNull(list4);
            list4.add(null);
        }
        List<ListenableFuture<V>> localFutures = this.futuresInternal;
        List<ListenableFuture<V>> list5 = localFutures;
        Intrinsics.checkNotNull(list5);
        int n2 = list5.size();
        for (int i = 0; i < n2; ++i) {
            ListenableFuture<? extends V> listenable = localFutures.get(i);
            listenable.addListener(() -> ListFuture.init$lambda$1(this, i, listenable), listenerExecutor);
        }
    }

    /*
     * Exception decompiling
     */
    private final void setOneValue(int index, Future<? extends V> future) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addListener(@NotNull Runnable listener, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.result.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.futuresInternal != null) {
            List<ListenableFuture<V>> list = this.futuresInternal;
            Intrinsics.checkNotNull(list);
            for (ListenableFuture<? extends V> listenableFuture : list) {
                listenableFuture.cancel(mayInterruptIfRunning);
            }
        }
        return this.result.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.result.isCancelled();
    }

    public boolean isDone() {
        return this.result.isDone();
    }

    @Nullable
    public List<V> get() throws InterruptedException, ExecutionException {
        this.callAllGets();
        return (List)this.result.get();
    }

    @Nullable
    public List<V> get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return (List)this.result.get(timeout, unit);
    }

    private final void callAllGets() throws InterruptedException {
        List<ListenableFuture<V>> oldFutures = this.futuresInternal;
        if (oldFutures != null && !this.isDone()) {
            for (ListenableFuture<? extends V> listenableFuture : oldFutures) {
                while (!listenableFuture.isDone()) {
                    try {
                        listenableFuture.get();
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        if (!this.allMustSucceed) continue;
                        return;
                    }
                }
            }
        }
    }

    private static final void init$lambda$0(ListFuture this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.values = null;
        this$0.futuresInternal = null;
    }

    private static final void init$lambda$1(ListFuture this$0, int $i, ListenableFuture $listenable) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listenable, (String)"$listenable");
        this$0.setOneValue($i, (Future)$listenable);
    }
}

