/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.viewfinder.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 -2\u00020\u0001:\u0003-./B+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010(\u001a\u00020\fH\u0002J\b\u0010)\u001a\u00020\u0012H\u0002J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,H\u0007R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001c\"\u0004\b \u0010\u001eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u00060"}, d2={"Landroidx/camera/viewfinder/core/ZoomGestureDetector;", "", "context", "Landroid/content/Context;", "spanSlop", "", "minSpan", "listener", "Landroidx/camera/viewfinder/core/ZoomGestureDetector$OnZoomGestureListener;", "(Landroid/content/Context;IILandroidx/camera/viewfinder/core/ZoomGestureDetector$OnZoomGestureListener;)V", "anchoredZoomMode", "anchoredZoomStartX", "", "anchoredZoomStartY", "currentSpan", "currentSpanX", "currentSpanY", "eventBeforeOrAboveStartingGestureEvent", "", "eventTime", "", "focusX", "focusY", "gestureDetector", "Landroid/view/GestureDetector;", "initialSpan", "isInProgress", "isQuickZoomEnabled", "()Z", "setQuickZoomEnabled", "(Z)V", "isStylusZoomEnabled", "setStylusZoomEnabled", "prevTime", "previousSpan", "previousSpanX", "previousSpanY", "timeDelta", "getTimeDelta", "()J", "getScaleFactor", "inAnchoredZoomMode", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "Companion", "OnZoomGestureListener", "ZoomEvent", "camera-viewfinder-core_release"})
@RequiresApi(value=21)
public final class ZoomGestureDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private final int spanSlop;
    private final int minSpan;
    @NotNull
    private final OnZoomGestureListener listener;
    @Px
    private int focusX;
    @Px
    private int focusY;
    private boolean isQuickZoomEnabled;
    private boolean isStylusZoomEnabled;
    private float currentSpan;
    private float previousSpan;
    private float currentSpanX;
    private float currentSpanY;
    private float previousSpanX;
    private float previousSpanY;
    private long eventTime;
    private boolean isInProgress;
    private float initialSpan;
    private long prevTime;
    private float anchoredZoomStartX;
    private float anchoredZoomStartY;
    private int anchoredZoomMode;
    @NotNull
    private GestureDetector gestureDetector;
    private boolean eventBeforeOrAboveStartingGestureEvent;
    private static final int DEFAULT_MIN_SPAN = 0;
    private static final float SCALE_FACTOR = 0.5f;
    private static final int ANCHORED_ZOOM_MODE_NONE = 0;
    private static final int ANCHORED_ZOOM_MODE_DOUBLE_TAP = 1;
    private static final int ANCHORED_ZOOM_MODE_STYLUS = 2;

    @SuppressLint(value={"ExecutorRegistration"})
    @JvmOverloads
    public ZoomGestureDetector(@NotNull Context context, @Px int spanSlop, @Px int minSpan, @NotNull OnZoomGestureListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.context = context;
        this.spanSlop = spanSlop;
        this.minSpan = minSpan;
        this.listener = listener;
        this.isQuickZoomEnabled = true;
        this.isStylusZoomEnabled = true;
        this.gestureDetector = new GestureDetector(this.context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(this){
            final /* synthetic */ ZoomGestureDetector this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onDoubleTap(@NotNull MotionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ZoomGestureDetector.access$setAnchoredZoomStartX$p(this.this$0, e.getX());
                ZoomGestureDetector.access$setAnchoredZoomStartY$p(this.this$0, e.getY());
                ZoomGestureDetector.access$setAnchoredZoomMode$p(this.this$0, 1);
                return true;
            }
        });
    }

    public /* synthetic */ ZoomGestureDetector(Context context, int n, int n2, OnZoomGestureListener onZoomGestureListener, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = ViewConfiguration.get((Context)context).getScaledTouchSlop() * 2;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(context, n, n2, onZoomGestureListener);
    }

    public final boolean isQuickZoomEnabled() {
        return this.isQuickZoomEnabled;
    }

    public final void setQuickZoomEnabled(boolean bl) {
        this.isQuickZoomEnabled = bl;
    }

    public final boolean isStylusZoomEnabled() {
        return this.isStylusZoomEnabled;
    }

    public final void setStylusZoomEnabled(boolean bl) {
        this.isStylusZoomEnabled = bl;
    }

    @UiThread
    public final boolean onTouchEvent(@NotNull MotionEvent event) {
        int minSpan;
        boolean streamComplete;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.eventTime = event.getEventTime();
        int action = event.getActionMasked();
        if (this.isQuickZoomEnabled) {
            this.gestureDetector.onTouchEvent(event);
        }
        int count = event.getPointerCount();
        boolean isStylusButtonDown = (event.getButtonState() & 0x20) != 0;
        boolean anchoredZoomCancelled = this.anchoredZoomMode == 2 && !isStylusButtonDown;
        boolean bl = streamComplete = action == 1 || action == 3 || anchoredZoomCancelled;
        if (action == 0 || streamComplete) {
            if (this.isInProgress) {
                this.listener.onZoomEvent(new ZoomEvent.End(this.eventTime, this.focusX, this.focusY, this.getScaleFactor()));
                this.isInProgress = false;
                this.initialSpan = 0.0f;
                this.anchoredZoomMode = 0;
            } else if (this.inAnchoredZoomMode() && streamComplete) {
                this.isInProgress = false;
                this.initialSpan = 0.0f;
                this.anchoredZoomMode = 0;
            }
            if (streamComplete) {
                return true;
            }
        }
        if (!this.isInProgress && this.isStylusZoomEnabled && !this.inAnchoredZoomMode() && !streamComplete && isStylusButtonDown) {
            this.anchoredZoomStartX = event.getX();
            this.anchoredZoomStartY = event.getY();
            this.anchoredZoomMode = 2;
            this.initialSpan = 0.0f;
        }
        boolean configChanged = action == 0 || action == 6 || action == 5 || anchoredZoomCancelled;
        boolean pointerUp = action == 6;
        int skipIndex = pointerUp ? event.getActionIndex() : -1;
        float sumX = 0.0f;
        float sumY = 0.0f;
        int div = pointerUp ? count - 1 : count;
        float focusXFloat = 0.0f;
        float focusYFloat = 0.0f;
        if (this.inAnchoredZoomMode()) {
            focusXFloat = this.anchoredZoomStartX;
            focusYFloat = this.anchoredZoomStartY;
            this.eventBeforeOrAboveStartingGestureEvent = event.getY() < focusYFloat;
        } else {
            for (int i = 0; i < count; ++i) {
                if (skipIndex == i) continue;
                sumX += event.getX(i);
                sumY += event.getY(i);
            }
            focusXFloat = sumX / (float)div;
            focusYFloat = sumY / (float)div;
        }
        float devSumX = 0.0f;
        float devSumY = 0.0f;
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            devSumX += Math.abs(event.getX(i) - focusXFloat);
            devSumY += Math.abs(event.getY(i) - focusYFloat);
        }
        float devX = devSumX / (float)div;
        float devY = devSumY / (float)div;
        float spanX = devX * (float)2;
        float spanY = devY * (float)2;
        float span = this.inAnchoredZoomMode() ? spanY : (float)Math.hypot(spanX, spanY);
        boolean wasInProgress = this.isInProgress;
        this.focusX = MathKt.roundToInt((float)focusXFloat);
        this.focusY = MathKt.roundToInt((float)focusYFloat);
        if (!this.inAnchoredZoomMode() && this.isInProgress && (span < (float)this.minSpan || configChanged)) {
            this.listener.onZoomEvent(new ZoomEvent.End(this.eventTime, this.focusX, this.focusY, this.getScaleFactor()));
            this.isInProgress = false;
            this.initialSpan = span;
        }
        if (configChanged) {
            this.previousSpanX = this.currentSpanX = spanX;
            this.previousSpanY = this.currentSpanY = spanY;
            this.initialSpan = this.previousSpan = (this.currentSpan = span);
        }
        int n = minSpan = this.inAnchoredZoomMode() ? this.spanSlop : this.minSpan;
        if (!this.isInProgress && span >= (float)minSpan && (wasInProgress || Math.abs(span - this.initialSpan) > (float)this.spanSlop)) {
            this.previousSpanX = this.currentSpanX = spanX;
            this.previousSpanY = this.currentSpanY = spanY;
            this.previousSpan = this.currentSpan = span;
            this.prevTime = this.eventTime;
            this.isInProgress = this.listener.onZoomEvent(new ZoomEvent.Begin(this.eventTime, this.focusX, this.focusY));
        }
        if (action == 2) {
            this.currentSpanX = spanX;
            this.currentSpanY = spanY;
            this.currentSpan = span;
            boolean updatePrev = true;
            if (this.isInProgress) {
                updatePrev = this.listener.onZoomEvent(new ZoomEvent.Move(this.eventTime, this.focusX, this.focusY, this.getScaleFactor()));
            }
            if (updatePrev) {
                this.previousSpanX = this.currentSpanX;
                this.previousSpanY = this.currentSpanY;
                this.previousSpan = this.currentSpan;
                this.prevTime = this.eventTime;
            }
        }
        return true;
    }

    private final boolean inAnchoredZoomMode() {
        return this.anchoredZoomMode != 0;
    }

    private final float getScaleFactor() {
        if (this.inAnchoredZoomMode()) {
            boolean scaleUp = this.eventBeforeOrAboveStartingGestureEvent && this.currentSpan < this.previousSpan || !this.eventBeforeOrAboveStartingGestureEvent && this.currentSpan > this.previousSpan;
            float spanDiff = Math.abs(1.0f - this.currentSpan / this.previousSpan) * 0.5f;
            return this.previousSpan <= (float)this.spanSlop ? 1.0f : (scaleUp ? 1.0f + spanDiff : 1.0f - spanDiff);
        }
        return this.previousSpan > 0.0f ? this.currentSpan / this.previousSpan : 1.0f;
    }

    public final long getTimeDelta() {
        return this.eventTime - this.prevTime;
    }

    @SuppressLint(value={"ExecutorRegistration"})
    @JvmOverloads
    public ZoomGestureDetector(@NotNull Context context, @Px int spanSlop, @NotNull OnZoomGestureListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this(context, spanSlop, 0, listener, 4, null);
    }

    @SuppressLint(value={"ExecutorRegistration"})
    @JvmOverloads
    public ZoomGestureDetector(@NotNull Context context, @NotNull OnZoomGestureListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this(context, 0, 0, listener, 6, null);
    }

    public static final /* synthetic */ void access$setAnchoredZoomStartX$p(ZoomGestureDetector $this, float f) {
        $this.anchoredZoomStartX = f;
    }

    public static final /* synthetic */ void access$setAnchoredZoomStartY$p(ZoomGestureDetector $this, float f) {
        $this.anchoredZoomStartY = f;
    }

    public static final /* synthetic */ void access$setAnchoredZoomMode$p(ZoomGestureDetector $this, int n) {
        $this.anchoredZoomMode = n;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/camera/viewfinder/core/ZoomGestureDetector$Companion;", "", "()V", "ANCHORED_ZOOM_MODE_DOUBLE_TAP", "", "ANCHORED_ZOOM_MODE_NONE", "ANCHORED_ZOOM_MODE_STYLUS", "DEFAULT_MIN_SPAN", "SCALE_FACTOR", "", "camera-viewfinder-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Landroidx/camera/viewfinder/core/ZoomGestureDetector$OnZoomGestureListener;", "", "onZoomEvent", "", "zoomEvent", "Landroidx/camera/viewfinder/core/ZoomGestureDetector$ZoomEvent;", "camera-viewfinder-core_release"})
    public static interface OnZoomGestureListener {
        @UiThread
        public boolean onZoomEvent(@NotNull ZoomEvent var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001:\u0003\r\u000e\u000fB%\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Landroidx/camera/viewfinder/core/ZoomGestureDetector$ZoomEvent;", "", "eventTime", "", "focusX", "", "focusY", "(JII)V", "getEventTime", "()J", "getFocusX", "()I", "getFocusY", "Begin", "End", "Move", "camera-viewfinder-core_release"})
    public static abstract class ZoomEvent {
        private final long eventTime;
        private final int focusX;
        private final int focusY;

        private ZoomEvent(@IntRange(from=0L) long eventTime, @Px @IntRange(from=0L) int focusX, @Px @IntRange(from=0L) int focusY) {
            this.eventTime = eventTime;
            this.focusX = focusX;
            this.focusY = focusY;
        }

        public final long getEventTime() {
            return this.eventTime;
        }

        public final int getFocusX() {
            return this.focusX;
        }

        public final int getFocusY() {
            return this.focusY;
        }

        public /* synthetic */ ZoomEvent(long eventTime, int focusX, int focusY, DefaultConstructorMarker $constructor_marker) {
            this(eventTime, focusX, focusY);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/camera/viewfinder/core/ZoomGestureDetector$ZoomEvent$Begin;", "Landroidx/camera/viewfinder/core/ZoomGestureDetector$ZoomEvent;", "eventTime", "", "focusX", "", "focusY", "(JII)V", "camera-viewfinder-core_release"})
        public static final class Begin
        extends ZoomEvent {
            public Begin(@IntRange(from=0L) long eventTime, @Px @IntRange(from=0L) int focusX, @Px @IntRange(from=0L) int focusY) {
                super(eventTime, focusX, focusY, null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Landroidx/camera/viewfinder/core/ZoomGestureDetector$ZoomEvent$End;", "Landroidx/camera/viewfinder/core/ZoomGestureDetector$ZoomEvent;", "eventTime", "", "focusX", "", "focusY", "scaleFactor", "", "(JIIF)V", "getScaleFactor", "()F", "camera-viewfinder-core_release"})
        public static final class End
        extends ZoomEvent {
            private final float scaleFactor;

            public End(@IntRange(from=0L) long eventTime, @Px @IntRange(from=0L) int focusX, @Px @IntRange(from=0L) int focusY, @FloatRange(from=0.0, fromInclusive=false) float scaleFactor) {
                super(eventTime, focusX, focusY, null);
                this.scaleFactor = scaleFactor;
            }

            public final float getScaleFactor() {
                return this.scaleFactor;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Landroidx/camera/viewfinder/core/ZoomGestureDetector$ZoomEvent$Move;", "Landroidx/camera/viewfinder/core/ZoomGestureDetector$ZoomEvent;", "eventTime", "", "focusX", "", "focusY", "scaleFactor", "", "(JIIF)V", "getScaleFactor", "()F", "camera-viewfinder-core_release"})
        public static final class Move
        extends ZoomEvent {
            private final float scaleFactor;

            public Move(@IntRange(from=0L) long eventTime, @Px @IntRange(from=0L) int focusX, @Px @IntRange(from=0L) int focusY, @FloatRange(from=0.0, fromInclusive=false) float scaleFactor) {
                super(eventTime, focusX, focusY, null);
                this.scaleFactor = scaleFactor;
            }

            public final float getScaleFactor() {
                return this.scaleFactor;
            }
        }
    }
}

