/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.viewfinder.impl.surface;

import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.camera.impl.utils.Logger;
import androidx.camera.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bJ\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bH$R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/camera/viewfinder/impl/surface/DeferredSurface;", "Ljava/lang/AutoCloseable;", "()V", "closed", "", "lock", "", "terminationCompleterInternal", "Landroidx/concurrent/futures/CallbackToFutureAdapter$Completer;", "Ljava/lang/Void;", "terminationFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "close", "", "getSurfaceAsync", "Landroid/view/Surface;", "getTerminationFutureAsync", "provideSurfaceAsync", "Companion", "SurfaceUnavailableException", "camera-viewfinder-core_release"})
public abstract class DeferredSurface
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private final ListenableFuture<Void> terminationFuture;
    @GuardedBy(value="mLock")
    private boolean closed;
    @GuardedBy(value="mLock")
    @Nullable
    private CallbackToFutureAdapter.Completer<Void> terminationCompleterInternal;
    @NotNull
    private static final String TAG = "DeferredSurface";

    public DeferredSurface() {
        ListenableFuture listenableFuture = CallbackToFutureAdapter.getFuture(arg_0 -> DeferredSurface._init_$lambda$1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"getFuture {\n            \u2026rface + \")\"\n            }");
        this.terminationFuture = listenableFuture;
    }

    @NotNull
    public final ListenableFuture<Surface> getSurfaceAsync() {
        return this.provideSurfaceAsync();
    }

    @NotNull
    public final ListenableFuture<Void> getTerminationFutureAsync() {
        return Futures.nonCancellationPropagating(this.terminationFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        CallbackToFutureAdapter.Completer<Void> terminationCompleter = null;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.closed) {
                this.closed = true;
                terminationCompleter = this.terminationCompleterInternal;
                this.terminationCompleterInternal = null;
                Logger.INSTANCE.d(TAG, "surface closed,  closed=true " + this);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (terminationCompleter != null) {
            terminationCompleter.set(null);
        }
    }

    @NotNull
    protected abstract ListenableFuture<Surface> provideSurfaceAsync();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object _init_$lambda$1(DeferredSurface this$0, CallbackToFutureAdapter.Completer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            this$0.terminationCompleterInternal = it;
            Unit unit = Unit.INSTANCE;
        }
        return "ViewfinderSurface-termination(" + this$0 + ')';
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/camera/viewfinder/impl/surface/DeferredSurface$Companion;", "", "()V", "TAG", "", "camera-viewfinder-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/camera/viewfinder/impl/surface/DeferredSurface$SurfaceUnavailableException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "camera-viewfinder-core_release"})
    public static final class SurfaceUnavailableException
    extends Exception {
        public SurfaceUnavailableException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }
}

