/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.viewfinder.surface;

import android.annotation.SuppressLint;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.RestrictTo;
import androidx.camera.impl.utils.Logger;
import androidx.camera.impl.utils.executor.ViewfinderExecutors;
import androidx.camera.impl.utils.futures.FutureCallback;
import androidx.camera.impl.utils.futures.Futures;
import androidx.camera.viewfinder.impl.surface.DeferredSurface;
import androidx.camera.viewfinder.surface.ImplementationMode;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.concurrent.futures.ListenableFutureKt;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 -2\u00020\u0001:\u0006,-./01B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u000e\u0010!\u001a\u00020\u0019H\u0086@\u00a2\u0006\u0002\u0010\"J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016J\u0006\u0010$\u001a\u00020\u001cJ&\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010)0(J\u0006\u0010*\u001a\u00020+R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest;", "", "resolution", "Landroid/util/Size;", "outputMirrorMode", "", "sourceOrientation", "implementationMode", "Landroidx/camera/viewfinder/surface/ImplementationMode;", "(Landroid/util/Size;IILandroidx/camera/viewfinder/surface/ImplementationMode;)V", "cancellationCompleter", "Landroidx/concurrent/futures/CallbackToFutureAdapter$Completer;", "Ljava/lang/Void;", "getImplementationMode", "()Landroidx/camera/viewfinder/surface/ImplementationMode;", "mInternalDeferredSurface", "Landroidx/camera/viewfinder/impl/surface/DeferredSurface;", "getOutputMirrorMode", "()I", "getResolution", "()Landroid/util/Size;", "sessionStatusFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "getSourceOrientation", "surfaceCompleter", "Landroid/view/Surface;", "surfaceFutureAsync", "addRequestCancellationListener", "", "executor", "Ljava/util/concurrent/Executor;", "listener", "Ljava/lang/Runnable;", "getSurface", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSurfaceAsync", "markSurfaceSafeToRelease", "provideSurface", "surface", "resultListener", "Landroidx/core/util/Consumer;", "Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest$Result;", "willNotProvideSurface", "", "Builder", "Companion", "OutputMirrorMode", "RequestCancelledException", "Result", "SourceOrientationDegreesValue", "camera-viewfinder-core_release"})
public final class ViewfinderSurfaceRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Size resolution;
    private final int outputMirrorMode;
    private final int sourceOrientation;
    @Nullable
    private final ImplementationMode implementationMode;
    @NotNull
    private final DeferredSurface mInternalDeferredSurface;
    @NotNull
    private final CallbackToFutureAdapter.Completer<Void> cancellationCompleter;
    @NotNull
    private final ListenableFuture<Void> sessionStatusFuture;
    @NotNull
    private final CallbackToFutureAdapter.Completer<Surface> surfaceCompleter;
    @NotNull
    private final ListenableFuture<Surface> surfaceFutureAsync;
    @NotNull
    private static final String TAG = "SurfaceRequest";
    public static final int MIRROR_MODE_NONE = 0;
    public static final int MIRROR_MODE_HORIZONTAL = 1;

    public ViewfinderSurfaceRequest(@NotNull Size resolution, int outputMirrorMode, int sourceOrientation, @Nullable ImplementationMode implementationMode) {
        CallbackToFutureAdapter.Completer requestCancellationCompleter;
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        this.resolution = resolution;
        this.outputMirrorMode = outputMirrorMode;
        this.sourceOrientation = sourceOrientation;
        this.implementationMode = implementationMode;
        String surfaceRequestString = "SurfaceRequest[size: " + this.resolution + ", id: " + this.hashCode() + ']';
        AtomicReference<Object> cancellationCompleterRef = new AtomicReference<Object>(null);
        ListenableFuture listenableFuture = CallbackToFutureAdapter.getFuture(arg_0 -> ViewfinderSurfaceRequest._init_$lambda$0(cancellationCompleterRef, surfaceRequestString, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"getFuture {\n            \u2026ncellation\"\n            }");
        ListenableFuture requestCancellationFuture = listenableFuture;
        Object object = Preconditions.checkNotNull(cancellationCompleterRef.get());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"checkNotNull(cancellationCompleterRef.get())");
        this.cancellationCompleter = requestCancellationCompleter = (CallbackToFutureAdapter.Completer)object;
        AtomicReference<Object> sessionStatusCompleterRef = new AtomicReference<Object>(null);
        ListenableFuture listenableFuture2 = CallbackToFutureAdapter.getFuture(arg_0 -> ViewfinderSurfaceRequest._init_$lambda$1(sessionStatusCompleterRef, surfaceRequestString, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture2, (String)"getFuture<Void?> {\n     \u2026ing-status\"\n            }");
        this.sessionStatusFuture = listenableFuture2;
        Futures.addCallback(this.sessionStatusFuture, (FutureCallback)new FutureCallback<Void>((CallbackToFutureAdapter.Completer<Void>)requestCancellationCompleter, (ListenableFuture<Void>)requestCancellationFuture){
            final /* synthetic */ CallbackToFutureAdapter.Completer<Void> $requestCancellationCompleter;
            final /* synthetic */ ListenableFuture<Void> $requestCancellationFuture;
            {
                this.$requestCancellationCompleter = $requestCancellationCompleter;
                this.$requestCancellationFuture = $requestCancellationFuture;
            }

            @Override
            public void onSuccess(@Nullable Void result) {
                Preconditions.checkState((boolean)this.$requestCancellationCompleter.set(null));
            }

            @Override
            public void onFailure(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (t instanceof RequestCancelledException) {
                    Preconditions.checkState((boolean)this.$requestCancellationFuture.cancel(false));
                } else {
                    Preconditions.checkState((boolean)this.$requestCancellationCompleter.set(null));
                }
            }
        }, ViewfinderExecutors.directExecutor());
        Object object2 = Preconditions.checkNotNull(sessionStatusCompleterRef.get());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"checkNotNull(sessionStatusCompleterRef.get())");
        CallbackToFutureAdapter.Completer sessionStatusCompleter = (CallbackToFutureAdapter.Completer)object2;
        AtomicReference<Object> surfaceCompleterRef = new AtomicReference<Object>(null);
        ListenableFuture listenableFuture3 = CallbackToFutureAdapter.getFuture(arg_0 -> ViewfinderSurfaceRequest._init_$lambda$2(surfaceCompleterRef, surfaceRequestString, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture3, (String)"getFuture {\n            \u2026ng-Surface\"\n            }");
        this.surfaceFutureAsync = listenableFuture3;
        Object object3 = Preconditions.checkNotNull(surfaceCompleterRef.get());
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"checkNotNull(surfaceCompleterRef.get())");
        this.surfaceCompleter = (CallbackToFutureAdapter.Completer)object3;
        this.mInternalDeferredSurface = new DeferredSurface(){

            @Override
            @NotNull
            protected ListenableFuture<Surface> provideSurfaceAsync() {
                Logger.INSTANCE.d(ViewfinderSurfaceRequest.TAG, "mInternalViewfinderSurface + " + this + " provideSurface");
                return surfaceFutureAsync;
            }
        };
        final ListenableFuture<Void> terminationFuture = this.mInternalDeferredSurface.getTerminationFutureAsync();
        Futures.addCallback(this.surfaceFutureAsync, (FutureCallback)new FutureCallback<Surface>((CallbackToFutureAdapter.Completer<Void>)sessionStatusCompleter, surfaceRequestString){
            final /* synthetic */ CallbackToFutureAdapter.Completer<Void> $sessionStatusCompleter;
            final /* synthetic */ String $surfaceRequestString;
            {
                this.$sessionStatusCompleter = $sessionStatusCompleter;
                this.$surfaceRequestString = $surfaceRequestString;
            }

            @Override
            public void onSuccess(@Nullable Surface result) {
                Futures.propagate(terminationFuture, this.$sessionStatusCompleter);
            }

            @Override
            public void onFailure(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (t instanceof CancellationException) {
                    Preconditions.checkState((boolean)this.$sessionStatusCompleter.setException((Throwable)new RequestCancelledException(this.$surfaceRequestString + " cancelled.", t)));
                } else {
                    this.$sessionStatusCompleter.set(null);
                }
            }
        }, ViewfinderExecutors.directExecutor());
        terminationFuture.addListener(() -> ViewfinderSurfaceRequest._init_$lambda$3(this), ViewfinderExecutors.directExecutor());
    }

    @NotNull
    public final Size getResolution() {
        return this.resolution;
    }

    public final int getOutputMirrorMode() {
        return this.outputMirrorMode;
    }

    public final int getSourceOrientation() {
        return this.sourceOrientation;
    }

    @Nullable
    public final ImplementationMode getImplementationMode() {
        return this.implementationMode;
    }

    public final void markSurfaceSafeToRelease() {
        this.mInternalDeferredSurface.close();
    }

    @Nullable
    public final Object getSurface(@NotNull Continuation<? super Surface> $completion) {
        return ListenableFutureKt.await(this.mInternalDeferredSurface.getSurfaceAsync(), $completion);
    }

    @NotNull
    public final ListenableFuture<Surface> getSurfaceAsync() {
        return this.mInternalDeferredSurface.getSurfaceAsync();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @SuppressLint(value={"PairedRegistration"})
    public final void addRequestCancellationListener(@NotNull Executor executor, @NotNull Runnable listener) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.cancellationCompleter.addCancellationListener(listener, executor);
    }

    public final void provideSurface(@NotNull Surface surface, @NotNull Executor executor, @NotNull Consumer<Result> resultListener) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(resultListener, (String)"resultListener");
        if (this.surfaceCompleter.set((Object)surface) || this.surfaceFutureAsync.isCancelled()) {
            Futures.addCallback(this.sessionStatusFuture, (FutureCallback)new FutureCallback<Void>(resultListener, surface){
                final /* synthetic */ Consumer<Result> $resultListener;
                final /* synthetic */ Surface $surface;
                {
                    this.$resultListener = $resultListener;
                    this.$surface = $surface;
                }

                public void onSuccess(@Nullable Void result) {
                    this.$resultListener.accept((Object)new Result(0, this.$surface));
                }

                public void onFailure(@NotNull Throwable t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    Preconditions.checkState((boolean)(t instanceof RequestCancelledException), (String)("Producer surface session should only fail with request cancellation. Instead failed due to:\n" + t));
                    this.$resultListener.accept((Object)new Result(1, this.$surface));
                }
            }, executor);
        } else {
            Preconditions.checkState((boolean)this.surfaceFutureAsync.isDone());
            try {
                this.surfaceFutureAsync.get();
                executor.execute(() -> ViewfinderSurfaceRequest.provideSurface$lambda$4(resultListener, surface));
            }
            catch (InterruptedException e) {
                executor.execute(() -> ViewfinderSurfaceRequest.provideSurface$lambda$5(resultListener, surface));
            }
            catch (ExecutionException e) {
                executor.execute(() -> ViewfinderSurfaceRequest.provideSurface$lambda$6(resultListener, surface));
            }
        }
    }

    public final boolean willNotProvideSurface() {
        return this.surfaceCompleter.setException((Throwable)new DeferredSurface.SurfaceUnavailableException("Surface request will not complete."));
    }

    private static final Object _init_$lambda$0(AtomicReference $cancellationCompleterRef, String $surfaceRequestString, CallbackToFutureAdapter.Completer it) {
        Intrinsics.checkNotNullParameter((Object)$cancellationCompleterRef, (String)"$cancellationCompleterRef");
        Intrinsics.checkNotNullParameter((Object)$surfaceRequestString, (String)"$surfaceRequestString");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $cancellationCompleterRef.set(it);
        return $surfaceRequestString + "-cancellation";
    }

    private static final Object _init_$lambda$1(AtomicReference $sessionStatusCompleterRef, String $surfaceRequestString, CallbackToFutureAdapter.Completer it) {
        Intrinsics.checkNotNullParameter((Object)$sessionStatusCompleterRef, (String)"$sessionStatusCompleterRef");
        Intrinsics.checkNotNullParameter((Object)$surfaceRequestString, (String)"$surfaceRequestString");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $sessionStatusCompleterRef.set(it);
        return $surfaceRequestString + "-status";
    }

    private static final Object _init_$lambda$2(AtomicReference $surfaceCompleterRef, String $surfaceRequestString, CallbackToFutureAdapter.Completer it) {
        Intrinsics.checkNotNullParameter((Object)$surfaceCompleterRef, (String)"$surfaceCompleterRef");
        Intrinsics.checkNotNullParameter((Object)$surfaceRequestString, (String)"$surfaceRequestString");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $surfaceCompleterRef.set(it);
        return $surfaceRequestString + "-Surface";
    }

    private static final void _init_$lambda$3(ViewfinderSurfaceRequest this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Logger.INSTANCE.d(TAG, "mInternalViewfinderSurface + " + this$0.mInternalDeferredSurface + " terminateFuture triggered");
        this$0.surfaceFutureAsync.cancel(true);
    }

    private static final void provideSurface$lambda$4(Consumer $resultListener, Surface $surface) {
        Intrinsics.checkNotNullParameter((Object)$resultListener, (String)"$resultListener");
        Intrinsics.checkNotNullParameter((Object)$surface, (String)"$surface");
        $resultListener.accept((Object)new Result(3, $surface));
    }

    private static final void provideSurface$lambda$5(Consumer $resultListener, Surface $surface) {
        Intrinsics.checkNotNullParameter((Object)$resultListener, (String)"$resultListener");
        Intrinsics.checkNotNullParameter((Object)$surface, (String)"$surface");
        $resultListener.accept((Object)new Result(4, $surface));
    }

    private static final void provideSurface$lambda$6(Consumer $resultListener, Surface $surface) {
        Intrinsics.checkNotNullParameter((Object)$resultListener, (String)"$resultListener");
        Intrinsics.checkNotNullParameter((Object)$surface, (String)"$surface");
        $resultListener.accept((Object)new Result(4, $surface));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0012\u001a\u00020\bJ\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\rR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0016"}, d2={"Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest$Builder;", "", "resolution", "Landroid/util/Size;", "(Landroid/util/Size;)V", "builder", "(Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest$Builder;)V", "surfaceRequest", "Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest;", "(Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest;)V", "implementationMode", "Landroidx/camera/viewfinder/surface/ImplementationMode;", "outputMirrorMode", "", "getOutputMirrorMode$annotations", "()V", "sourceOrientation", "getSourceOrientation$annotations", "build", "setImplementationMode", "setOutputMirrorMode", "setSourceOrientation", "camera-viewfinder-core_release"})
    public static final class Builder {
        @NotNull
        private final Size resolution;
        private int outputMirrorMode;
        private int sourceOrientation;
        @Nullable
        private ImplementationMode implementationMode;

        private static /* synthetic */ void getOutputMirrorMode$annotations() {
        }

        private static /* synthetic */ void getSourceOrientation$annotations() {
        }

        public Builder(@NotNull Size resolution) {
            Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
            this.resolution = resolution;
        }

        public Builder(@NotNull Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            this.resolution = builder.resolution;
            this.implementationMode = builder.implementationMode;
            this.outputMirrorMode = builder.outputMirrorMode;
            this.sourceOrientation = builder.sourceOrientation;
        }

        public Builder(@NotNull ViewfinderSurfaceRequest surfaceRequest) {
            Intrinsics.checkNotNullParameter((Object)surfaceRequest, (String)"surfaceRequest");
            this.resolution = surfaceRequest.getResolution();
            this.implementationMode = surfaceRequest.getImplementationMode();
            this.outputMirrorMode = surfaceRequest.getOutputMirrorMode();
            this.sourceOrientation = surfaceRequest.getSourceOrientation();
        }

        @NotNull
        public final Builder setImplementationMode(@Nullable ImplementationMode implementationMode) {
            this.implementationMode = implementationMode;
            return this;
        }

        @NotNull
        public final Builder setOutputMirrorMode(int outputMirrorMode) {
            this.outputMirrorMode = outputMirrorMode;
            return this;
        }

        @NotNull
        public final Builder setSourceOrientation(int sourceOrientation) {
            this.sourceOrientation = sourceOrientation;
            return this;
        }

        @NotNull
        public final ViewfinderSurfaceRequest build() {
            if (this.outputMirrorMode != 0 && this.outputMirrorMode != 1) {
                throw new IllegalArgumentException("Output mirror mode : " + this.outputMirrorMode + " is invalid");
            }
            if (this.sourceOrientation != 0 && this.sourceOrientation != 90 && this.sourceOrientation != 180 && this.sourceOrientation != 270) {
                throw new IllegalArgumentException("Source orientation value: " + this.sourceOrientation + " is invalid");
            }
            return new ViewfinderSurfaceRequest(this.resolution, this.outputMirrorMode, this.sourceOrientation, this.implementationMode);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest$Companion;", "", "()V", "MIRROR_MODE_HORIZONTAL", "", "MIRROR_MODE_NONE", "TAG", "", "camera-viewfinder-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0083\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest$OutputMirrorMode;", "", "camera-viewfinder-core_release"})
    private static @interface OutputMirrorMode {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest$RequestCancelledException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "camera-viewfinder-core_release"})
    public static final class RequestCancelledException
    extends RuntimeException {
        public RequestCancelledException(@NotNull String message, @NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super(message, cause);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest$Result;", "", "code", "", "surface", "Landroid/view/Surface;", "(ILandroid/view/Surface;)V", "getCode", "()I", "getSurface", "()Landroid/view/Surface;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "ResultCode", "camera-viewfinder-core_release"})
    @AutoValue
    public static final class Result {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int code;
        @NotNull
        private final Surface surface;
        public static final int RESULT_SURFACE_USED_SUCCESSFULLY = 0;
        public static final int RESULT_REQUEST_CANCELLED = 1;
        public static final int RESULT_INVALID_SURFACE = 2;
        public static final int RESULT_SURFACE_ALREADY_PROVIDED = 3;
        public static final int RESULT_WILL_NOT_PROVIDE_SURFACE = 4;

        public Result(int code, @NotNull Surface surface) {
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            this.code = code;
            this.surface = surface;
        }

        public final int getCode() {
            return this.code;
        }

        @NotNull
        public final Surface getSurface() {
            return this.surface;
        }

        public final int component1() {
            return this.code;
        }

        @NotNull
        public final Surface component2() {
            return this.surface;
        }

        @NotNull
        public final Result copy(int code, @NotNull Surface surface) {
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            return new Result(code, surface);
        }

        public static /* synthetic */ Result copy$default(Result result, int n, Surface surface, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = result.code;
            }
            if ((n2 & 2) != 0) {
                surface = result.surface;
            }
            return result.copy(n, surface);
        }

        @NotNull
        public String toString() {
            return "Result(code=" + this.code + ", surface=" + this.surface + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.code);
            result = result * 31 + this.surface.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (this.code != result.code) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.surface, (Object)result.surface);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest$Result$Companion;", "", "()V", "RESULT_INVALID_SURFACE", "", "RESULT_REQUEST_CANCELLED", "RESULT_SURFACE_ALREADY_PROVIDED", "RESULT_SURFACE_USED_SUCCESSFULLY", "RESULT_WILL_NOT_PROVIDE_SURFACE", "camera-viewfinder-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Retention(value=AnnotationRetention.SOURCE)
        @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest$Result$ResultCode;", "", "camera-viewfinder-core_release"})
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @interface ResultCode {
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0083\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/camera/viewfinder/surface/ViewfinderSurfaceRequest$SourceOrientationDegreesValue;", "", "camera-viewfinder-core_release"})
    private static @interface SourceOrientationDegreesValue {
    }
}

