/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Easing;
import androidx.compose.runtime.Immutable;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathMeasure;
import androidx.compose.ui.graphics.SkiaBackedPathMeasure_skikoKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/compose/animation/core/PathEasing;", "Landroidx/compose/animation/core/Easing;", "path", "Landroidx/compose/ui/graphics/Path;", "(Landroidx/compose/ui/graphics/Path;)V", "offsetX", "", "offsetY", "transform", "", "fraction", "animation-core"})
@Immutable
public final class PathEasing
implements Easing {
    @NotNull
    private final float[] offsetX;
    @NotNull
    private final float[] offsetY;
    public static final int $stable;

    public PathEasing(@NotNull Path path) {
        int n;
        PathMeasure pathMeasure = SkiaBackedPathMeasure_skikoKt.PathMeasure();
        pathMeasure.setPath(path, false);
        float pathLength = pathMeasure.getLength();
        if (!(pathLength > 0.0f)) {
            boolean $i$a$-require-PathEasing$22 = false;
            String $i$a$-require-PathEasing$22 = "Path cannot be zero in length. Ensure that supplied Path starts at [0,0] and ends at [1,1]";
            throw new IllegalArgumentException($i$a$-require-PathEasing$22.toString());
        }
        int numPoints = (int)(pathLength / 0.002f) + 1;
        int $i$a$-require-PathEasing$22 = 0;
        float[] fArray = new float[numPoints];
        PathEasing pathEasing = this;
        while ($i$a$-require-PathEasing$22 < numPoints) {
            n = $i$a$-require-PathEasing$22++;
            fArray[n] = 0.0f;
        }
        pathEasing.offsetX = fArray;
        $i$a$-require-PathEasing$22 = 0;
        fArray = new float[numPoints];
        pathEasing = this;
        while ($i$a$-require-PathEasing$22 < numPoints) {
            n = $i$a$-require-PathEasing$22++;
            fArray[n] = 0.0f;
        }
        pathEasing.offsetY = fArray;
        for (int i = 0; i < numPoints; ++i) {
            float distance = (float)i * pathLength / (float)(numPoints - 1);
            long offset = pathMeasure.getPosition-tuRUvjQ(distance);
            this.offsetX[i] = Offset.getX-impl((long)offset);
            this.offsetY[i] = Offset.getY-impl((long)offset);
            if (i <= 0 || !(this.offsetX[i] < this.offsetX[i - 1])) continue;
            throw new IllegalArgumentException("Path needs to be continuously increasing");
        }
    }

    @Override
    public float transform(float fraction) {
        if (fraction <= 0.0f) {
            return 0.0f;
        }
        if (fraction >= 1.0f) {
            return 1.0f;
        }
        int startIndex = ArraysKt.binarySearch$default((float[])this.offsetX, (float)fraction, (int)0, (int)0, (int)6, null);
        if (startIndex > 0) {
            return this.offsetY[startIndex];
        }
        int insertionStartIndex = Math.abs(startIndex);
        if (insertionStartIndex >= this.offsetX.length - 1) {
            return ArraysKt.last((float[])this.offsetY);
        }
        int endIndex = insertionStartIndex + 1;
        float xRange = this.offsetX[endIndex] - this.offsetX[insertionStartIndex];
        float tInRange = fraction - this.offsetX[insertionStartIndex];
        float newFraction = tInRange / xRange;
        float startY = this.offsetY[insertionStartIndex];
        float endY = this.offsetY[endIndex];
        return startY + newFraction * (endY - startY);
    }
}

