/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.graphics.vector;

import androidx.compose.animation.core.RepeatMode;
import androidx.compose.animation.graphics.vector.Animator;
import androidx.compose.animation.graphics.vector.ColorPropertyValues;
import androidx.compose.animation.graphics.vector.FloatPropertyValues;
import androidx.compose.animation.graphics.vector.PathPropertyValues;
import androidx.compose.animation.graphics.vector.PropertyValues;
import androidx.compose.animation.graphics.vector.PropertyValuesHolder;
import androidx.compose.animation.graphics.vector.PropertyValuesHolder2D;
import androidx.compose.animation.graphics.vector.PropertyValuesHolderColor;
import androidx.compose.animation.graphics.vector.PropertyValuesHolderFloat;
import androidx.compose.animation.graphics.vector.PropertyValuesHolderInt;
import androidx.compose.animation.graphics.vector.PropertyValuesHolderPath;
import androidx.compose.animation.graphics.vector.Timestamp;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u00a2\u0006\u0002\u0010\u000bJ0\u0010\u0016\u001a\u00020\u00172\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\u0013\u0010\"\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u00c6\u0003JE\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0012\b\u0002\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001J\t\u0010)\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\r\u00a8\u0006*"}, d2={"Landroidx/compose/animation/graphics/vector/ObjectAnimator;", "Landroidx/compose/animation/graphics/vector/Animator;", "duration", "", "startDelay", "repeatCount", "repeatMode", "Landroidx/compose/animation/core/RepeatMode;", "holders", "", "Landroidx/compose/animation/graphics/vector/PropertyValuesHolder;", "(IIILandroidx/compose/animation/core/RepeatMode;Ljava/util/List;)V", "getDuration", "()I", "getHolders", "()Ljava/util/List;", "getRepeatCount", "getRepeatMode", "()Landroidx/compose/animation/core/RepeatMode;", "getStartDelay", "totalDuration", "getTotalDuration", "collectPropertyValues", "", "propertyValuesMap", "", "", "Landroidx/compose/animation/graphics/vector/PropertyValues;", "overallDuration", "parentDelay", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "animation-graphics_release"})
@SourceDebugExtension(value={"SMAP\nAnimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Animator.kt\nandroidx/compose/animation/graphics/vector/ObjectAnimator\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,650:1\n33#2,6:651\n*S KotlinDebug\n*F\n+ 1 Animator.kt\nandroidx/compose/animation/graphics/vector/ObjectAnimator\n*L\n262#1:651,6\n*E\n"})
public final class ObjectAnimator
extends Animator {
    private final int duration;
    private final int startDelay;
    private final int repeatCount;
    @NotNull
    private final RepeatMode repeatMode;
    @NotNull
    private final List<PropertyValuesHolder<?>> holders;
    private final int totalDuration;

    public ObjectAnimator(int duration, int startDelay, int repeatCount, @NotNull RepeatMode repeatMode, @NotNull List<? extends PropertyValuesHolder<?>> holders) {
        Intrinsics.checkNotNullParameter((Object)repeatMode, (String)"repeatMode");
        Intrinsics.checkNotNullParameter(holders, (String)"holders");
        super(null);
        this.duration = duration;
        this.startDelay = startDelay;
        this.repeatCount = repeatCount;
        this.repeatMode = repeatMode;
        this.holders = holders;
        this.totalDuration = this.repeatCount == -1 ? Integer.MAX_VALUE : this.startDelay + this.duration * (this.repeatCount + 1);
    }

    public final int getDuration() {
        return this.duration;
    }

    public final int getStartDelay() {
        return this.startDelay;
    }

    public final int getRepeatCount() {
        return this.repeatCount;
    }

    @NotNull
    public final RepeatMode getRepeatMode() {
        return this.repeatMode;
    }

    @NotNull
    public final List<PropertyValuesHolder<?>> getHolders() {
        return this.holders;
    }

    @Override
    public int getTotalDuration() {
        return this.totalDuration;
    }

    @Override
    public void collectPropertyValues(@NotNull Map<String, PropertyValues<?>> propertyValuesMap, int overallDuration, int parentDelay) {
        Intrinsics.checkNotNullParameter(propertyValuesMap, (String)"propertyValuesMap");
        List<PropertyValuesHolder<?>> $this$fastForEach$iv = this.holders;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            PropertyValues values;
            PropertyValuesHolder<?> item$iv;
            PropertyValuesHolder<?> holder = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            PropertyValuesHolder<?> propertyValuesHolder = holder;
            if (propertyValuesHolder instanceof PropertyValuesHolder2D) continue;
            if (propertyValuesHolder instanceof PropertyValuesHolderFloat) {
                FloatPropertyValues floatPropertyValues = (FloatPropertyValues)propertyValuesMap.get(((PropertyValuesHolderFloat)holder).getPropertyName());
                if (floatPropertyValues == null) {
                    floatPropertyValues = new FloatPropertyValues();
                }
                values = floatPropertyValues;
                values.getTimestamps().add(new Timestamp(parentDelay + this.startDelay, this.duration, this.repeatCount, this.repeatMode, holder));
                propertyValuesMap.put(((PropertyValuesHolderFloat)holder).getPropertyName(), values);
                continue;
            }
            if (propertyValuesHolder instanceof PropertyValuesHolderColor) {
                ColorPropertyValues colorPropertyValues = (ColorPropertyValues)propertyValuesMap.get(((PropertyValuesHolderColor)holder).getPropertyName());
                if (colorPropertyValues == null) {
                    colorPropertyValues = new ColorPropertyValues();
                }
                values = colorPropertyValues;
                values.getTimestamps().add(new Timestamp(parentDelay + this.startDelay, this.duration, this.repeatCount, this.repeatMode, holder));
                propertyValuesMap.put(((PropertyValuesHolderColor)holder).getPropertyName(), values);
                continue;
            }
            if (propertyValuesHolder instanceof PropertyValuesHolderPath) {
                PathPropertyValues pathPropertyValues = (PathPropertyValues)propertyValuesMap.get(((PropertyValuesHolderPath)holder).getPropertyName());
                if (pathPropertyValues == null) {
                    pathPropertyValues = new PathPropertyValues();
                }
                values = pathPropertyValues;
                values.getTimestamps().add(new Timestamp(parentDelay + this.startDelay, this.duration, this.repeatCount, this.repeatMode, holder));
                propertyValuesMap.put(((PropertyValuesHolderPath)holder).getPropertyName(), values);
                continue;
            }
            if (!(propertyValuesHolder instanceof PropertyValuesHolderInt)) continue;
        }
    }

    public final int component1() {
        return this.duration;
    }

    public final int component2() {
        return this.startDelay;
    }

    public final int component3() {
        return this.repeatCount;
    }

    @NotNull
    public final RepeatMode component4() {
        return this.repeatMode;
    }

    @NotNull
    public final List<PropertyValuesHolder<?>> component5() {
        return this.holders;
    }

    @NotNull
    public final ObjectAnimator copy(int duration, int startDelay, int repeatCount, @NotNull RepeatMode repeatMode, @NotNull List<? extends PropertyValuesHolder<?>> holders) {
        Intrinsics.checkNotNullParameter((Object)repeatMode, (String)"repeatMode");
        Intrinsics.checkNotNullParameter(holders, (String)"holders");
        return new ObjectAnimator(duration, startDelay, repeatCount, repeatMode, holders);
    }

    public static /* synthetic */ ObjectAnimator copy$default(ObjectAnimator objectAnimator, int n, int n2, int n3, RepeatMode repeatMode, List list, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = objectAnimator.duration;
        }
        if ((n4 & 2) != 0) {
            n2 = objectAnimator.startDelay;
        }
        if ((n4 & 4) != 0) {
            n3 = objectAnimator.repeatCount;
        }
        if ((n4 & 8) != 0) {
            repeatMode = objectAnimator.repeatMode;
        }
        if ((n4 & 0x10) != 0) {
            list = objectAnimator.holders;
        }
        return objectAnimator.copy(n, n2, n3, repeatMode, list);
    }

    @NotNull
    public String toString() {
        return "ObjectAnimator(duration=" + this.duration + ", startDelay=" + this.startDelay + ", repeatCount=" + this.repeatCount + ", repeatMode=" + this.repeatMode + ", holders=" + this.holders + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.duration);
        result = result * 31 + Integer.hashCode(this.startDelay);
        result = result * 31 + Integer.hashCode(this.repeatCount);
        result = result * 31 + this.repeatMode.hashCode();
        result = result * 31 + ((Object)this.holders).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ObjectAnimator)) {
            return false;
        }
        ObjectAnimator objectAnimator = (ObjectAnimator)other;
        if (this.duration != objectAnimator.duration) {
            return false;
        }
        if (this.startDelay != objectAnimator.startDelay) {
            return false;
        }
        if (this.repeatCount != objectAnimator.repeatCount) {
            return false;
        }
        if (this.repeatMode != objectAnimator.repeatMode) {
            return false;
        }
        return Intrinsics.areEqual(this.holders, objectAnimator.holders);
    }
}

