/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.graphics.vector;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.animation.core.DurationBasedAnimationSpec;
import androidx.compose.animation.core.FiniteAnimationSpec;
import androidx.compose.animation.core.KeyframesSpec;
import androidx.compose.animation.core.RepeatMode;
import androidx.compose.animation.graphics.vector.PropertyValuesHolder;
import androidx.compose.animation.graphics.vector.PropertyValuesHolderColor;
import androidx.compose.animation.graphics.vector.PropertyValuesHolderFloat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010\u000bJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u0016"}, d2={"Landroidx/compose/animation/graphics/vector/Timestamp;", "T", "", "timeMillis", "", "durationMillis", "repeatCount", "repeatMode", "Landroidx/compose/animation/core/RepeatMode;", "holder", "Landroidx/compose/animation/graphics/vector/PropertyValuesHolder;", "(IIILandroidx/compose/animation/core/RepeatMode;Landroidx/compose/animation/graphics/vector/PropertyValuesHolder;)V", "getDurationMillis", "()I", "getHolder", "()Landroidx/compose/animation/graphics/vector/PropertyValuesHolder;", "getRepeatCount", "getRepeatMode", "()Landroidx/compose/animation/core/RepeatMode;", "getTimeMillis", "asAnimationSpec", "Landroidx/compose/animation/core/FiniteAnimationSpec;", "animation-graphics_release"})
public final class Timestamp<T> {
    private final int timeMillis;
    private final int durationMillis;
    private final int repeatCount;
    @NotNull
    private final RepeatMode repeatMode;
    @NotNull
    private final PropertyValuesHolder<T> holder;

    public Timestamp(int timeMillis, int durationMillis, int repeatCount, @NotNull RepeatMode repeatMode, @NotNull PropertyValuesHolder<T> holder) {
        Intrinsics.checkNotNullParameter((Object)repeatMode, (String)"repeatMode");
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        this.timeMillis = timeMillis;
        this.durationMillis = durationMillis;
        this.repeatCount = repeatCount;
        this.repeatMode = repeatMode;
        this.holder = holder;
    }

    public final int getTimeMillis() {
        return this.timeMillis;
    }

    public final int getDurationMillis() {
        return this.durationMillis;
    }

    public final int getRepeatCount() {
        return this.repeatCount;
    }

    @NotNull
    public final RepeatMode getRepeatMode() {
        return this.repeatMode;
    }

    @NotNull
    public final PropertyValuesHolder<T> getHolder() {
        return this.holder;
    }

    @NotNull
    public final FiniteAnimationSpec<T> asAnimationSpec() {
        KeyframesSpec<Float> keyframesSpec;
        PropertyValuesHolder<T> propertyValuesHolder = this.holder;
        if (propertyValuesHolder instanceof PropertyValuesHolderFloat) {
            keyframesSpec = ((PropertyValuesHolderFloat)this.holder).asKeyframeSpec(this.durationMillis);
        } else if (propertyValuesHolder instanceof PropertyValuesHolderColor) {
            keyframesSpec = ((PropertyValuesHolderColor)this.holder).asKeyframeSpec(this.durationMillis);
        } else {
            throw new RuntimeException("Unexpected value type: " + this.holder);
        }
        KeyframesSpec<Float> keyframesSpec2 = keyframesSpec;
        Intrinsics.checkNotNull(keyframesSpec2, (String)"null cannot be cast to non-null type androidx.compose.animation.core.KeyframesSpec<T of androidx.compose.animation.graphics.vector.Timestamp>");
        KeyframesSpec<Float> spec = keyframesSpec2;
        return this.repeatCount == 0 ? (FiniteAnimationSpec)spec : (FiniteAnimationSpec)AnimationSpecKt.repeatable-91I0pcU$default((int)(this.repeatCount == -1 ? Integer.MAX_VALUE : this.repeatCount + 1), (DurationBasedAnimationSpec)((DurationBasedAnimationSpec)spec), (RepeatMode)this.repeatMode, (long)0L, (int)8, null);
    }
}

