/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.graphics.vector;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.VectorizedFiniteAnimationSpec;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\f\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\"\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00062\u0006\u0010\n\u001a\u00020\u0007H\u0002J%\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0012\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011R&\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/compose/animation/graphics/vector/VectorizedCombinedSpec;", "V", "Landroidx/compose/animation/core/AnimationVector;", "Landroidx/compose/animation/core/VectorizedFiniteAnimationSpec;", "animations", "", "Lkotlin/Pair;", "", "(Ljava/util/List;)V", "chooseAnimation", "playTimeNanos", "getDurationNanos", "initialValue", "targetValue", "initialVelocity", "(Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)J", "getValueFromNanos", "(JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "getVelocityFromNanos", "animation-graphics_release"})
@SourceDebugExtension(value={"SMAP\nAnimatorAnimationSpecs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimatorAnimationSpecs.kt\nandroidx/compose/animation/graphics/vector/VectorizedCombinedSpec\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n533#2,6:169\n*S KotlinDebug\n*F\n+ 1 AnimatorAnimationSpecs.kt\nandroidx/compose/animation/graphics/vector/VectorizedCombinedSpec\n*L\n116#1:169,6\n*E\n"})
final class VectorizedCombinedSpec<V extends AnimationVector>
implements VectorizedFiniteAnimationSpec<V> {
    @NotNull
    private final List<Pair<Long, VectorizedFiniteAnimationSpec<V>>> animations;

    public VectorizedCombinedSpec(@NotNull List<? extends Pair<Long, ? extends VectorizedFiniteAnimationSpec<V>>> animations) {
        Intrinsics.checkNotNullParameter(animations, (String)"animations");
        this.animations = animations;
    }

    private final Pair<Long, VectorizedFiniteAnimationSpec<V>> chooseAnimation(long playTimeNanos) {
        Pair pair;
        Pair<Long, VectorizedFiniteAnimationSpec<V>> pair2;
        block2: {
            List<Pair<Long, VectorizedFiniteAnimationSpec<V>>> $this$lastOrNull$iv = this.animations;
            boolean $i$f$lastOrNull = false;
            ListIterator<Pair<Long, VectorizedFiniteAnimationSpec<V>>> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Pair<Long, VectorizedFiniteAnimationSpec<V>> element$iv;
                Pair<Long, VectorizedFiniteAnimationSpec<V>> pair3 = element$iv = iterator$iv.previous();
                boolean bl = false;
                long timeNanos = ((Number)pair3.component1()).longValue();
                if (!(timeNanos <= playTimeNanos)) continue;
                pair2 = element$iv;
                break block2;
            }
            pair2 = null;
        }
        if ((pair = (Pair)pair2) == null) {
            pair = (Pair)CollectionsKt.first(this.animations);
        }
        return pair;
    }

    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        Pair<Long, VectorizedFiniteAnimationSpec<V>> pair = this.chooseAnimation(playTimeNanos);
        long timeNanos = ((Number)pair.component1()).longValue();
        VectorizedFiniteAnimationSpec animation = (VectorizedFiniteAnimationSpec)pair.component2();
        long internalPlayTimeNanos = playTimeNanos - timeNanos;
        return (V)animation.getValueFromNanos(internalPlayTimeNanos, initialValue, targetValue, initialVelocity);
    }

    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        Pair<Long, VectorizedFiniteAnimationSpec<V>> pair = this.chooseAnimation(playTimeNanos);
        long timeNanos = ((Number)pair.component1()).longValue();
        VectorizedFiniteAnimationSpec animation = (VectorizedFiniteAnimationSpec)pair.component2();
        return (V)animation.getVelocityFromNanos(playTimeNanos - timeNanos, initialValue, targetValue, initialVelocity);
    }

    public long getDurationNanos(@NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        Pair pair = (Pair)CollectionsKt.last(this.animations);
        long timeNanos = ((Number)pair.component1()).longValue();
        VectorizedFiniteAnimationSpec animation = (VectorizedFiniteAnimationSpec)pair.component2();
        return timeNanos + animation.getDurationNanos(initialValue, targetValue, initialVelocity);
    }
}

