/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.graphics.vector;

import androidx.compose.animation.core.RepeatMode;
import androidx.compose.animation.core.Transition;
import androidx.compose.animation.graphics.vector.Animator;
import androidx.compose.animation.graphics.vector.Keyframe;
import androidx.compose.animation.graphics.vector.ObjectAnimator;
import androidx.compose.animation.graphics.vector.Ordering;
import androidx.compose.animation.graphics.vector.PropertyValuesHolder;
import androidx.compose.animation.graphics.vector.PropertyValuesHolder1D;
import androidx.compose.animation.graphics.vector.PropertyValuesHolderColor;
import androidx.compose.animation.graphics.vector.PropertyValuesHolderFloat;
import androidx.compose.animation.graphics.vector.PropertyValuesHolderInt;
import androidx.compose.animation.graphics.vector.PropertyValuesHolderPath;
import androidx.compose.animation.graphics.vector.StateVectorConfig;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.ScopeUpdateScope;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J3\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0017\u00a2\u0006\u0002\u0010\u0018J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J#\u0010\u001b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\fH\u00d6\u0001J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0002J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Landroidx/compose/animation/graphics/vector/AnimatorSet;", "Landroidx/compose/animation/graphics/vector/Animator;", "animators", "", "ordering", "Landroidx/compose/animation/graphics/vector/Ordering;", "(Ljava/util/List;Landroidx/compose/animation/graphics/vector/Ordering;)V", "getAnimators", "()Ljava/util/List;", "getOrdering", "()Landroidx/compose/animation/graphics/vector/Ordering;", "totalDuration", "", "getTotalDuration", "()I", "Configure", "", "transition", "Landroidx/compose/animation/core/Transition;", "", "config", "Landroidx/compose/animation/graphics/vector/StateVectorConfig;", "overallDuration", "parentDelay", "(Landroidx/compose/animation/core/Transition;Landroidx/compose/animation/graphics/vector/StateVectorConfig;IILandroidx/compose/runtime/Composer;I)V", "component1", "component2", "copy", "equals", "other", "", "hashCode", "normalizeSequentialAnimators", "toString", "", "animation-graphics_release"})
public final class AnimatorSet
extends Animator {
    @NotNull
    private final List<Animator> animators;
    @NotNull
    private final Ordering ordering;
    private final int totalDuration;

    /*
     * WARNING - void declaration
     */
    public AnimatorSet(@NotNull List<? extends Animator> animators, @NotNull Ordering ordering) {
        int n;
        Intrinsics.checkNotNullParameter(animators, (String)"animators");
        Intrinsics.checkNotNullParameter((Object)((Object)ordering), (String)"ordering");
        super(null);
        this.animators = animators;
        this.ordering = ordering;
        AnimatorSet animatorSet = this;
        Ordering ordering2 = this.ordering;
        int n2 = WhenMappings.$EnumSwitchMapping$0[ordering2.ordinal()];
        switch (n2) {
            case 1: {
                Object v1;
                void $this$fastMaxBy$iv;
                List<Animator> list = this.animators;
                AnimatorSet animatorSet2 = animatorSet;
                boolean $i$f$fastMaxBy = false;
                boolean bl = false;
                if ($this$fastMaxBy$iv.isEmpty()) {
                    v1 = null;
                } else {
                    Object maxElem$iv = $this$fastMaxBy$iv.get(0);
                    Animator it = (Animator)maxElem$iv;
                    boolean bl2 = false;
                    int maxValue$iv = it.getTotalDuration();
                    int n3 = 1;
                    int n4 = CollectionsKt.getLastIndex((List)$this$fastMaxBy$iv);
                    if (n3 <= n4) {
                        int i$iv;
                        do {
                            i$iv = n3++;
                            Object e$iv = $this$fastMaxBy$iv.get(i$iv);
                            Animator it2 = (Animator)e$iv;
                            $i$a$-fastMaxBy-AnimatorSet$totalDuration$1 = false;
                            int v$iv = it2.getTotalDuration();
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (i$iv != n4);
                    }
                    v1 = maxElem$iv;
                }
                Object var19_30 = v1;
                AnimatorSet animatorSet3 = animatorSet2;
                Animator animator = var19_30;
                if (animator == null) {
                    n = 0;
                    break;
                }
                n = animator.getTotalDuration();
                break;
            }
            case 2: {
                int n5;
                void $this$fastSumBy$iv;
                List<Animator> list = this.animators;
                AnimatorSet animatorSet4 = animatorSet;
                boolean $i$f$fastSumBy = false;
                boolean $i$f$fastMaxBy = false;
                int sum$iv = 0;
                void $this$fastForEach$iv$iv = $this$fastSumBy$iv;
                boolean $i$f$fastForEach = false;
                int n6 = 0;
                n6 = 0;
                int n7 = $this$fastForEach$iv$iv.size() + -1;
                if (n6 <= n7) {
                    do {
                        void it;
                        Object item$iv$iv;
                        int index$iv$iv = n6++;
                        Object element$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                        boolean bl = false;
                        Animator animator = (Animator)element$iv;
                        n5 = sum$iv;
                        boolean bl3 = false;
                        int n8 = it.getTotalDuration();
                        sum$iv = n5 + n8;
                    } while (n6 <= n7);
                }
                n5 = sum$iv;
                AnimatorSet animatorSet3 = animatorSet4;
                n = n5;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        animatorSet3.totalDuration = n;
    }

    @NotNull
    public final List<Animator> getAnimators() {
        return this.animators;
    }

    @NotNull
    public final Ordering getOrdering() {
        return this.ordering;
    }

    @Override
    public int getTotalDuration() {
        return this.totalDuration;
    }

    @Override
    @Composable
    public void Configure(@NotNull Transition<Boolean> transition, @NotNull StateVectorConfig config, int overallDuration, int parentDelay, @Nullable Composer $composer, int $changed) {
        Intrinsics.checkNotNullParameter(transition, (String)"transition");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        $composer = $composer.startRestartGroup(-1477775128);
        ComposerKt.sourceInformation((Composer)$composer, (String)"C(Configure)P(3):Animator.kt#p9hpxh");
        int $dirty = $changed;
        Object object = this.ordering;
        int n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
        switch (n) {
            case 1: {
                $composer.startReplaceableGroup(-1477774915);
                ComposerKt.sourceInformation((Composer)$composer, (String)"*115@3664L59");
                List<Animator> $this$fastForEach$iv = this.animators;
                boolean $i$f$fastForEach = false;
                int n2 = 0;
                n2 = 0;
                int n3 = $this$fastForEach$iv.size() + -1;
                if (n2 <= n3) {
                    do {
                        Animator item$iv;
                        int index$iv = n2++;
                        Animator animator = item$iv = $this$fastForEach$iv.get(index$iv);
                        boolean bl = false;
                        animator.Configure(transition, config, overallDuration, parentDelay, $composer, 0x40 | 0xE & $dirty | 0x380 & $dirty | 0x1C00 & $dirty);
                    } while (n2 <= n3);
                }
                $composer.endReplaceableGroup();
                break;
            }
            case 2: {
                $composer.startReplaceableGroup(-1477774703);
                ComposerKt.sourceInformation((Composer)$composer, (String)"*121@3948L64");
                int accumulatedDelay = 0;
                accumulatedDelay = parentDelay;
                List<Animator> $this$fastForEach$iv = this.normalizeSequentialAnimators();
                boolean $i$f$fastForEach = false;
                int n4 = 0;
                n4 = 0;
                int n5 = $this$fastForEach$iv.size() + -1;
                if (n4 <= n5) {
                    do {
                        Animator item$iv;
                        int index$iv = n4++;
                        Animator animator = item$iv = $this$fastForEach$iv.get(index$iv);
                        boolean bl = false;
                        animator.Configure(transition, config, overallDuration, accumulatedDelay, $composer, 0x40 | 0xE & $dirty | 0x380 & $dirty);
                        accumulatedDelay += animator.getTotalDuration();
                    } while (n4 <= n5);
                }
                $composer.endReplaceableGroup();
                break;
            }
            default: {
                $composer.startReplaceableGroup(-1477774379);
                $composer.endReplaceableGroup();
            }
        }
        object = this;
        ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
        if (scopeUpdateScope != null) {
            scopeUpdateScope.updateScope((Function2)new Function2<Composer, Integer, Unit>((AnimatorSet)object, transition, config, overallDuration, parentDelay, $changed){
                final /* synthetic */ AnimatorSet $tmp0_rcvr;
                final /* synthetic */ Transition<Boolean> $transition;
                final /* synthetic */ StateVectorConfig $config;
                final /* synthetic */ int $overallDuration;
                final /* synthetic */ int $parentDelay;
                final /* synthetic */ int $$changed;
                {
                    this.$tmp0_rcvr = $tmp0_rcvr;
                    this.$transition = $transition;
                    this.$config = $config;
                    this.$overallDuration = $overallDuration;
                    this.$parentDelay = $parentDelay;
                    this.$$changed = $$changed;
                    super(2);
                }

                public final void invoke(@Nullable Composer $composer, int $force) {
                    this.$tmp0_rcvr.Configure(this.$transition, this.$config, this.$overallDuration, this.$parentDelay, $composer, this.$$changed | 1);
                }
            });
        }
    }

    private final List<Animator> normalizeSequentialAnimators() {
        if (this.ordering != Ordering.Sequentially) {
            return this.animators;
        }
        String propertyName = null;
        boolean bl = false;
        List keyframes = new ArrayList();
        Integer startDelay = null;
        PropertyValuesHolder resultHolder = null;
        float accumulatedDuration = 0.0f;
        int totalDuration = this.getTotalDuration();
        for (Animator animator : this.animators) {
            List<PropertyValuesHolder<?>> holders;
            if (!(animator instanceof ObjectAnimator)) {
                return this.animators;
            }
            if (startDelay == null) {
                startDelay = ((ObjectAnimator)animator).getStartDelay();
            }
            if ((holders = ((ObjectAnimator)animator).getHolders()).size() != 1) {
                return this.animators;
            }
            PropertyValuesHolder<?> holder = holders.get(0);
            if (!(holder instanceof PropertyValuesHolder1D)) {
                return this.animators;
            }
            if (propertyName == null) {
                propertyName = ((PropertyValuesHolder1D)holder).getPropertyName();
            } else if (!Intrinsics.areEqual((Object)propertyName, (Object)((PropertyValuesHolder1D)holder).getPropertyName())) {
                return this.animators;
            }
            if (resultHolder == null) {
                PropertyValuesHolder propertyValuesHolder;
                PropertyValuesHolder1D propertyValuesHolder1D = (PropertyValuesHolder1D)holder;
                if (propertyValuesHolder1D instanceof PropertyValuesHolderFloat) {
                    propertyValuesHolder = new PropertyValuesHolderFloat(propertyName, keyframes);
                } else if (propertyValuesHolder1D instanceof PropertyValuesHolderInt) {
                    propertyValuesHolder = new PropertyValuesHolderInt(propertyName, keyframes);
                } else if (propertyValuesHolder1D instanceof PropertyValuesHolderPath) {
                    propertyValuesHolder = new PropertyValuesHolderPath(propertyName, keyframes);
                } else if (propertyValuesHolder1D instanceof PropertyValuesHolderColor) {
                    propertyValuesHolder = new PropertyValuesHolderColor(propertyName, keyframes);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                resultHolder = propertyValuesHolder;
            }
            if (((PropertyValuesHolder1D)holder).getAnimatorKeyframes().size() != 2) {
                return this.animators;
            }
            Keyframe start = ((PropertyValuesHolder1D)holder).getAnimatorKeyframes().get(0);
            Keyframe end = ((PropertyValuesHolder1D)holder).getAnimatorKeyframes().get(1);
            if (!(start.getFraction() == 0.0f) || !(end.getFraction() == 1.0f)) {
                return this.animators;
            }
            if (keyframes.isEmpty()) {
                keyframes.add(new Keyframe(0.0f, start.getValue(), start.getInterpolator()));
            }
            float fraction = (accumulatedDuration += (float)((ObjectAnimator)animator).getDuration()) / (float)(totalDuration - startDelay);
            keyframes.add(new Keyframe(fraction, end.getValue(), end.getInterpolator()));
        }
        if (resultHolder == null) {
            return this.animators;
        }
        Integer n = startDelay;
        return CollectionsKt.listOf((Object)new ObjectAnimator(totalDuration, n == null ? 0 : n, 0, RepeatMode.Restart, CollectionsKt.listOf(resultHolder)));
    }

    @NotNull
    public final List<Animator> component1() {
        return this.animators;
    }

    @NotNull
    public final Ordering component2() {
        return this.ordering;
    }

    @NotNull
    public final AnimatorSet copy(@NotNull List<? extends Animator> animators, @NotNull Ordering ordering) {
        Intrinsics.checkNotNullParameter(animators, (String)"animators");
        Intrinsics.checkNotNullParameter((Object)((Object)ordering), (String)"ordering");
        return new AnimatorSet(animators, ordering);
    }

    public static /* synthetic */ AnimatorSet copy$default(AnimatorSet animatorSet, List list, Ordering ordering, int n, Object object) {
        if ((n & 1) != 0) {
            list = animatorSet.animators;
        }
        if ((n & 2) != 0) {
            ordering = animatorSet.ordering;
        }
        return animatorSet.copy(list, ordering);
    }

    @NotNull
    public String toString() {
        return "AnimatorSet(animators=" + this.animators + ", ordering=" + (Object)((Object)this.ordering) + ')';
    }

    public int hashCode() {
        int result = ((Object)this.animators).hashCode();
        result = result * 31 + this.ordering.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnimatorSet)) {
            return false;
        }
        AnimatorSet animatorSet = (AnimatorSet)other;
        if (!Intrinsics.areEqual(this.animators, animatorSet.animators)) {
            return false;
        }
        return this.ordering == animatorSet.ordering;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Ordering.values().length];
            nArray[Ordering.Together.ordinal()] = 1;
            nArray[Ordering.Sequentially.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

