/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose;

import androidx.compose.Anchor;
import androidx.compose.GroupStart;
import androidx.compose.IntStack;
import androidx.compose.KeyInfo;
import androidx.compose.SlotTable;
import androidx.compose.SlotTableKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010(\u001a\u00020\fH\u0002J\u0006\u0010)\u001a\u00020*J\n\u0010+\u001a\u0004\u0018\u00010\fH\u0002J\u0006\u0010,\u001a\u00020*J\u0006\u0010-\u001a\u00020*J\u0006\u0010.\u001a\u00020*J\u0006\u0010/\u001a\u00020*J\f\u00100\u001a\b\u0012\u0004\u0012\u00020201J\u0010\u00103\u001a\u0004\u0018\u00010\u00012\u0006\u00104\u001a\u000205J\u0010\u00103\u001a\u0004\u0018\u00010\u00012\u0006\u00106\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u00106\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u00106\u001a\u00020\u0005J\b\u00107\u001a\u0004\u0018\u00010\u0001J\u000e\u00108\u001a\u00020*2\u0006\u00109\u001a\u00020\u0005J\u0006\u0010:\u001a\u00020\u0005J\u0006\u0010;\u001a\u00020\u0005J\u0006\u0010<\u001a\u00020*J\u000e\u0010=\u001a\u00020*2\u0006\u0010>\u001a\u00020\u0001J\u001c\u0010=\u001a\u00020*2\u0006\u0010>\u001a\u00020\u00012\n\u0010?\u001a\u00060\u0005j\u0002`@H\u0002J\u000e\u0010A\u001a\u00020*2\u0006\u0010>\u001a\u00020\u0001J\b\u0010B\u001a\u00020CH\u0016R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0018\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R\u001e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\bR\u0018\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010!X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\"R\u0014\u0010#\u001a\u00020\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006D"}, d2={"Landroidx/compose/SlotReader;", "", "table", "Landroidx/compose/SlotTable;", "<set-?>", "", "current", "getCurrent", "()I", "currentEnd", "getCurrentEnd", "currentGroup", "Landroidx/compose/GroupStart;", "emptyCount", "groupKey", "getGroupKey", "()Ljava/lang/Object;", "groupSize", "getGroupSize", "inEmpty", "", "getInEmpty", "()Z", "isGroup", "isGroupEnd", "isNode", "nodeIndex", "getNodeIndex", "nodeIndexStack", "Landroidx/compose/IntStack;", "parentNodes", "getParentNodes", "slots", "", "[Ljava/lang/Object;", "startStack", "getStartStack$compose_runtime_release", "()Landroidx/compose/IntStack;", "getTable", "()Landroidx/compose/SlotTable;", "assumeGroup", "beginEmpty", "", "calculateCurrentGroup", "close", "endEmpty", "endGroup", "endNode", "extractKeys", "", "Landroidx/compose/KeyInfo;", "get", "anchor", "Landroidx/compose/Anchor;", "index", "next", "reposition", "value", "skipGroup", "skipNode", "skipToGroupEnd", "startGroup", "key", "kind", "Landroidx/compose/GroupKind;", "startNode", "toString", "", "compose-runtime_release"})
public final class SlotReader {
    private final SlotTable table;
    private int current;
    private int currentEnd;
    private int nodeIndex;
    private final IntStack startStack;
    private final Object[] slots;
    private GroupStart currentGroup;
    private int emptyCount;
    private final IntStack nodeIndexStack;

    public SlotReader(@NotNull SlotTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        this.table = table;
        this.currentEnd = this.getTable().getSize();
        this.startStack = new IntStack();
        this.slots = this.getTable().getSlots$compose_runtime_release();
        this.nodeIndexStack = new IntStack();
        boolean bl = this.getTable().getGapStart$compose_runtime_release() == this.getCurrentEnd();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "Gap is not at the end of the slot table";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final SlotTable getTable() {
        return this.table;
    }

    public final int getCurrent() {
        return this.current;
    }

    public final int getCurrentEnd() {
        return this.currentEnd;
    }

    public final int getNodeIndex() {
        return this.nodeIndex;
    }

    @NotNull
    public final IntStack getStartStack$compose_runtime_release() {
        return this.startStack;
    }

    public final boolean isGroup() {
        return this.getCurrent() < this.getCurrentEnd() && this.calculateCurrentGroup() != null;
    }

    public final boolean isGroup(int index) {
        return this.slots[index] instanceof GroupStart;
    }

    public final boolean isNode() {
        GroupStart groupStart = this.calculateCurrentGroup();
        Boolean bl = groupStart == null ? (Boolean)null : Boolean.valueOf(groupStart.isNode());
        return bl == null ? false : bl;
    }

    public final boolean isGroupEnd() {
        return this.getInEmpty() || this.getCurrent() == this.getCurrentEnd();
    }

    public final boolean getInEmpty() {
        return this.emptyCount > 0;
    }

    public final int getGroupSize() {
        return this.assumeGroup().getSlots();
    }

    public final int groupSize(int index) {
        return SlotTableKt.access$getAsGroupStart$0(this.slots[index]).getSlots();
    }

    @NotNull
    public final Object getGroupKey() {
        Object object;
        if (this.getCurrent() < this.getCurrentEnd()) {
            Object object2;
            GroupStart groupStart = this.calculateCurrentGroup();
            Object object3 = object2 = groupStart == null ? null : groupStart.getKey();
            object = object2 == null ? SlotTableKt.getEMPTY() : object2;
        } else {
            object = SlotTableKt.getEMPTY();
        }
        return object;
    }

    @NotNull
    public final Object groupKey(int index) {
        return SlotTableKt.access$getAsGroupStart$0(this.slots[index]).getKey();
    }

    public final int getParentNodes() {
        return this.getStartStack$compose_runtime_release().isEmpty() ? 0 : SlotTableKt.access$getAsGroupStart$0(this.slots[this.getStartStack$compose_runtime_release().peek()]).getNodes();
    }

    @Nullable
    public final Object get(@NotNull Anchor anchor) {
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        return anchor.getLoc$compose_runtime_release() >= 0 ? this.slots[anchor.getLoc$compose_runtime_release()] : SlotTableKt.getEMPTY();
    }

    @Nullable
    public final Object get(int index) {
        return this.emptyCount > 0 ? SlotTableKt.getEMPTY() : this.slots[index];
    }

    @Nullable
    public final Object next() {
        Object object;
        if (this.emptyCount > 0) {
            return SlotTableKt.getEMPTY();
        }
        this.currentGroup = null;
        if (this.getCurrent() < this.getCurrentEnd()) {
            SlotReader slotReader = this;
            int n = slotReader.getCurrent();
            slotReader.current = n + 1;
            object = this.slots[n];
        } else {
            object = SlotTableKt.getEMPTY();
        }
        return object;
    }

    public final void beginEmpty() {
        SlotReader slotReader = this;
        int n = slotReader.emptyCount;
        slotReader.emptyCount = n + 1;
    }

    public final void endEmpty() {
        boolean bl = this.emptyCount > 0;
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            String string = "Unbalanced begin/end empty";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        SlotReader slotReader = this;
        n = slotReader.emptyCount;
        slotReader.emptyCount = n + -1;
    }

    public final void close() {
        this.getTable().close$compose_runtime_release(this);
    }

    public final void startGroup(@NotNull Object key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.startGroup(key, 0);
    }

    public final void startNode(@NotNull Object key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.startGroup(key, 1);
    }

    public final int skipGroup() {
        boolean bl = this.emptyCount == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "Cannot skip while in an empty region";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        GroupStart group = this.assumeGroup();
        SlotReader slotReader = this;
        slotReader.current = slotReader.getCurrent() + (group.getSlots() + 1);
        this.currentGroup = null;
        int count = group.isNode() ? 1 : group.getNodes();
        SlotReader slotReader2 = this;
        slotReader2.nodeIndex = slotReader2.getNodeIndex() + count;
        return count;
    }

    public final int skipNode() {
        return this.skipGroup();
    }

    public final void skipToGroupEnd() {
        boolean bl = this.emptyCount == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            String string = "Cannot skip the enclosing group while in an empty region";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.getStartStack$compose_runtime_release().isNotEmpty();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            String string = "No enclosing group to skip";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.nodeIndex = SlotTableKt.access$getAsGroupStart$0(this.slots[this.getStartStack$compose_runtime_release().peek()]).getNodes() + this.nodeIndexStack.peek();
        this.currentGroup = null;
        this.current = this.getCurrentEnd();
    }

    public final void reposition(int value) {
        this.current = value;
        this.currentGroup = null;
    }

    public final void endGroup() {
        block2: {
            if (this.emptyCount != 0) break block2;
            boolean bl = this.getCurrent() == this.getCurrentEnd();
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            int startLocation = this.getStartStack$compose_runtime_release().pop();
            if (this.getStartStack$compose_runtime_release().isEmpty()) {
                return;
            }
            int parentLocation = this.getStartStack$compose_runtime_release().peekOr(0);
            GroupStart group = SlotTableKt.access$getAsGroupStart$0(this.slots[startLocation]);
            GroupStart parentGroup = SlotTableKt.access$getAsGroupStart$0(this.slots[parentLocation]);
            this.nodeIndex = this.nodeIndexStack.pop() + (group.getKind() == 1 ? 1 : this.getNodeIndex());
            this.currentEnd = parentGroup.getSlots() + parentLocation + 1;
            this.currentGroup = null;
        }
    }

    public final void endNode() {
        this.endGroup();
    }

    @NotNull
    public final List<KeyInfo> extractKeys() {
        boolean bl = false;
        List result = new ArrayList();
        if (this.emptyCount > 0) {
            return result;
        }
        int oldCurrent = this.getCurrent();
        int oldNodeIndex = this.getNodeIndex();
        int index = 0;
        while (this.getCurrent() < this.getCurrentEnd()) {
            int location = this.getCurrent();
            Object key = SlotTableKt.access$getAsGroupStart$0(this.slots[location]).getKey();
            int n = index;
            index = n + 1;
            result.add(new KeyInfo(key, location, this.skipGroup(), n));
        }
        this.current = oldCurrent;
        this.nodeIndex = oldNodeIndex;
        return result;
    }

    @NotNull
    public String toString() {
        return "SlotReader(current=" + this.getCurrent() + ", emptyCount=" + this.emptyCount + ")";
    }

    private final void startGroup(Object key, int kind) {
        block2: {
            if (this.emptyCount > 0) break block2;
            this.getStartStack$compose_runtime_release().push(this.getCurrent());
            this.nodeIndexStack.push(this.getNodeIndex());
            this.nodeIndex = 0;
            GroupStart group = this.assumeGroup();
            this.currentEnd = this.getCurrent() + group.getSlots() + 1;
            boolean bl = group.getKind() == kind;
            int n = 0;
            boolean bl2 = false;
            if (!bl) {
                String string = "Group kind changed";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = Intrinsics.areEqual((Object)key, (Object)SlotTableKt.getEMPTY()) || Intrinsics.areEqual((Object)key, (Object)group.getKey());
            n = 0;
            bl2 = false;
            if (!bl) {
                String string = "Group key changed";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            SlotReader slotReader = this;
            n = slotReader.getCurrent();
            slotReader.current = n + 1;
            this.currentGroup = null;
        }
    }

    private final GroupStart calculateCurrentGroup() {
        GroupStart groupStart;
        GroupStart groupStart2;
        Object object;
        GroupStart groupStart3 = this.currentGroup;
        GroupStart groupStart4 = groupStart3 == null ? ((object = this.slots[this.getCurrent()]) instanceof GroupStart ? (GroupStart)object : null) : (groupStart2 = groupStart3);
        if (groupStart2 == null) {
            groupStart = null;
        } else {
            GroupStart it;
            groupStart3 = groupStart2;
            boolean bl = false;
            boolean bl2 = false;
            this.currentGroup = it = groupStart3;
            groupStart = groupStart3;
        }
        return groupStart;
    }

    private final GroupStart assumeGroup() {
        GroupStart groupStart = this.calculateCurrentGroup();
        if (groupStart == null) {
            String string = "Expected a group start";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return groupStart;
    }
}

