/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures.snapping;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.FinalSnappingItem;
import androidx.compose.foundation.gestures.snapping.LazyListSnapLayoutInfoProviderKt;
import androidx.compose.foundation.gestures.snapping.SnapLayoutInfoProvider;
import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.foundation.gestures.snapping.SnapPositionKt;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerLayoutInfo;
import androidx.compose.foundation.pager.PagerLayoutInfoKt;
import androidx.compose.foundation.pager.PagerSnapDistance;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.util.InlineClassHelper_commonStubsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a8\u0010\u0006\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0000\u001a\u0017\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\b\u001a\f\u0010\u0014\u001a\u00020\b*\u00020\u0003H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0003H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0016*\u00020\u0003H\u0002\u00a8\u0006\u0018"}, d2={"SnapLayoutInfoProvider", "Landroidx/compose/foundation/gestures/snapping/SnapLayoutInfoProvider;", "pagerState", "Landroidx/compose/foundation/pager/PagerState;", "pagerSnapDistance", "Landroidx/compose/foundation/pager/PagerSnapDistance;", "calculateFinalSnappingBound", "Lkotlin/Function3;", "", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "snapPositionalThreshold", "flingVelocity", "lowerBoundOffset", "upperBoundOffset", "debugLog", "", "generateMsg", "Lkotlin/Function0;", "", "dragGestureDelta", "isLtrDragging", "", "isScrollingForward", "foundation"})
@SourceDebugExtension(value={"SMAP\nPagerSnapLayoutInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerSnapLayoutInfoProvider.kt\nandroidx/compose/foundation/gestures/snapping/PagerSnapLayoutInfoProviderKt\n+ 2 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,301:1\n217#1,4:306\n217#1,4:311\n217#1,4:315\n217#1,4:319\n217#1,4:323\n65#2:302\n69#2:304\n60#3:303\n70#3:305\n1#4:310\n*S KotlinDebug\n*F\n+ 1 PagerSnapLayoutInfoProvider.kt\nandroidx/compose/foundation/gestures/snapping/PagerSnapLayoutInfoProviderKt\n*L\n245#1:306,4\n267#1:311,4\n277#1:315,4\n283#1:319,4\n287#1:323,4\n211#1:302\n213#1:304\n211#1:303\n213#1:305\n*E\n"})
public final class PagerSnapLayoutInfoProviderKt {
    @NotNull
    public static final SnapLayoutInfoProvider SnapLayoutInfoProvider(@NotNull PagerState pagerState, @NotNull PagerSnapDistance pagerSnapDistance, @NotNull Function3<? super Float, ? super Float, ? super Float, Float> calculateFinalSnappingBound) {
        return new SnapLayoutInfoProvider(pagerState, calculateFinalSnappingBound, pagerSnapDistance){
            final /* synthetic */ PagerState $pagerState;
            final /* synthetic */ Function3<Float, Float, Float, Float> $calculateFinalSnappingBound;
            final /* synthetic */ PagerSnapDistance $pagerSnapDistance;
            {
                this.$pagerState = $pagerState;
                this.$calculateFinalSnappingBound = $calculateFinalSnappingBound;
                this.$pagerSnapDistance = $pagerSnapDistance;
            }

            public final PagerLayoutInfo getLayoutInfo() {
                return this.$pagerState.getLayoutInfo();
            }

            public final boolean isValidDistance(float $this$isValidDistance) {
                return !($this$isValidDistance == Float.POSITIVE_INFINITY) && !($this$isValidDistance == Float.NEGATIVE_INFINITY);
            }

            /*
             * WARNING - void declaration
             */
            public float calculateSnapOffset(float velocity) {
                void value$iv;
                SnapPosition snapPosition = this.$pagerState.getLayoutInfo().getSnapPosition();
                Pair<Float, Float> pair = this.searchForSnappingBounds(snapPosition);
                float lowerBoundOffset = ((Number)pair.component1()).floatValue();
                float upperBoundOffset = ((Number)pair.component2()).floatValue();
                float finalDistance = ((Number)this.$calculateFinalSnappingBound.invoke((Object)Float.valueOf(velocity), (Object)Float.valueOf(lowerBoundOffset), (Object)Float.valueOf(upperBoundOffset))).floatValue();
                boolean bl = finalDistance == lowerBoundOffset || finalDistance == upperBoundOffset || finalDistance == 0.0f;
                boolean $i$f$checkPrecondition = false;
                if (value$iv == false) {
                    boolean bl2 = false;
                    InlineClassHelperKt.throwIllegalStateException("Final Snapping Offset Should Be one of " + lowerBoundOffset + ", " + upperBoundOffset + " or 0.0");
                }
                boolean $i$f$debugLog = false;
                return this.isValidDistance(finalDistance) ? finalDistance : 0.0f;
            }

            public float calculateApproachOffset(float velocity, float decayOffset) {
                float f;
                boolean $i$f$debugLog = false;
                int effectivePageSizePx = this.$pagerState.getPageSize$foundation() + this.$pagerState.getPageSpacing$foundation();
                if (effectivePageSizePx == 0) {
                    return 0.0f;
                }
                float animationOffsetPx = decayOffset;
                int startPage = velocity < 0.0f ? this.$pagerState.getFirstVisiblePage$foundation() + 1 : this.$pagerState.getFirstVisiblePage$foundation();
                boolean $i$f$debugLog2 = false;
                float pagesInAnimationOffset = animationOffsetPx / (float)effectivePageSizePx;
                boolean $i$f$debugLog3 = false;
                int targetPage2 = RangesKt.coerceIn((int)(startPage + (int)pagesInAnimationOffset), (int)0, (int)this.$pagerState.getPageCount());
                boolean $i$f$debugLog4 = false;
                int correctedTargetPage = RangesKt.coerceIn((int)this.$pagerSnapDistance.calculateTargetPage(startPage, targetPage2, velocity, this.$pagerState.getPageSize$foundation(), this.$pagerState.getPageSpacing$foundation()), (int)0, (int)this.$pagerState.getPageCount());
                boolean $i$f$debugLog5 = false;
                int proposedFlingOffset = (correctedTargetPage - startPage) * effectivePageSizePx;
                boolean $i$f$debugLog6 = false;
                int flingApproachOffsetPx = RangesKt.coerceAtLeast((int)(Math.abs(proposedFlingOffset) - effectivePageSizePx), (int)0);
                float it = f = flingApproachOffsetPx == 0 ? (float)flingApproachOffsetPx : (float)flingApproachOffsetPx * Math.signum(velocity);
                boolean bl = false;
                boolean $i$f$debugLog7 = false;
                return f;
            }

            /*
             * WARNING - void declaration
             */
            private final Pair<Float, Float> searchForSnappingBounds(SnapPosition snapPosition) {
                boolean isDragging;
                void $this$fastForEach$iv;
                boolean $i$f$debugLog = false;
                float lowerBoundOffset = 0.0f;
                lowerBoundOffset = Float.NEGATIVE_INFINITY;
                float upperBoundOffset = 0.0f;
                upperBoundOffset = Float.POSITIVE_INFINITY;
                List<PageInfo> list = this.getLayoutInfo().getVisiblePagesInfo();
                PagerState pagerState = this.$pagerState;
                boolean $i$f$fastForEach = false;
                int n = ((Collection)$this$fastForEach$iv).size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    E item$iv = $this$fastForEach$iv.get(index$iv);
                    PageInfo page = (PageInfo)item$iv;
                    boolean bl = false;
                    float offset = SnapPositionKt.calculateDistanceToDesiredSnapPosition(PagerLayoutInfoKt.getMainAxisViewportSize(this.getLayoutInfo()), this.getLayoutInfo().getBeforeContentPadding(), this.getLayoutInfo().getAfterContentPadding(), this.getLayoutInfo().getPageSize(), page.getOffset(), page.getIndex(), snapPosition, pagerState.getPageCount());
                    if (offset <= 0.0f && offset > lowerBoundOffset) {
                        lowerBoundOffset = offset;
                    }
                    if (!(offset >= 0.0f) || !(offset < upperBoundOffset)) continue;
                    upperBoundOffset = offset;
                }
                if (lowerBoundOffset == Float.NEGATIVE_INFINITY) {
                    lowerBoundOffset = upperBoundOffset;
                }
                if (upperBoundOffset == Float.POSITIVE_INFINITY) {
                    upperBoundOffset = lowerBoundOffset;
                }
                boolean bl = isDragging = !(PagerSnapLayoutInfoProviderKt.access$dragGestureDelta(this.$pagerState) == 0.0f);
                if (!this.$pagerState.getCanScrollForward()) {
                    upperBoundOffset = 0.0f;
                    if (isDragging && PagerSnapLayoutInfoProviderKt.access$isScrollingForward(this.$pagerState)) {
                        lowerBoundOffset = 0.0f;
                    }
                }
                if (!this.$pagerState.getCanScrollBackward()) {
                    lowerBoundOffset = 0.0f;
                    if (isDragging && !PagerSnapLayoutInfoProviderKt.access$isScrollingForward(this.$pagerState)) {
                        upperBoundOffset = 0.0f;
                    }
                }
                return TuplesKt.to((Object)Float.valueOf(lowerBoundOffset), (Object)Float.valueOf(upperBoundOffset));
            }
        };
    }

    private static final boolean isLtrDragging(PagerState $this$isLtrDragging) {
        return PagerSnapLayoutInfoProviderKt.dragGestureDelta($this$isLtrDragging) > 0.0f;
    }

    private static final boolean isScrollingForward(PagerState $this$isScrollingForward) {
        boolean reverseScrollDirection = $this$isScrollingForward.getLayoutInfo().getReverseLayout();
        return PagerSnapLayoutInfoProviderKt.isLtrDragging($this$isScrollingForward) && reverseScrollDirection || !PagerSnapLayoutInfoProviderKt.isLtrDragging($this$isScrollingForward) && !reverseScrollDirection;
    }

    private static final float dragGestureDelta(PagerState $this$dragGestureDelta) {
        float f;
        if ($this$dragGestureDelta.getLayoutInfo().getOrientation() == Orientation.Horizontal) {
            long arg0$iv = $this$dragGestureDelta.getUpDownDifference-F1C5BW0$foundation();
            boolean bl = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat1 = false;
            f = InlineClassHelper_commonStubsKt.floatFromBits((int)((int)(value$iv$iv >> 32)));
        } else {
            long arg0$iv = $this$dragGestureDelta.getUpDownDifference-F1C5BW0$foundation();
            boolean bl = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat2 = false;
            f = InlineClassHelper_commonStubsKt.floatFromBits((int)((int)(value$iv$iv & 0xFFFFFFFFL)));
        }
        return f;
    }

    private static final void debugLog(Function0<String> generateMsg) {
        boolean $i$f$debugLog = false;
    }

    public static final float calculateFinalSnappingBound(@NotNull PagerState pagerState, @NotNull LayoutDirection layoutDirection, float snapPositionalThreshold, float flingVelocity, float lowerBoundOffset, float upperBoundOffset) {
        float f;
        boolean isForward = pagerState.getLayoutInfo().getOrientation() == Orientation.Vertical ? PagerSnapLayoutInfoProviderKt.isScrollingForward(pagerState) : (layoutDirection == LayoutDirection.Ltr ? PagerSnapLayoutInfoProviderKt.isScrollingForward(pagerState) : !PagerSnapLayoutInfoProviderKt.isScrollingForward(pagerState));
        boolean $i$f$debugLog = false;
        int pageSize = pagerState.getLayoutInfo().getPageSize();
        float offsetFromSnappedPosition = pageSize == 0 ? 0.0f : PagerSnapLayoutInfoProviderKt.dragGestureDelta(pagerState) / (float)pageSize;
        float offsetFromSnappedPositionOverflow = offsetFromSnappedPosition - (float)((int)offsetFromSnappedPosition);
        Density $this$calculateFinalSnappingBound_u24lambda_u241 = pagerState.getDensity$foundation();
        boolean bl = false;
        int finalSnappingItem = LazyListSnapLayoutInfoProviderKt.calculateFinalSnappingItem($this$calculateFinalSnappingBound_u24lambda_u241, flingVelocity);
        boolean $i$f$debugLog2 = false;
        int n = finalSnappingItem;
        if (FinalSnappingItem.equals-impl0(n, FinalSnappingItem.Companion.getClosestItem-bbeMdSM())) {
            if (Math.abs(offsetFromSnappedPositionOverflow) > snapPositionalThreshold) {
                boolean $i$f$debugLog3 = false;
                f = isForward ? upperBoundOffset : lowerBoundOffset;
            } else if (Math.abs(offsetFromSnappedPosition) >= Math.abs(pagerState.getPositionThresholdFraction$foundation())) {
                boolean $i$f$debugLog4 = false;
                f = isForward ? lowerBoundOffset : upperBoundOffset;
            } else {
                boolean $i$f$debugLog5 = false;
                f = Math.abs(lowerBoundOffset) < Math.abs(upperBoundOffset) ? lowerBoundOffset : upperBoundOffset;
            }
        } else {
            f = FinalSnappingItem.equals-impl0(n, FinalSnappingItem.Companion.getNextItem-bbeMdSM()) ? upperBoundOffset : (FinalSnappingItem.equals-impl0(n, FinalSnappingItem.Companion.getPreviousItem-bbeMdSM()) ? lowerBoundOffset : 0.0f);
        }
        return f;
    }

    public static final /* synthetic */ float access$dragGestureDelta(PagerState $receiver) {
        return PagerSnapLayoutInfoProviderKt.dragGestureDelta($receiver);
    }

    public static final /* synthetic */ boolean access$isScrollingForward(PagerState $receiver) {
        return PagerSnapLayoutInfoProviderKt.isScrollingForward($receiver);
    }
}

