/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.annotation.FloatRange;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.SuspendAnimationKt;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollScope;
import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.foundation.lazy.layout.LazyLayoutScrollScope;
import androidx.compose.foundation.pager.DefaultPagerState;
import androidx.compose.foundation.pager.PagerLayoutInfo;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.foundation.pager.PagerStateKt;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.saveable.RememberSaveableKt;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.ui.layout.AlignmentLine;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000m\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\r\u001a(\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\n2\b\b\u0003\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015\u001a\u0017\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0015H\u0082\b\u001a/\u0010\u001a\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\n2\b\b\u0003\u0010\u001c\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0007\u00a2\u0006\u0002\u0010\u001d\u001aW\u0010\u001e\u001a\u00020\u0017*\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00132\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130#2\u001d\u0010$\u001a\u0019\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170%\u00a2\u0006\u0002\b'2\u0006\u0010(\u001a\u00020&H\u0082@\u00a2\u0006\u0002\u0010)\u001a\u0012\u0010*\u001a\u00020\u0017*\u00020\u0010H\u0080@\u00a2\u0006\u0002\u0010+\u001a\u0012\u0010,\u001a\u00020\u0017*\u00020\u0010H\u0080@\u00a2\u0006\u0002\u0010+\u001a\u0014\u0010-\u001a\u00020.*\u00020/2\u0006\u0010\u0014\u001a\u00020\nH\u0000\u001a\u0014\u00100\u001a\u00020.*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\nH\u0002\"\u0016\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0004\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u00061"}, d2={"DefaultPositionThreshold", "Landroidx/compose/ui/unit/Dp;", "getDefaultPositionThreshold", "()F", "F", "EmptyLayoutInfo", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "getEmptyLayoutInfo", "()Landroidx/compose/foundation/pager/PagerMeasureResult;", "MaxPagesForAnimateScroll", "", "PagesToPrefetch", "UnitDensity", "androidx/compose/foundation/pager/PagerStateKt$UnitDensity$1", "Landroidx/compose/foundation/pager/PagerStateKt$UnitDensity$1;", "PagerState", "Landroidx/compose/foundation/pager/PagerState;", "currentPage", "currentPageOffsetFraction", "", "pageCount", "Lkotlin/Function0;", "debugLog", "", "generateMsg", "", "rememberPagerState", "initialPage", "initialPageOffsetFraction", "(IFLkotlin/jvm/functions/Function0;Landroidx/compose/runtime/Composer;II)Landroidx/compose/foundation/pager/PagerState;", "animateScrollToPage", "Landroidx/compose/foundation/lazy/layout/LazyLayoutScrollScope;", "targetPage", "targetPageOffsetToSnappedPosition", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "updateTargetPage", "Lkotlin/Function2;", "Landroidx/compose/foundation/gestures/ScrollScope;", "Lkotlin/ExtensionFunctionType;", "scrollScope", "(Landroidx/compose/foundation/lazy/layout/LazyLayoutScrollScope;IFLandroidx/compose/animation/core/AnimationSpec;Lkotlin/jvm/functions/Function2;Landroidx/compose/foundation/gestures/ScrollScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "animateToNextPage", "(Landroidx/compose/foundation/pager/PagerState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "animateToPreviousPage", "calculateNewMaxScrollOffset", "", "Landroidx/compose/foundation/pager/PagerLayoutInfo;", "calculateNewMinScrollOffset", "foundation"})
@SourceDebugExtension(value={"SMAP\nPagerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerState.kt\nandroidx/compose/foundation/pager/PagerStateKt\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 6 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,957:1\n858#1,4:969\n858#1,4:977\n858#1,4:981\n1166#2,6:958\n1#3:964\n54#4:965\n59#4:967\n54#4:973\n59#4:975\n85#5:966\n90#5:968\n85#5:974\n90#5:976\n109#6:985\n*S KotlinDebug\n*F\n+ 1 PagerState.kt\nandroidx/compose/foundation/pager/PagerStateKt\n*L\n888#1:969,4\n936#1:977,4\n947#1:981,4\n89#1:958,6\n868#1:965\n868#1:967\n898#1:973\n898#1:975\n868#1:966\n868#1:968\n898#1:974\n898#1:976\n815#1:985\n*E\n"})
public final class PagerStateKt {
    private static final float DefaultPositionThreshold;
    private static final int MaxPagesForAnimateScroll = 3;
    public static final int PagesToPrefetch = 1;
    @NotNull
    private static final PagerMeasureResult EmptyLayoutInfo;
    @NotNull
    private static final UnitDensity.1 UnitDensity;

    /*
     * WARNING - void declaration
     */
    @Composable
    @NotNull
    public static final PagerState rememberPagerState(int initialPage, @FloatRange(from=-0.5, to=0.5) float initialPageOffsetFraction, @NotNull Function0<Integer> pageCount, @Nullable Composer $composer, int $changed, int n) {
        Object object;
        void $this$cache$iv;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)-1210768637, (String)"C(rememberPagerState)*88@4038L92,88@3988L142:PagerState.kt#g6yjnt");
        if ((n & 1) != 0) {
            initialPage = 0;
        }
        if ((n & 2) != 0) {
            initialPageOffsetFraction = 0.0f;
        }
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-1210768637, (int)$changed, (int)-1, (String)"androidx.compose.foundation.pager.rememberPagerState (PagerState.kt:87)");
        }
        Object[] objectArray = new Object[]{};
        Saver<DefaultPagerState, ?> saver2 = DefaultPagerState.Companion.getSaver();
        String string = null;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)17134108, (String)"CC(remember):PagerState.kt#9igjgp");
        Composer composer = $composer;
        boolean invalid$iv = (($changed & 0xE ^ 6) > 4 && $composer.changed(initialPage) || ($changed & 6) == 4) | (($changed & 0x70 ^ 0x30) > 32 && $composer.changed(initialPageOffsetFraction) || ($changed & 0x30) == 32) | (($changed & 0x380 ^ 0x180) > 256 && $composer.changed(pageCount) || ($changed & 0x180) == 256);
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv.rememberedValue();
        boolean bl = false;
        if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
            String string2 = string;
            Saver<DefaultPagerState, ?> saver3 = saver2;
            Object[] objectArray2 = objectArray;
            boolean bl2 = false;
            Function0 function0 = (Function0)new Function0<DefaultPagerState>(initialPage, initialPageOffsetFraction, pageCount){
                final /* synthetic */ int $initialPage;
                final /* synthetic */ float $initialPageOffsetFraction;
                final /* synthetic */ Function0<Integer> $pageCount;
                {
                    this.$initialPage = $initialPage;
                    this.$initialPageOffsetFraction = $initialPageOffsetFraction;
                    this.$pageCount = $pageCount;
                    super(0);
                }

                public final DefaultPagerState invoke() {
                    return new DefaultPagerState(this.$initialPage, this.$initialPageOffsetFraction, this.$pageCount);
                }
            };
            objectArray = objectArray2;
            saver2 = saver3;
            string = string2;
            Function0 value$iv = function0;
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv;
        }
        Object object2 = (Function0)object;
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        object2 = RememberSaveableKt.rememberSaveable((Object[])objectArray, saver2, string, (Function0)object2, (Composer)$composer, (int)0, (int)4);
        DefaultPagerState $this$rememberPagerState_u24lambda_u241 = (DefaultPagerState)object2;
        boolean bl3 = false;
        $this$rememberPagerState_u24lambda_u241.getPageCountState().setValue(pageCount);
        DefaultPagerState defaultPagerState = (DefaultPagerState)object2;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        return defaultPagerState;
    }

    @NotNull
    public static final PagerState PagerState(int currentPage, @FloatRange(from=-0.5, to=0.5) float currentPageOffsetFraction, @NotNull Function0<Integer> pageCount) {
        return new DefaultPagerState(currentPage, currentPageOffsetFraction, pageCount);
    }

    public static /* synthetic */ PagerState PagerState$default(int n, float f, Function0 function0, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        return PagerStateKt.PagerState(n, f, (Function0<Integer>)function0);
    }

    @Nullable
    public static final Object animateToNextPage(@NotNull PagerState $this$animateToNextPage, @NotNull Continuation<? super Unit> $completion) {
        if ($this$animateToNextPage.getCurrentPage() + 1 < $this$animateToNextPage.getPageCount()) {
            Object object = PagerState.animateScrollToPage$default($this$animateToNextPage, $this$animateToNextPage.getCurrentPage() + 1, 0.0f, null, $completion, 6, null);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object animateToPreviousPage(@NotNull PagerState $this$animateToPreviousPage, @NotNull Continuation<? super Unit> $completion) {
        if ($this$animateToPreviousPage.getCurrentPage() - 1 >= 0) {
            Object object = PagerState.animateScrollToPage$default($this$animateToPreviousPage, $this$animateToPreviousPage.getCurrentPage() - 1, 0.0f, null, $completion, 6, null);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public static final float getDefaultPositionThreshold() {
        return DefaultPositionThreshold;
    }

    @NotNull
    public static final PagerMeasureResult getEmptyLayoutInfo() {
        return EmptyLayoutInfo;
    }

    private static final void debugLog(Function0<String> generateMsg) {
        boolean $i$f$debugLog = false;
    }

    public static final long calculateNewMaxScrollOffset(@NotNull PagerLayoutInfo $this$calculateNewMaxScrollOffset, int pageCount) {
        int n;
        long value$iv$iv;
        long arg0$iv;
        int pageSizeWithSpacing = $this$calculateNewMaxScrollOffset.getPageSpacing() + $this$calculateNewMaxScrollOffset.getPageSize();
        long maxScrollPossible = (long)pageCount * (long)pageSizeWithSpacing + (long)$this$calculateNewMaxScrollOffset.getBeforeContentPadding() + (long)$this$calculateNewMaxScrollOffset.getAfterContentPadding();
        if ($this$calculateNewMaxScrollOffset.getOrientation() == Orientation.Horizontal) {
            arg0$iv = $this$calculateNewMaxScrollOffset.getViewportSize-YbymL2g();
            boolean bl = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt1 = false;
            n = (int)(value$iv$iv >> 32);
        } else {
            arg0$iv = $this$calculateNewMaxScrollOffset.getViewportSize-YbymL2g();
            boolean bl = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt2 = false;
            n = (int)(value$iv$iv & 0xFFFFFFFFL);
        }
        int layoutSize = n;
        SnapPosition snapPosition = $this$calculateNewMaxScrollOffset.getSnapPosition();
        int n2 = $this$calculateNewMaxScrollOffset.getPageSize();
        int n3 = pageCount - 1;
        int n4 = $this$calculateNewMaxScrollOffset.getBeforeContentPadding();
        int n5 = $this$calculateNewMaxScrollOffset.getAfterContentPadding();
        int snapPositionDiscount = layoutSize - RangesKt.coerceIn((int)snapPosition.position(layoutSize, n2, n4, n5, n3, pageCount), (int)0, (int)layoutSize);
        boolean $i$f$debugLog = false;
        return RangesKt.coerceAtLeast((long)(maxScrollPossible - (long)snapPositionDiscount), (long)0L);
    }

    private static final long calculateNewMinScrollOffset(PagerMeasureResult $this$calculateNewMinScrollOffset, int pageCount) {
        int n;
        long value$iv$iv;
        long arg0$iv;
        if ($this$calculateNewMinScrollOffset.getOrientation() == Orientation.Horizontal) {
            arg0$iv = $this$calculateNewMinScrollOffset.getViewportSize-YbymL2g();
            boolean bl = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt1 = false;
            n = (int)(value$iv$iv >> 32);
        } else {
            arg0$iv = $this$calculateNewMinScrollOffset.getViewportSize-YbymL2g();
            boolean bl = false;
            value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt2 = false;
            n = (int)(value$iv$iv & 0xFFFFFFFFL);
        }
        int layoutSize = n;
        SnapPosition snapPosition = $this$calculateNewMinScrollOffset.getSnapPosition();
        int n2 = $this$calculateNewMinScrollOffset.getPageSize();
        int n3 = $this$calculateNewMinScrollOffset.getBeforeContentPadding();
        int n4 = $this$calculateNewMinScrollOffset.getAfterContentPadding();
        return RangesKt.coerceIn((int)snapPosition.position(layoutSize, n2, n3, n4, 0, pageCount), (int)0, (int)layoutSize);
    }

    private static final Object animateScrollToPage(LazyLayoutScrollScope $this$animateScrollToPage, int targetPage2, float targetPageOffsetToSnappedPosition, AnimationSpec<Float> animationSpec, Function2<? super ScrollScope, ? super Integer, Unit> updateTargetPage, ScrollScope scrollScope2, Continuation<? super Unit> $completion) {
        boolean $i$f$debugLog;
        ScrollScope $this$animateScrollToPage_u24lambda_u245 = scrollScope2;
        boolean bl = false;
        updateTargetPage.invoke((Object)$this$animateScrollToPage_u24lambda_u245, (Object)Boxing.boxInt((int)targetPage2));
        boolean forward = targetPage2 > $this$animateScrollToPage.getFirstVisibleItemIndex();
        int visiblePages = $this$animateScrollToPage.getLastVisibleItemIndex() - $this$animateScrollToPage.getFirstVisibleItemIndex() + 1;
        if ((forward && targetPage2 > $this$animateScrollToPage.getLastVisibleItemIndex() || !forward && targetPage2 < $this$animateScrollToPage.getFirstVisibleItemIndex()) && Math.abs(targetPage2 - $this$animateScrollToPage.getFirstVisibleItemIndex()) >= 3) {
            int preJumpPosition = forward ? RangesKt.coerceAtLeast((int)(targetPage2 - visiblePages), (int)$this$animateScrollToPage.getFirstVisibleItemIndex()) : RangesKt.coerceAtMost((int)(targetPage2 + visiblePages), (int)$this$animateScrollToPage.getFirstVisibleItemIndex());
            $i$f$debugLog = false;
            $this$animateScrollToPage.snapToItem(preJumpPosition, 0);
        }
        float displacement = (float)LazyLayoutScrollScope.calculateDistanceTo$default($this$animateScrollToPage, targetPage2, 0, 2, null) + targetPageOffsetToSnappedPosition;
        $i$f$debugLog = false;
        Ref.FloatRef previousValue = new Ref.FloatRef();
        Object object = SuspendAnimationKt.animate$default((float)0.0f, (float)displacement, (float)0.0f, animationSpec, (Function2)((Function2)new Function2<Float, Float, Unit>(previousValue, $this$animateScrollToPage_u24lambda_u245){
            final /* synthetic */ Ref.FloatRef $previousValue;
            final /* synthetic */ ScrollScope $this_with;
            {
                this.$previousValue = $previousValue;
                this.$this_with = $receiver;
                super(2);
            }

            public final void invoke(float currentValue, float f) {
                float delta = currentValue - this.$previousValue.element;
                float consumed = this.$this_with.scrollBy(delta);
                boolean $i$f$debugLog = false;
                this.$previousValue.element += consumed;
            }
        }), $completion, (int)4, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ UnitDensity.1 access$getUnitDensity$p() {
        return UnitDensity;
    }

    public static final /* synthetic */ Object access$animateScrollToPage(LazyLayoutScrollScope $receiver, int targetPage2, float targetPageOffsetToSnappedPosition, AnimationSpec animationSpec, Function2 updateTargetPage, ScrollScope scrollScope2, Continuation $completion) {
        return PagerStateKt.animateScrollToPage($receiver, targetPage2, targetPageOffsetToSnappedPosition, (AnimationSpec<Float>)animationSpec, (Function2<? super ScrollScope, ? super Integer, Unit>)updateTargetPage, scrollScope2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ long access$calculateNewMinScrollOffset(PagerMeasureResult $receiver, int pageCount) {
        return PagerStateKt.calculateNewMinScrollOffset($receiver, pageCount);
    }

    static {
        int $this$dp$iv = 56;
        boolean $i$f$getDp = false;
        DefaultPositionThreshold = Dp.constructor-impl((float)$this$dp$iv);
        List list = CollectionsKt.emptyList();
        Orientation orientation = Orientation.Horizontal;
        SnapPosition.Start start = SnapPosition.Start.INSTANCE;
        MeasureResult measureResult2 = new MeasureResult(){
            private final int width;
            private final int height;
            private final Map<AlignmentLine, Integer> alignmentLines;
            {
                this.alignmentLines = MapsKt.emptyMap();
            }

            public int getWidth() {
                return this.width;
            }

            public int getHeight() {
                return this.height;
            }

            public Map<AlignmentLine, Integer> getAlignmentLines() {
                return this.alignmentLines;
            }

            public static /* synthetic */ void getAlignmentLines$annotations() {
            }

            public void placeChildren() {
            }
        };
        CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)EmptyCoroutineContext.INSTANCE));
        EmptyLayoutInfo = new PagerMeasureResult(list, 0, 0, 0, orientation, 0, 0, false, 0, null, null, 0.0f, 0, false, start, measureResult2, false, null, null, coroutineScope, 393216, null);
        UnitDensity = new Density(){
            private final float density;
            private final float fontScale;
            {
                this.density = 1.0f;
                this.fontScale = 1.0f;
            }

            public float getDensity() {
                return this.density;
            }

            public float getFontScale() {
                return this.fontScale;
            }
        };
    }
}

